/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;

public class ODatabaseFactory {
    final WeakHashMap<ODatabaseInternal<?>, Thread> instances = new WeakHashMap();

    public synchronized List<ODatabase<?>> getInstances(String iDatabaseName) {
        ArrayList result = new ArrayList();
        for (ODatabase oDatabase : this.instances.keySet()) {
            if (oDatabase == null || !oDatabase.getName().equals(iDatabaseName)) continue;
            result.add(oDatabase);
        }
        return result;
    }

    public synchronized ODatabase<?> register(ODatabaseInternal<?> db) {
        this.instances.put(db, Thread.currentThread());
        return db;
    }

    public synchronized void unregister(ODatabaseInternal<?> db) {
        this.instances.remove(db);
    }

    public synchronized void unregister(OStorage iStorage) {
        for (ODatabaseInternal<?> db : new HashSet(this.instances.keySet())) {
            if (db == null || db.getStorage() != iStorage) continue;
            db.close();
            this.instances.remove(db);
        }
    }

    public synchronized void shutdown() {
        if (this.instances.size() > 0) {
            OLogManager.instance().debug(null, "Found %d databases opened during OrientDB shutdown. Assure to always close database instances after usage", this.instances.size());
            for (ODatabase oDatabase : new HashSet(this.instances.keySet())) {
                oDatabase.activateOnCurrentThread();
                if (oDatabase == null || oDatabase.isClosed()) continue;
                oDatabase.close();
            }
        }
    }

    public ODatabaseDocumentTx createDatabase(String iType, String url) {
        if (iType.equals("graph")) {
            return new ODatabaseDocumentTx(url){

                @Override
                public <THISDB extends ODatabase> THISDB create() {
                    Object db = super.create();
                    ODatabaseFactory.this.checkSchema((ODatabase<?>)db);
                    return (THISDB)db;
                }

                @Override
                public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
                    Object db = super.open(iUserName, iUserPassword);
                    ODatabaseFactory.this.checkSchema((ODatabase<?>)db);
                    return (THISDB)db;
                }

                @Override
                public <THISDB extends ODatabase> THISDB open(OToken iToken) {
                    Object db = super.open(iToken);
                    ODatabaseFactory.this.checkSchema((ODatabase<?>)db);
                    return (THISDB)db;
                }
            };
        }
        return new ODatabaseDocumentTx(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchema(ODatabase<?> iDatabase) {
        OScenarioThreadLocal.INSTANCE.set(OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED);
        try {
            OClass edgeBaseClass;
            OClass vertexBaseClass;
            OSchema schema = iDatabase.getMetadata().getSchema();
            try {
                vertexBaseClass = schema.getOrCreateClass("V");
            }
            catch (OException e) {
                schema.reload();
                vertexBaseClass = schema.getOrCreateClass("V");
            }
            try {
                edgeBaseClass = schema.getOrCreateClass("E");
            }
            catch (OException e) {
                schema.reload();
                edgeBaseClass = schema.getOrCreateClass("E");
            }
            assert (edgeBaseClass != null);
            assert (vertexBaseClass != null);
            if (vertexBaseClass.getOverSize() < 2.0f) {
                vertexBaseClass.setOverSize(2.0f);
            }
        }
        finally {
            OScenarioThreadLocal.INSTANCE.set(OScenarioThreadLocal.RUN_MODE.DEFAULT);
        }
    }
}

