/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class ORecordIteratorClusters<REC extends ORecord>
extends OIdentifiableIterator<REC> {
    protected int[] clusterIds;
    protected int currentClusterIdx;
    protected ORecord currentRecord;
    protected ORID beginRange;
    protected ORID endRange;

    public ORecordIteratorClusters(ODatabaseDocumentInternal iDatabase, ODatabaseDocumentInternal iLowLevelDatabase, int[] iClusterIds) {
        this(iDatabase, iLowLevelDatabase, iClusterIds, false, OStorage.LOCKING_STRATEGY.NONE);
    }

    @Deprecated
    public ORecordIteratorClusters(ODatabaseDocumentInternal iDatabase, ODatabaseDocumentInternal iLowLevelDatabase, int[] iClusterIds, boolean iterateThroughTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        super(iDatabase, iLowLevelDatabase, iterateThroughTombstones, iLockingStrategy);
        this.checkForSystemClusters(iDatabase, iClusterIds);
        this.clusterIds = iClusterIds;
        Arrays.sort(this.clusterIds);
        this.config();
    }

    @Deprecated
    protected ORecordIteratorClusters(ODatabaseDocumentInternal iDatabase, ODatabaseDocumentInternal iLowLevelDatabase, boolean iterateThroughTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        super(iDatabase, iLowLevelDatabase, iterateThroughTombstones, iLockingStrategy);
    }

    public ORecordIteratorClusters<REC> setRange(ORID iBegin, ORID iEnd) {
        this.beginRange = iBegin;
        this.endRange = iEnd;
        if (this.currentRecord != null && this.outsideOfTheRange(this.currentRecord.getIdentity())) {
            this.currentRecord = null;
        }
        this.updateClusterRange();
        this.begin();
        return this;
    }

    @Override
    public boolean hasPrevious() {
        this.checkDirection(false);
        if (this.currentRecord != null) {
            return true;
        }
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.liveUpdated) {
            this.updateClusterRange();
        }
        ORecord record = this.getRecord();
        while (this.currentClusterIdx > -1) {
            while (this.prevPosition()) {
                this.currentRecord = this.readCurrentRecord(record, 0);
                if (this.currentRecord == null || !this.include(this.currentRecord)) continue;
                return true;
            }
            --this.currentClusterIdx;
            this.updateClusterRange();
        }
        if (this.txEntries != null && this.txEntries.size() - (this.currentTxEntryPosition + 1) > 0) {
            return true;
        }
        this.currentRecord = null;
        return false;
    }

    @Override
    public boolean hasNext() {
        this.checkDirection(true);
        if (Thread.interrupted()) {
            return false;
        }
        if (this.currentRecord != null) {
            return true;
        }
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.liveUpdated) {
            this.updateClusterRange();
        }
        ORecord record = this.getRecord();
        while (this.currentClusterIdx < this.clusterIds.length) {
            while (this.nextPosition()) {
                if (this.outsideOfTheRange(this.current)) continue;
                try {
                    this.currentRecord = this.readCurrentRecord(record, 0);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error during read of record.", (Throwable)e, new Object[0]);
                    this.currentRecord = null;
                }
                if (this.currentRecord == null || !this.include(this.currentRecord)) continue;
                return true;
            }
            ++this.currentClusterIdx;
            if (this.currentClusterIdx >= this.clusterIds.length) break;
            this.updateClusterRange();
        }
        if (this.txEntries != null && this.txEntries.size() - (this.currentTxEntryPosition + 1) > 0) {
            return true;
        }
        this.currentRecord = null;
        return false;
    }

    @Override
    public REC next() {
        ORecord record;
        this.checkDirection(true);
        if (this.currentRecord != null) {
            try {
                ORecord oRecord = this.currentRecord;
                return (REC)oRecord;
            }
            finally {
                this.currentRecord = null;
            }
        }
        while (this.hasNext()) {
            if (this.currentRecord != null) {
                try {
                    ORecord oRecord = this.currentRecord;
                    return (REC)oRecord;
                }
                finally {
                    this.currentRecord = null;
                }
            }
            record = this.getTransactionEntry();
            if (record == null) {
                record = this.readCurrentRecord(null, 1);
            }
            if (record == null || !this.include(record)) continue;
            return (REC)record;
        }
        record = this.getTransactionEntry();
        if (record != null) {
            return (REC)record;
        }
        throw new NoSuchElementException("Direction: forward, last position was: " + this.current + ", range: " + this.beginRange + "-" + this.endRange);
    }

    public REC previous() {
        this.checkDirection(false);
        if (this.currentRecord != null) {
            try {
                ORecord oRecord = this.currentRecord;
                return (REC)oRecord;
            }
            finally {
                this.currentRecord = null;
            }
        }
        ORecord record = this.getRecord();
        while (this.hasPrevious()) {
            if (this.currentRecord != null) {
                try {
                    ORecord oRecord = this.currentRecord;
                    return (REC)oRecord;
                }
                finally {
                    this.currentRecord = null;
                }
            }
            if (record == null) {
                record = this.readCurrentRecord(null, -1);
            }
            if (record == null || !this.include(record)) continue;
            return (REC)record;
        }
        record = this.getTransactionEntry();
        if (record != null) {
            return (REC)record;
        }
        return null;
    }

    @Override
    public ORecordIteratorClusters<REC> begin() {
        if (this.clusterIds.length == 0) {
            return this;
        }
        this.browsedRecords = 0L;
        this.currentClusterIdx = 0;
        this.current.clusterId = this.clusterIds[this.currentClusterIdx];
        if (this.liveUpdated) {
            this.updateClusterRange();
        }
        this.resetCurrentPosition();
        this.nextPosition();
        ORecord record = this.getRecord();
        this.currentRecord = this.readCurrentRecord(record, 0);
        if (this.currentRecord != null && !this.include(this.currentRecord)) {
            this.currentRecord = null;
            this.hasNext();
        }
        return this;
    }

    @Override
    public ORecordIteratorClusters<REC> last() {
        if (this.clusterIds.length == 0) {
            return this;
        }
        this.browsedRecords = 0L;
        this.currentClusterIdx = this.clusterIds.length - 1;
        if (this.liveUpdated) {
            this.updateClusterRange();
        }
        this.current.clusterId = this.clusterIds[this.currentClusterIdx];
        this.resetCurrentPosition();
        this.prevPosition();
        ORecord record = this.getRecord();
        this.currentRecord = this.readCurrentRecord(record, 0);
        if (this.currentRecord != null && !this.include(this.currentRecord)) {
            this.currentRecord = null;
            this.hasPrevious();
        }
        return this;
    }

    @Override
    public ORecordIteratorClusters<REC> setLiveUpdated(boolean iLiveUpdated) {
        super.setLiveUpdated(iLiveUpdated);
        if (iLiveUpdated) {
            this.firstClusterEntry = 0L;
            this.lastClusterEntry = Long.MAX_VALUE;
        } else {
            this.updateClusterRange();
        }
        return this;
    }

    public ORID getBeginRange() {
        return this.beginRange;
    }

    public ORID getEndRange() {
        return this.endRange;
    }

    public String toString() {
        return String.format("ORecordIteratorCluster.clusters(%s).currentRecord(%s).range(%s-%s)", Arrays.toString(this.clusterIds), this.currentRecord, this.beginRange, this.endRange);
    }

    protected boolean include(ORecord iRecord) {
        return true;
    }

    protected void updateClusterRange() {
        if (this.clusterIds.length == 0) {
            return;
        }
        if (this.currentClusterIdx >= this.clusterIds.length) {
            this.currentClusterIdx = this.clusterIds.length - 1;
        } else if (this.currentClusterIdx < 0) {
            this.currentClusterIdx = 0;
        }
        this.current.clusterId = this.clusterIds[this.currentClusterIdx];
        long[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
        this.firstClusterEntry = this.beginRange != null && this.beginRange.getClusterId() == this.current.clusterId && this.beginRange.getClusterPosition() > range[0] ? this.beginRange.getClusterPosition() : range[0];
        this.lastClusterEntry = this.endRange != null && this.endRange.getClusterId() == this.current.clusterId && this.endRange.getClusterPosition() < range[1] ? this.endRange.getClusterPosition() : range[1];
        this.resetCurrentPosition();
    }

    protected void config() {
        if (this.clusterIds.length == 0) {
            return;
        }
        this.currentClusterIdx = 0;
        this.updateClusterRange();
        this.totalAvailableRecords = this.database.countClusterElements(this.clusterIds, this.isIterateThroughTombstones());
        this.txEntries = this.database.getTransaction().getNewRecordEntriesByClusterIds(this.clusterIds);
        if (this.txEntries != null) {
            for (ORecordOperation entry : this.txEntries) {
                if (!entry.getRecord().getIdentity().isPersistent() && entry.type != 2) {
                    ++this.totalAvailableRecords;
                    continue;
                }
                if (entry.type != 2) continue;
                --this.totalAvailableRecords;
            }
        }
        this.begin();
    }

    private boolean outsideOfTheRange(ORID orid) {
        if (this.beginRange != null && orid.compareTo(this.beginRange) < 0) {
            return true;
        }
        return this.endRange != null && orid.compareTo(this.endRange) > 0;
    }
}

