/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.util.Set;

public class ORestrictedAccessHook
extends ODocumentHookAbstract {
    public ORestrictedAccessHook(ODatabaseDocument database) {
        super(database);
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(iDocument);
        if (cls != null && cls.isRestricted()) {
            String fieldNames = cls.getCustom("onCreate.fields");
            if (fieldNames == null) {
                fieldNames = "_allow";
            }
            String[] fields = fieldNames.split(",");
            String identityType = cls.getCustom("onCreate.identityType");
            if (identityType == null) {
                identityType = "user";
            }
            OIdentifiable identity = null;
            if (identityType.equals("user")) {
                OSecurityUser user = this.database.getUser();
                if (user != null) {
                    identity = user.getIdentity();
                }
            } else if (identityType.equals("role")) {
                Set<? extends OSecurityRole> roles = this.database.getUser().getRoles();
                if (!roles.isEmpty()) {
                    identity = roles.iterator().next().getIdentity();
                }
            } else {
                throw new OConfigurationException("Wrong custom field 'onCreate.identityType' in class '" + cls.getName() + "' with value '" + identityType + "'. Supported ones are: 'user', 'role'");
            }
            if (identity != null) {
                for (String f : fields) {
                    this.database.getMetadata().getSecurity().allowIdentity(iDocument, f, identity);
                }
                return ORecordHook.RESULT.RECORD_CHANGED;
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeRead(ODocument iDocument) {
        return this.isAllowed(iDocument, "_allowRead", false) ? ORecordHook.RESULT.RECORD_NOT_CHANGED : ORecordHook.RESULT.SKIP;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        if (!this.isAllowed(iDocument, "_allowUpdate", true)) {
            throw new OSecurityException("Cannot update record " + iDocument.getIdentity() + ": the resource has restricted access");
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        if (!this.isAllowed(iDocument, "_allowDelete", true)) {
            throw new OSecurityException("Cannot delete record " + iDocument.getIdentity() + ": the resource has restricted access");
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    protected boolean isAllowed(ODocument iDocument, String iAllowOperation, boolean iReadOriginal) {
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(iDocument);
        if (cls != null && cls.isRestricted()) {
            if (this.database.getUser() == null) {
                return true;
            }
            if (this.database.getUser().isRuleDefined(ORule.ResourceGeneric.BYPASS_RESTRICTED, null) && this.database.getUser().checkIfAllowed(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, ORole.PERMISSION_READ) != null) {
                return true;
            }
            ODocument doc = iReadOriginal ? (ODocument)this.database.load(iDocument.getIdentity()) : iDocument;
            if (doc == null) {
                return false;
            }
            return this.database.getMetadata().getSecurity().isAllowed((Set)doc.field("_allow"), (Set)doc.field(iAllowOperation));
        }
        return true;
    }
}

