/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetDelegate;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OCommandSQLResultset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OSQLTarget
extends OBaseParser {
    protected final boolean empty;
    protected final OCommandContext context;
    protected String targetVariable;
    protected String targetQuery;
    protected Iterable<? extends OIdentifiable> targetRecords;
    protected Map<String, String> targetClusters;
    protected Map<OClass, String> targetClasses;
    protected String targetIndex;
    protected String targetIndexValues;
    protected boolean targetIndexValuesAsc;

    public OSQLTarget(String iText, OCommandContext iContext, String iFilterKeyword) {
        this.context = iContext;
        this.parserText = iText;
        this.parserTextUpperCase = this.upperCase(iText);
        try {
            this.empty = !this.extractTargets();
        }
        catch (OQueryParsingException e) {
            if (e.getText() == null) {
                throw new OQueryParsingException("Error on parsing query", this.parserText, this.parserGetCurrentPosition(), e);
            }
            throw e;
        }
        catch (Throwable t) {
            throw new OQueryParsingException("Error on parsing query", this.parserText, this.parserGetCurrentPosition(), t);
        }
    }

    protected String upperCase(String text) {
        StringBuilder result = new StringBuilder(text.length());
        for (char c : text.toCharArray()) {
            String upper = ("" + c).toUpperCase(Locale.ENGLISH);
            if (upper.length() > 1) {
                result.append(c);
                continue;
            }
            result.append(upper);
        }
        return result.toString();
    }

    public Map<String, String> getTargetClusters() {
        return this.targetClusters;
    }

    public Map<OClass, String> getTargetClasses() {
        return this.targetClasses;
    }

    public Iterable<? extends OIdentifiable> getTargetRecords() {
        return this.targetRecords;
    }

    public String getTargetQuery() {
        return this.targetQuery;
    }

    public String getTargetIndex() {
        return this.targetIndex;
    }

    public String getTargetIndexValues() {
        return this.targetIndexValues;
    }

    public boolean isTargetIndexValuesAsc() {
        return this.targetIndexValuesAsc;
    }

    public String toString() {
        if (this.targetClasses != null) {
            return "class " + this.targetClasses.keySet();
        }
        if (this.targetClusters != null) {
            return "cluster " + this.targetClusters.keySet();
        }
        if (this.targetIndex != null) {
            return "index " + this.targetIndex;
        }
        if (this.targetRecords != null) {
            return "records from " + this.targetRecords.getClass().getSimpleName();
        }
        if (this.targetVariable != null) {
            return "variable " + this.targetVariable;
        }
        return "?";
    }

    public String getTargetVariable() {
        return this.targetVariable;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    protected void throwSyntaxErrorException(String iText) {
        throw new OCommandSQLParsingException(iText + ". Use " + this.getSyntax(), this.parserText, this.parserGetPreviousPosition());
    }

    private boolean extractTargets() {
        this.parserSkipWhiteSpaces();
        if (this.parserIsEnded()) {
            throw new OQueryParsingException("No query target found", this.parserText, 0);
        }
        char c = this.parserGetCurrentChar();
        if (c == '$') {
            this.targetVariable = this.parserRequiredWord(false, "No valid target");
            this.targetVariable = this.targetVariable.substring(1);
        } else if (c == '#' || Character.isDigit(c)) {
            this.targetRecords = new ArrayList<OIdentifiable>();
            ((List)this.targetRecords).add(new ORecordId(this.parserRequiredWord(true, "No valid RID")));
        } else if (c == '(') {
            StringBuilder subText = new StringBuilder(256);
            this.parserSetCurrentPosition(OStringSerializerHelper.getEmbedded(this.parserText, this.parserGetCurrentPosition(), -1, subText) + 1);
            OCommandSQLResultset subCommand = new OCommandSQLResultset(subText.toString());
            OCommandExecutorSQLResultsetDelegate executor = (OCommandExecutorSQLResultsetDelegate)OCommandManager.instance().getExecutor(subCommand);
            executor.setProgressListener(subCommand.getProgressListener());
            executor.parse(subCommand);
            this.context.setChild(executor.getContext());
            if (!(executor instanceof Iterable)) {
                throw new OCommandSQLParsingException("Sub-query cannot be iterated because doesn't implement the Iterable interface: " + subCommand);
            }
            this.targetQuery = subText.toString();
            this.targetRecords = executor;
        } else if (c == '[') {
            ArrayList<String> rids = new ArrayList<String>();
            this.parserSetCurrentPosition(OStringSerializerHelper.getCollection(this.parserText, this.parserGetCurrentPosition(), rids));
            this.targetRecords = new ArrayList<OIdentifiable>();
            for (String rid : rids) {
                ((List)this.targetRecords).add(new ORecordId(rid));
            }
            this.parserMoveCurrentPosition(1);
        } else {
            while (!this.parserIsEnded() && this.targetClasses == null && this.targetClusters == null && this.targetIndex == null && this.targetIndexValues == null && this.targetRecords == null) {
                OClass cls;
                String originalSubjectName = this.parserRequiredWord(false, "Target not found");
                String subjectName = originalSubjectName.toUpperCase();
                String alias = subjectName.equals("AS") ? this.parserRequiredWord(true, "Alias not found") : subjectName;
                String subjectToMatch = subjectName;
                if (subjectToMatch.startsWith("CLUSTER:")) {
                    String clusterNames;
                    if (this.targetClusters == null) {
                        this.targetClusters = new HashMap<String, String>();
                    }
                    if ((clusterNames = subjectName.substring("CLUSTER:".length())).startsWith("[") && clusterNames.endsWith("]")) {
                        HashSet<String> clusters = new HashSet<String>(3);
                        OStringSerializerHelper.getCollection(clusterNames, 0, clusters);
                        for (String cl : clusters) {
                            this.targetClusters.put(cl, cl);
                        }
                        continue;
                    }
                    this.targetClusters.put(clusterNames, alias);
                    continue;
                }
                if (subjectToMatch.startsWith("INDEX:")) {
                    this.targetIndex = subjectName.substring("INDEX:".length());
                    continue;
                }
                if (subjectToMatch.startsWith("METADATA:")) {
                    String metadataTarget = subjectName.substring("METADATA:".length());
                    this.targetRecords = new ArrayList<OIdentifiable>();
                    if (metadataTarget.equals("SCHEMA")) {
                        ((ArrayList)this.targetRecords).add(new ORecordId(ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().schemaRecordId));
                        continue;
                    }
                    if (metadataTarget.equals("INDEXMANAGER")) {
                        ((ArrayList)this.targetRecords).add(new ORecordId(ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().indexMgrRecordId));
                        continue;
                    }
                    throw new OQueryParsingException("Metadata element not supported: " + metadataTarget);
                }
                if (subjectToMatch.startsWith("DICTIONARY:")) {
                    String key = originalSubjectName.substring("DICTIONARY:".length());
                    this.targetRecords = new ArrayList<OIdentifiable>();
                    OIdentifiable value = (OIdentifiable)ODatabaseRecordThreadLocal.INSTANCE.get().getDictionary().get(key);
                    if (value == null) continue;
                    ((List)this.targetRecords).add(value);
                    continue;
                }
                if (subjectToMatch.startsWith("INDEXVALUES:")) {
                    this.targetIndexValues = subjectName.substring("INDEXVALUES:".length());
                    this.targetIndexValuesAsc = true;
                    continue;
                }
                if (subjectToMatch.startsWith("INDEXVALUESASC:")) {
                    this.targetIndexValues = subjectName.substring("INDEXVALUESASC:".length());
                    this.targetIndexValuesAsc = true;
                    continue;
                }
                if (subjectToMatch.startsWith("INDEXVALUESDESC:")) {
                    this.targetIndexValues = subjectName.substring("INDEXVALUESDESC:".length());
                    this.targetIndexValuesAsc = false;
                    continue;
                }
                if (subjectToMatch.startsWith("CLASS:")) {
                    subjectName = subjectName.substring("CLASS:".length());
                }
                if (this.targetClasses == null) {
                    this.targetClasses = new HashMap<OClass, String>();
                }
                if ((cls = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().getClass(subjectName)) == null) {
                    throw new OCommandExecutionException("Class '" + subjectName + "' was not found in current database");
                }
                this.targetClasses.put(cls, alias);
            }
        }
        return !this.parserIsEnded();
    }
}

