/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.method.misc;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;

public abstract class OAbstractSQLMethod
implements OSQLMethod {
    private final String name;
    private final int minparams;
    private final int maxparams;

    public OAbstractSQLMethod(String name) {
        this(name, 0);
    }

    public OAbstractSQLMethod(String name, int nbparams) {
        this(name, nbparams, nbparams);
    }

    public OAbstractSQLMethod(String name, int minparams, int maxparams) {
        this.name = name;
        this.minparams = minparams;
        this.maxparams = maxparams;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSyntax() {
        int i;
        StringBuilder sb = new StringBuilder("<field>.");
        sb.append(this.getName());
        sb.append('(');
        for (i = 0; i < this.minparams; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("param");
            sb.append(i + 1);
        }
        if (this.minparams != this.maxparams) {
            sb.append('[');
            for (i = this.minparams; i < this.maxparams; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append("param");
                sb.append(i + 1);
            }
            sb.append(']');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int getMinParams() {
        return this.minparams;
    }

    @Override
    public int getMaxParams() {
        return this.maxparams;
    }

    protected Object getParameterValue(OIdentifiable iRecord, String iValue) {
        if (iValue == null) {
            return null;
        }
        if (iValue.charAt(0) == '\'' || iValue.charAt(0) == '\"') {
            return iValue.substring(1, iValue.length() - 1);
        }
        return ((ODocument)iRecord.getRecord()).field(iValue);
    }

    @Override
    public int compareTo(OSQLMethod o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean evaluateParameters() {
        return true;
    }
}

