/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OContainsCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OExpression right;
    protected OBooleanExpression condition;

    public OContainsCondition(int id) {
        super(id);
    }

    public OContainsCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord) {
        return false;
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        this.left.replaceParameters(params);
        if (this.right != null) {
            this.right.replaceParameters(params);
        }
        if (this.condition != null) {
            this.condition.replaceParameters(params);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.left.toString());
        result.append(" CONTAINS ");
        if (this.right != null) {
            result.append(this.right.toString());
        } else if (this.condition != null) {
            result.append("(");
            result.append(this.condition.toString());
            result.append(")");
        }
        return result.toString();
    }

    @Override
    public boolean supportsBasicCalculation() {
        if (!this.left.supportsBasicCalculation()) {
            return false;
        }
        if (!this.right.supportsBasicCalculation()) {
            return false;
        }
        return this.condition.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (this.condition != null) {
            total += this.condition.getNumberOfExternalCalculations();
        }
        if (!this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.condition != null) {
            result.addAll(this.condition.getExternalCalculationConditions());
        }
        if (!this.left.supportsBasicCalculation()) {
            result.add(this.left);
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            result.add(this.right);
        }
        return result;
    }
}

