/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OBaseExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OParenthesisExpression;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OExpression
extends SimpleNode {
    protected Boolean singleQuotes;
    protected Boolean doubleQuotes;

    public OExpression(int id) {
        super(id);
    }

    public OExpression(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object createExecutorFilter() {
        if (this.value instanceof ORid) {
            return null;
        }
        if (this.value instanceof OInputParameter) {
            return null;
        }
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).createExecutorFilter();
        }
        if (this.value instanceof OJson) {
            return null;
        }
        if (this.value instanceof String) {
            return this.value;
        }
        if (this.value instanceof Number) {
            return this.value;
        }
        return this.value;
    }

    public String getDefaultAlias() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return "" + this.value;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof SimpleNode) {
            return this.value.toString();
        }
        if (this.value instanceof String) {
            if (Boolean.TRUE.equals(this.singleQuotes)) {
                return "'" + OExpression.encodeSingle((String)this.value) + "'";
            }
            return "\"" + OExpression.encode((String)this.value) + "\"";
        }
        return "" + this.value;
    }

    public static String encode(String s) {
        return s.replaceAll("\"", "\\\\\"");
    }

    public static String encodeSingle(String s) {
        return s.replaceAll("'", "\\\\'");
    }

    public void replaceParameters(Map<Object, Object> params) {
        if (this.value instanceof OInputParameter) {
            this.value = ((OInputParameter)this.value).bindFromInputParams(params);
        } else if (this.value instanceof OBaseExpression) {
            ((OBaseExpression)this.value).replaceParameters(params);
        } else if (this.value instanceof OParenthesisExpression) {
            ((OParenthesisExpression)this.value).replaceParameters(params);
        } else if (this.value instanceof OMathExpression) {
            ((OMathExpression)this.value).replaceParameters(params);
        }
    }

    public boolean supportsBasicCalculation() {
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).supportsBasicCalculation();
        }
        return true;
    }
}

