/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OIndexMatchCondition
extends OBooleanExpression {
    protected OBinaryCompareOperator operator;
    protected Boolean between;
    protected List<OExpression> leftExpressions;
    protected List<OExpression> rightExpressions;

    public OIndexMatchCondition(int id) {
        super(id);
    }

    public OIndexMatchCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord) {
        return false;
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        if (this.leftExpressions != null) {
            for (OExpression x : this.leftExpressions) {
                x.replaceParameters(params);
            }
        }
        if (this.rightExpressions != null) {
            for (OExpression x : this.rightExpressions) {
                x.replaceParameters(params);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("KEY ");
        if (this.operator != null) {
            result.append(this.operator.toString());
            result.append(" [");
            boolean first = true;
            for (OExpression x : this.leftExpressions) {
                if (!first) {
                    result.append(", ");
                }
                result.append(x.toString());
                first = false;
            }
            result.append("]");
        } else if (Boolean.TRUE.equals(this.between)) {
            result.append(" BETWEEN [");
            boolean first = true;
            for (OExpression x : this.leftExpressions) {
                if (!first) {
                    result.append(", ");
                }
                result.append(x.toString());
                first = false;
            }
            result.append("] AND [");
            first = true;
            for (OExpression x : this.rightExpressions) {
                if (!first) {
                    result.append(", ");
                }
                result.append(x.toString());
                first = false;
            }
            result.append("]");
        }
        return result.toString();
    }

    @Override
    public boolean supportsBasicCalculation() {
        return false;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        return 1;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this);
        return result;
    }
}

