/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.io.IOException;

public class OSingleFileSegment {
    protected OLocalPaginatedStorage storage;
    protected OFile file;
    protected OStorageFileConfiguration config;
    private boolean wasSoftlyClosedAtPreviousTime = true;

    public OSingleFileSegment(OLocalPaginatedStorage iStorage, OStorageFileConfiguration iConfig) throws IOException {
        this(iStorage, iConfig, iConfig.type);
    }

    public OSingleFileSegment(OLocalPaginatedStorage iStorage, OStorageFileConfiguration iConfig, String iType) throws IOException {
        this.config = iConfig;
        this.storage = iStorage;
        this.file = new OFileClassic(iStorage.getVariableParser().resolveVariables(iConfig.path), iStorage.getMode());
    }

    public boolean open() throws IOException {
        boolean softClosed = this.file.open();
        if (!softClosed) {
            OLogManager.instance().warn((Object)this, "segment file '%s' was not closed correctly last time", OFileUtils.getPath(this.file.getName()));
            this.wasSoftlyClosedAtPreviousTime = false;
        }
        return softClosed;
    }

    public void create(int iStartSize) throws IOException {
        this.file.create();
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public void delete() throws IOException {
        if (this.file != null) {
            this.file.delete();
        }
    }

    public void truncate() throws IOException {
        this.file.shrink(0L);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long getSize() {
        return this.file.getFileSize();
    }

    public long getFilledUpTo() {
        return this.file.getFileSize();
    }

    public OStorageFileConfiguration getConfig() {
        return this.config;
    }

    public OFile getFile() {
        return this.file;
    }

    public void synch() throws IOException {
        this.file.synch();
    }

    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
    }

    public boolean wasSoftlyClosedAtPreviousTime() {
        return this.wasSoftlyClosedAtPreviousTime;
    }

    public void rename(String iOldName, String iNewName) throws IOException {
        String osFileName = this.file.getName();
        if (osFileName.startsWith(iOldName)) {
            File newFile = new File(this.storage.getStoragePath() + "/" + iNewName + osFileName.substring(osFileName.lastIndexOf(iOldName) + iOldName.length()));
            boolean renamed = this.file.renameTo(newFile);
            while (!renamed) {
                renamed = this.file.renameTo(newFile);
            }
        }
    }
}

