/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;

public abstract class OOperationUnitBodyRecord
extends OOperationUnitRecord {
    private OLogSequenceNumber startLsn;

    protected OOperationUnitBodyRecord() {
    }

    protected OOperationUnitBodyRecord(OOperationUnitId operationUnitId, OLogSequenceNumber startLsn) {
        super(operationUnitId);
        this.startLsn = startLsn;
    }

    public OLogSequenceNumber getStartLsn() {
        return this.startLsn;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        OLongSerializer.INSTANCE.serializeNative(this.startLsn.getSegment(), content, offset, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(this.startLsn.getPosition(), content, offset += 8, new Object[0]);
        return offset += 8;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        long segment = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        long position = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        this.startLsn = new OLogSequenceNumber(segment, position);
        return offset += 8;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }
}

