/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRetryAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLDeleteEdge
extends OCommandExecutorSQLRetryAbstract
implements OCommandDistributedReplicateRequest,
OCommandResultListener {
    public static final String NAME = "DELETE EDGE";
    private static final String KEYWORD_BATCH = "BATCH";
    private List<ORecordId> rids;
    private String fromExpr;
    private String toExpr;
    private int removed = 0;
    private OCommandRequest query;
    private OSQLFilter compiledFilter;
    private OrientGraph graph;
    private String label;
    private OModifiableBoolean shutdownFlag = new OModifiableBoolean();
    private boolean txAlreadyBegun;
    private int batch = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLDeleteEdge parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            String[] stringArray;
            ODatabaseDocumentInternal curDb;
            block35: {
                queryText = this.preParse(queryText, iRequest);
                textRequest.setText(queryText);
                this.init((OCommandRequestText)iRequest);
                this.parserRequiredKeyword("DELETE");
                this.parserRequiredKeyword("EDGE");
                OrientEdgeType clazz = null;
                String where = null;
                String temp = this.parseOptionalWord(true, new String[0]);
                String originalTemp = null;
                if (temp != null && !this.parserIsEnded()) {
                    originalTemp = this.parserText.substring(this.parserGetPreviousPosition(), this.parserGetCurrentPosition()).trim();
                }
                OModifiableBoolean shutdownFlag = new OModifiableBoolean();
                curDb = ODatabaseRecordThreadLocal.INSTANCE.get();
                OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(false, shutdownFlag);
                try {
                    while (temp != null) {
                        if (temp.equals("FROM")) {
                            this.fromExpr = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                            if (this.rids != null) {
                                this.throwSyntaxErrorException("FROM '" + this.fromExpr + "' is not allowed when specify a RIDs (" + this.rids + ")");
                            }
                        } else if (temp.equals("TO")) {
                            this.toExpr = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                            if (this.rids != null) {
                                this.throwSyntaxErrorException("TO '" + this.toExpr + "' is not allowed when specify a RID (" + this.rids + ")");
                            }
                        } else if (temp.startsWith("#")) {
                            this.rids = new ArrayList<ORecordId>();
                            this.rids.add(new ORecordId(temp));
                            if (this.fromExpr != null || this.toExpr != null) {
                                this.throwSyntaxErrorException("Specifying the RID " + this.rids + " is not allowed with FROM/TO");
                            }
                        } else if (temp.startsWith("[") && temp.endsWith("]")) {
                            temp = temp.substring(1, temp.length() - 1);
                            this.rids = new ArrayList<ORecordId>();
                            for (String rid : temp.split(",")) {
                                if (!(rid = rid.trim()).startsWith("#")) {
                                    this.throwSyntaxErrorException("Not a valid RID: " + rid);
                                }
                                this.rids.add(new ORecordId(rid));
                            }
                        } else {
                            if (temp.equals("WHERE")) {
                                if (clazz == null) {
                                    clazz = graph.getEdgeType("E");
                                }
                                where = this.parserGetCurrentPosition() > -1 ? " " + this.parserText.substring(this.parserGetCurrentPosition()) : "";
                                this.compiledFilter = OSQLEngine.getInstance().parseCondition(where, this.getContext(), "WHERE");
                                break;
                            }
                            if (temp.equals("RETRY")) {
                                this.parseRetry();
                            } else if (temp.equals(KEYWORD_BATCH)) {
                                temp = this.parserNextWord(true);
                                if (temp != null) {
                                    this.batch = Integer.parseInt(temp);
                                }
                            } else if (temp.equals("LIMIT")) {
                                temp = this.parserNextWord(true);
                                if (temp != null) {
                                    this.limit = Integer.parseInt(temp);
                                }
                            } else if (temp.length() > 0) {
                                this.label = originalTemp;
                                clazz = graph.getEdgeType(temp);
                                if (clazz == null) {
                                    throw new OCommandSQLParsingException("Class '" + temp + "' was not found");
                                }
                            }
                        }
                        temp = this.parseOptionalWord(true, new String[0]);
                        if (!this.parserIsEnded()) continue;
                    }
                    where = where == null ? (this.limit > -1 ? " LIMIT " + this.limit : "") : " WHERE " + where;
                    if (this.fromExpr == null && this.toExpr == null && this.rids == null) {
                        this.query = clazz == null ? graph.getRawGraph().command(new OSQLAsynchQuery("select from E" + where, (OCommandResultListener)this)) : graph.getRawGraph().command(new OSQLAsynchQuery("select from " + clazz.getName() + where, (OCommandResultListener)this));
                    }
                    stringArray = this;
                    if (!shutdownFlag.getValue()) break block35;
                }
                catch (Throwable throwable) {
                    if (shutdownFlag.getValue()) {
                        graph.shutdown(false);
                    }
                    ODatabaseRecordThreadLocal.INSTANCE.set(curDb);
                    throw throwable;
                }
                graph.shutdown(false);
            }
            ODatabaseRecordThreadLocal.INSTANCE.set(curDb);
            return stringArray;
        }
        finally {
            textRequest.setText(originalQuery);
        }
    }

    @Override
    public Object execute(final Map<Object, Object> iArgs) {
        if (this.fromExpr == null && this.toExpr == null && this.rids == null && this.query == null && this.compiledFilter == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        for (int r = 0; r < this.retry; ++r) {
            try {
                this.txAlreadyBegun = OCommandExecutorSQLDeleteEdge.getDatabase().getTransaction().isActive();
                this.graph = OGraphCommandExecutorSQLFactory.getGraph(true, this.shutdownFlag);
                if (this.rids != null) {
                    OGraphCommandExecutorSQLFactory.runInTx(this.graph, new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                        @Override
                        public Object call(OrientBaseGraph graph) {
                            for (ORecordId rid : OCommandExecutorSQLDeleteEdge.this.rids) {
                                OrientEdge e = graph.getEdge(rid);
                                if (e == null) continue;
                                e.remove();
                                OCommandExecutorSQLDeleteEdge.this.removed++;
                            }
                            return null;
                        }
                    });
                    this.end();
                    break;
                }
                final HashSet edges = new HashSet();
                if (this.query == null) {
                    OGraphCommandExecutorSQLFactory.runInTx(this.graph, new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                        @Override
                        public Object call(OrientBaseGraph graph) {
                            OrientVertex v;
                            Set<OIdentifiable> fromIds = null;
                            if (OCommandExecutorSQLDeleteEdge.this.fromExpr != null) {
                                fromIds = OSQLEngine.getInstance().parseRIDTarget(graph.getRawGraph(), OCommandExecutorSQLDeleteEdge.this.fromExpr, OCommandExecutorSQLDeleteEdge.this.context, iArgs);
                            }
                            Set<OIdentifiable> toIds = null;
                            if (OCommandExecutorSQLDeleteEdge.this.toExpr != null) {
                                toIds = OSQLEngine.getInstance().parseRIDTarget(graph.getRawGraph(), OCommandExecutorSQLDeleteEdge.this.toExpr, OCommandExecutorSQLDeleteEdge.this.context, iArgs);
                            }
                            if (fromIds != null && toIds != null) {
                                for (OIdentifiable fromId : fromIds) {
                                    v = graph.getVertex(fromId);
                                    if (v == null) continue;
                                    for (Edge e : v.getEdges(Direction.OUT, new String[0])) {
                                        OIdentifiable inV;
                                        if (OCommandExecutorSQLDeleteEdge.this.label != null && !OCommandExecutorSQLDeleteEdge.this.label.equals(e.getLabel()) || (inV = ((OrientEdge)e).getInVertex()) == null || !toIds.contains(inV.getIdentity())) continue;
                                        edges.add((OrientEdge)e);
                                    }
                                }
                            } else if (fromIds != null) {
                                for (OIdentifiable fromId : fromIds) {
                                    v = graph.getVertex(fromId);
                                    if (v == null) continue;
                                    for (Edge e : v.getEdges(Direction.OUT, new String[0])) {
                                        if (OCommandExecutorSQLDeleteEdge.this.label != null && !OCommandExecutorSQLDeleteEdge.this.label.equals(e.getLabel())) continue;
                                        edges.add((OrientEdge)e);
                                    }
                                }
                            } else if (toIds != null) {
                                for (OIdentifiable toId : toIds) {
                                    v = graph.getVertex(toId);
                                    if (v == null) continue;
                                    for (Edge e : v.getEdges(Direction.IN, new String[0])) {
                                        if (OCommandExecutorSQLDeleteEdge.this.label != null && !OCommandExecutorSQLDeleteEdge.this.label.equals(e.getLabel())) continue;
                                        edges.add((OrientEdge)e);
                                    }
                                }
                            } else {
                                throw new OCommandExecutionException("Invalid target: " + toIds);
                            }
                            if (OCommandExecutorSQLDeleteEdge.this.compiledFilter != null) {
                                Iterator it = edges.iterator();
                                while (it.hasNext()) {
                                    OrientEdge edge = (OrientEdge)it.next();
                                    if (((Boolean)OCommandExecutorSQLDeleteEdge.this.compiledFilter.evaluate(edge.getRecord(), null, OCommandExecutorSQLDeleteEdge.this.context)).booleanValue()) continue;
                                    it.remove();
                                }
                            }
                            OCommandExecutorSQLDeleteEdge.this.removed = edges.size();
                            for (OrientEdge edge : edges) {
                                edge.remove();
                            }
                            return null;
                        }
                    });
                    this.end();
                    break;
                }
                this.query.setContext(this.getContext());
                this.query.execute(iArgs);
                break;
            }
            catch (OConcurrentModificationException e) {
                if (r + 1 >= this.retry) {
                    throw e;
                }
                if (this.wait <= 0) continue;
                try {
                    Thread.sleep(this.wait);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        return this.removed;
    }

    @Override
    public boolean result(Object iRecord) {
        OIdentifiable id = (OIdentifiable)iRecord;
        if (this.compiledFilter != null && !((Boolean)this.compiledFilter.evaluate((OIdentifiable)id.getRecord(), null, this.context)).booleanValue()) {
            return true;
        }
        if (id.getIdentity().isValid()) {
            OrientEdge e = this.graph.getEdge(id);
            for (int retry = 0; retry < 20; ++retry) {
                try {
                    if (e == null) break;
                    e.remove();
                    if (!this.txAlreadyBegun && this.batch > 0 && (this.removed + 1) % this.batch == 0) {
                        this.graph.commit();
                        this.graph.begin();
                    }
                    ++this.removed;
                    break;
                }
                catch (ONeedRetryException ex) {
                    OCommandExecutorSQLDeleteEdge.getDatabase().getLocalCache().invalidate();
                    e.reload();
                    continue;
                }
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "DELETE EDGE <rid>|FROM <rid>|TO <rid>|<[<class>] [WHERE <conditions>]> [BATCH <batch-size>]";
    }

    @Override
    public void end() {
        if (this.graph != null && !this.txAlreadyBegun) {
            this.graph.commit();
            if (this.shutdownFlag.getValue()) {
                this.graph.shutdown(false);
            }
        }
    }

    @Override
    public int getSecurityOperationType() {
        return ORole.PERMISSION_DELETE;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT getDistributedResultManagement() {
        return this.getDistributedExecutionMode() == OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL ? OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.CHECK_FOR_EQUALS : OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.MERGE;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return this.query != null && !OCommandExecutorSQLDeleteEdge.getDatabase().getTransaction().isActive() ? OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.REPLICATE : OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }
}

