/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enumerations;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.object.enumerations.OObjectEnumLazyIterator;
import com.orientechnologies.orient.object.enumerations.OObjectLazyEnumSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class OObjectEnumLazyList<TYPE extends Enum<?>>
implements List<TYPE>,
OObjectLazyEnumSerializer<List<TYPE>>,
Serializable {
    private static final long serialVersionUID = -8541477416577361792L;
    private ORecord sourceRecord;
    private final List<Object> serializedList;
    private final ArrayList<TYPE> list = new ArrayList();
    private boolean converted = false;
    private final Class<Enum> enumClass;

    public OObjectEnumLazyList(Class<Enum> iEnumClass, ORecord iSourceRecord, List<Object> iRecordList) {
        this.sourceRecord = iSourceRecord;
        this.serializedList = iRecordList;
        this.enumClass = iEnumClass;
        for (int i = 0; i < iRecordList.size(); ++i) {
            this.list.add(i, null);
        }
    }

    public OObjectEnumLazyList(Class<Enum> iEnumClass, ORecord iSourceRecord, List<Object> iRecordList, Collection<? extends TYPE> iSourceList) {
        this.sourceRecord = iSourceRecord;
        this.serializedList = iRecordList;
        this.enumClass = iEnumClass;
        this.addAll((Collection<? extends TYPE>)iSourceList);
        for (int i = iSourceList.size(); i < iRecordList.size(); ++i) {
            this.list.add(i, null);
        }
    }

    @Override
    public Iterator<TYPE> iterator() {
        return new OObjectEnumLazyIterator(this.enumClass, this.sourceRecord, this.serializedList.iterator());
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) > -1;
    }

    @Override
    public boolean add(TYPE element) {
        this.serializedList.add(((Enum)element).name());
        return this.list.add(element);
    }

    @Override
    public void add(int index, TYPE element) {
        this.setDirty();
        this.serializedList.add(index, ((Enum)element).name());
        this.list.add(index, element);
    }

    @Override
    public TYPE get(int index) {
        Enum o = (Enum)this.list.get(index);
        if (o == null) {
            Object toDeserialize = this.serializedList.get(index);
            o = toDeserialize instanceof Number ? this.enumClass.getEnumConstants()[((Number)toDeserialize).intValue()] : Enum.valueOf(this.enumClass, toDeserialize.toString());
            this.list.set(index, o);
        }
        return (TYPE)o;
    }

    @Override
    public int indexOf(Object o) {
        TYPE enumToCheck = this.objectToEnum(o);
        if (enumToCheck != null) {
            return this.serializedList.indexOf(((Enum)enumToCheck).name());
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        TYPE enumToCheck = this.objectToEnum(o);
        if (enumToCheck != null) {
            return this.serializedList.lastIndexOf(((Enum)enumToCheck).name());
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        this.convertAll();
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.convertAll();
        return this.list.toArray(a);
    }

    @Override
    public int size() {
        return this.serializedList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.serializedList.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.setDirty();
        int indexOfO = this.list.indexOf(o);
        this.serializedList.remove(indexOfO);
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends TYPE> c) {
        boolean dirty = false;
        for (Enum element : c) {
            dirty = this.add((TYPE)element) || dirty;
        }
        if (dirty) {
            this.setDirty();
        }
        return dirty;
    }

    @Override
    public boolean addAll(int index, Collection<? extends TYPE> c) {
        for (Enum element : c) {
            this.add(index, (TYPE)element);
            ++index;
        }
        if (c.size() > 0) {
            this.setDirty();
        }
        return c.size() > 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean dirty = true;
        for (Object o : c) {
            dirty = dirty || this.remove(o);
        }
        if (dirty) {
            this.setDirty();
        }
        return dirty;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<TYPE> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            this.remove(e);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.setDirty();
        this.serializedList.clear();
        this.list.clear();
    }

    @Override
    public TYPE set(int index, TYPE element) {
        this.serializedList.set(index, ((Enum)element).name());
        return (TYPE)((Enum)this.list.set(index, element));
    }

    @Override
    public TYPE remove(int index) {
        this.serializedList.remove(index);
        return (TYPE)((Enum)this.list.remove(index));
    }

    @Override
    public ListIterator<TYPE> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<TYPE> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<TYPE> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public boolean isConverted() {
        return this.converted;
    }

    public void detach() {
        this.convertAll();
    }

    @Override
    public void detach(boolean nonProxiedInstance) {
        this.convertAll();
    }

    @Override
    public void detachAll(boolean nonProxiedInstance, Map<Object, Object> alreadyDetached) {
        this.convertAll();
    }

    @Override
    public List<TYPE> getNonOrientInstance() {
        ArrayList list = new ArrayList();
        list.addAll(this);
        return list;
    }

    protected void convertAll() {
        if (this.converted) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.convert(i);
        }
        this.converted = true;
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    @Override
    public Object getUnderlying() {
        return this.serializedList;
    }

    private void convert(int iIndex) {
        if (this.converted) {
            return;
        }
        Object o = this.list.get(iIndex);
        if (o == null) {
            o = this.serializedList.get(iIndex);
            o = o instanceof Number ? this.enumClass.getEnumConstants()[((Number)o).intValue()] : Enum.valueOf(this.enumClass, o.toString());
            this.list.set(iIndex, (Enum)o);
        }
    }

    protected boolean indexLoaded(int iIndex) {
        return this.list.get(iIndex) != null;
    }

    public String toString() {
        return this.list.toString();
    }

    private TYPE objectToEnum(Object o) {
        if (o != null && o.getClass() == this.enumClass) {
            return (TYPE)((Enum)o);
        }
        return null;
    }
}

