/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import java.util.ArrayList;

public class OLocalClusterStrategy
implements OClusterSelectionStrategy {
    public static final String NAME = "local";
    protected final OClass cls;
    protected final ODistributedServerManager manager;
    protected final String nodeName;
    protected final String databaseName;
    protected volatile int bestClusterId = -1;

    public OLocalClusterStrategy(ODistributedServerManager iManager, String iDatabaseName, OClass iClass) {
        this.manager = iManager;
        this.nodeName = iManager.getLocalNodeName();
        this.databaseName = iDatabaseName;
        this.cls = iClass;
    }

    @Override
    public int getCluster(OClass iClass, ODocument doc) {
        if (!iClass.equals(this.cls)) {
            throw new IllegalArgumentException("Class '" + iClass + "' is different than the configured one: " + this.cls);
        }
        if (this.bestClusterId == -1) {
            this.readConfiguration();
        }
        return this.bestClusterId;
    }

    public void resetConfiguration() {
        this.bestClusterId = -1;
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected void readConfiguration() {
        if (this.cls.isAbstract()) {
            throw new IllegalArgumentException("Cannot create a new instance of abstract class");
        }
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        int[] clusterIds = this.cls.getClusterIds();
        ArrayList<String> clusterNames = new ArrayList<String>(clusterIds.length);
        for (int c : clusterIds) {
            clusterNames.add(db.getClusterNameById(c));
        }
        ODistributedConfiguration cfg = this.manager.getDatabaseConfiguration(this.databaseName);
        String bestCluster = cfg.getLocalCluster(clusterNames, this.nodeName);
        if (bestCluster == null) {
            throw new OException("Cannot find best cluster for class '" + this.cls.getName() + "' on server '" + this.nodeName + "'. ClusterStrategy=" + this.getName());
        }
        this.bestClusterId = db.getClusterIdByName(bestCluster);
    }
}

