/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OResurrectRecordTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;
    private ORecordId rid;
    private ORecordVersion version;

    public OResurrectRecordTask() {
    }

    public OResurrectRecordTask(ORecordId iRid, ORecordVersion iVersion) {
        this.rid = iRid;
        this.version = iVersion;
    }

    public ORecordId getRid() {
        return this.rid;
    }

    public ORecordVersion getVersion() {
        return this.version;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "resurrecting deleted record %s/%s v.%s", database.getName(), this.rid.toString(), this.version.toString());
        if (((ODistributedStorage)database.getStorage()).resurrectDeletedRecord(this.rid)) {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> resurrected deleted record", new Object[0]);
            return Boolean.TRUE;
        }
        ODistributedServerLog.error((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> error on resurrecting deleted record: the record is already deleted", new Object[0]);
        return Boolean.FALSE;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.rid.toString());
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().writeTo(out, this.version);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rid = new ORecordId(in.readUTF());
        int contentSize = in.readInt();
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().readFrom(in, this.version);
    }

    @Override
    public String getName() {
        return "fix_record_delete";
    }
}

