/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandGetDocumentByClass
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|documentbyclass/*", "HEAD|documentbyclass/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        ODatabaseDocumentTx db = null;
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: documentbyclass/<database>/<class-name>/<record-position>[/fetchPlan]");
        String fetchPlan = urlParts.length > 4 ? urlParts[4] : null;
        iRequest.data.commandInfo = "Load document";
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getMetadata().getImmutableSchemaSnapshot().getClass(urlParts[2]) == null) {
                throw new IllegalArgumentException("Invalid class '" + urlParts[2] + "'");
            }
            String rid = db.getClusterIdByName(urlParts[2]) + ":" + urlParts[3];
            Object rec = db.load(new ORecordId(rid), fetchPlan);
            if (rec == null) {
                iResponse.send(404, "Not Found", "application/json", "Record with id '" + rid + "' was not found.", null);
            } else if (iRequest.httpMethod.equals("HEAD")) {
                iResponse.send(200, "OK", null, null, null);
            } else {
                iResponse.writeRecord((ORecord)rec, fetchPlan, null);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

