/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.HashMap;
import java.util.HashSet;

public class OBonsaiTreeRepair {
    public void repairDatabaseRidbags(ODatabaseDocumentTx db, OCommandOutputListener outputListener) {
        this.message(outputListener, "Repair of ridbags is started ...\n");
        OMetadataDefault metadata = db.getMetadata();
        OSchema schema = metadata.getSchema();
        OClass edgeClass = schema.getClass("E");
        if (edgeClass != null) {
            HashMap processedVertexes = new HashMap();
            long countEdges = db.countClass(edgeClass.getName());
            this.message(outputListener, countEdges + " will be processed.");
            long counter = 0L;
            for (ODocument edge : db.browseClass(edgeClass.getName())) {
                try {
                    HashSet<ORID> outVertexes;
                    String label;
                    if (edge.field("label") != null) {
                        label = (String)edge.field("label");
                    } else if (!edge.getClassName().equals(edgeClass.getName())) {
                        label = edge.getClassName();
                    } else {
                        ++counter;
                        continue;
                    }
                    ODocument inVertex = (ODocument)((OIdentifiable)edge.field("in")).getRecord();
                    ODocument outVertex = (ODocument)((OIdentifiable)edge.field("out")).getRecord();
                    String inVertexName = OrientVertex.getConnectionFieldName(Direction.IN, label, true);
                    String outVertexName = OrientVertex.getConnectionFieldName(Direction.OUT, label, true);
                    HashSet<ORID> inVertexes = (HashSet<ORID>)processedVertexes.get(inVertexName);
                    if (inVertexes == null) {
                        inVertexes = new HashSet<ORID>();
                        processedVertexes.put(inVertexName, inVertexes);
                    }
                    if ((outVertexes = (HashSet<ORID>)processedVertexes.get(outVertexName)) == null) {
                        outVertexes = new HashSet<ORID>();
                        processedVertexes.put(outVertexName, outVertexes);
                    }
                    if (inVertex.field(inVertexName) instanceof ORidBag) {
                        if (inVertexes.add(inVertex.getIdentity())) {
                            inVertex.field(inVertexName, new ORidBag());
                        }
                        ORidBag inRidBag = (ORidBag)inVertex.field(inVertexName);
                        inRidBag.add(edge.getIdentity());
                        inVertex.save();
                    }
                    if (outVertex.field(outVertexName) instanceof ORidBag) {
                        if (outVertexes.add(outVertex.getIdentity())) {
                            outVertex.field(outVertexName, new ORidBag());
                        }
                        ORidBag outRidBag = (ORidBag)outVertex.field(outVertexName);
                        outRidBag.add(edge.getIdentity());
                        outVertex.save();
                    }
                    if (++counter <= 0L || counter % 1000L != 0L) continue;
                    this.message(outputListener, counter + " edges were processed out of " + countEdges + " \n.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.message(outputListener, "Error during processing of edge with id " + edge.getIdentity() + "\n");
                }
            }
            this.message(outputListener, "Processed " + counter + " from " + countEdges + ".");
        }
        this.message(outputListener, "repair of ridbags is completed\n");
    }

    private void message(OCommandOutputListener outputListener, String message) {
        if (outputListener != null) {
            outputListener.onMessage(message);
        }
    }
}

