/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class LogASTTransformation
implements ASTTransformation {
    public void visit(ASTNode[] nodes, final SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            this.addError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes), nodes[0], source);
        }
        AnnotatedNode targetClass = (AnnotatedNode)nodes[1];
        AnnotationNode logAnnotation = (AnnotationNode)nodes[0];
        final LoggingStrategy loggingStrategy = this.createLoggingStrategy(logAnnotation);
        if (loggingStrategy == null) {
            return;
        }
        final String logFieldName = this.lookupLogFieldName(logAnnotation);
        if (!(targetClass instanceof ClassNode)) {
            throw new GroovyBugError("Class annotation " + logAnnotation.getClassNode().getName() + " annotated no Class, this must not happen.");
        }
        ClassNode classNode = (ClassNode)targetClass;
        ClassCodeExpressionTransformer transformer = new ClassCodeExpressionTransformer(){
            private FieldNode logNode;

            protected SourceUnit getSourceUnit() {
                return source;
            }

            public Expression transform(Expression exp) {
                if (exp == null) {
                    return null;
                }
                if (exp instanceof MethodCallExpression) {
                    return this.transformMethodCallExpression(exp);
                }
                return super.transform(exp);
            }

            public void visitClass(ClassNode node) {
                FieldNode logField = node.getField(logFieldName);
                if (logField != null && logField.getOwner().equals(node)) {
                    this.addError("Class annotated with Log annotation cannot have log field declared", logField);
                } else if (logField != null && !Modifier.isPrivate(logField.getModifiers())) {
                    this.addError("Class annotated with Log annotation cannot have log field declared because the field exists in the parent class: " + logField.getOwner().getName(), logField);
                } else {
                    this.logNode = loggingStrategy.addLoggerFieldToClass(node, logFieldName);
                }
                super.visitClass(node);
            }

            private Expression transformMethodCallExpression(Expression exp) {
                MethodCallExpression mce = (MethodCallExpression)exp;
                if (!(mce.getObjectExpression() instanceof VariableExpression)) {
                    return exp;
                }
                VariableExpression variableExpression = (VariableExpression)mce.getObjectExpression();
                if (!variableExpression.getName().equals(logFieldName) || !(variableExpression.getAccessedVariable() instanceof DynamicVariable)) {
                    return exp;
                }
                String methodName = mce.getMethodAsString();
                if (methodName == null) {
                    return exp;
                }
                if (this.usesSimpleMethodArgumentsOnly(mce)) {
                    return exp;
                }
                variableExpression.setAccessedVariable(this.logNode);
                if (!loggingStrategy.isLoggingMethod(methodName)) {
                    return exp;
                }
                return loggingStrategy.wrapLoggingMethodCall(variableExpression, methodName, exp);
            }

            private boolean usesSimpleMethodArgumentsOnly(MethodCallExpression mce) {
                Expression arguments = mce.getArguments();
                if (arguments instanceof TupleExpression) {
                    TupleExpression tuple = (TupleExpression)arguments;
                    for (Expression exp : tuple.getExpressions()) {
                        if (this.isSimpleExpression(exp)) continue;
                        return false;
                    }
                    return true;
                }
                return !this.isSimpleExpression(arguments);
            }

            private boolean isSimpleExpression(Expression exp) {
                if (exp instanceof ConstantExpression) {
                    return true;
                }
                return exp instanceof VariableExpression;
            }
        };
        transformer.visitClass(classNode);
    }

    private String lookupLogFieldName(AnnotationNode logAnnotation) {
        Expression member = logAnnotation.getMember("value");
        if (member != null && member.getText() != null) {
            return member.getText();
        }
        return "log";
    }

    public void addError(String msg, ASTNode expr, SourceUnit source) {
        int line = expr.getLineNumber();
        int col = expr.getColumnNumber();
        source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', line, col), source));
    }

    private LoggingStrategy createLoggingStrategy(AnnotationNode logAnnotation) {
        Object defaultValue;
        Method annotationMethod;
        Class<?> annotationClass;
        String annotationName = logAnnotation.getClassNode().getName();
        try {
            annotationClass = Class.forName(annotationName);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not resolve class named " + annotationName);
        }
        try {
            annotationMethod = annotationClass.getDeclaredMethod("loggingStrategy", null);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not find method named loggingStrategy on class named " + annotationName);
        }
        try {
            defaultValue = annotationMethod.getDefaultValue();
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not find default value of method named loggingStrategy on class named " + annotationName);
        }
        if (!LoggingStrategy.class.isAssignableFrom((Class)defaultValue)) {
            throw new RuntimeException("Default loggingStrategy value on class named " + annotationName + " is not a LoggingStrategy");
        }
        try {
            Class strategyClass = (Class)defaultValue;
            return (LoggingStrategy)strategyClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static interface LoggingStrategy {
        public FieldNode addLoggerFieldToClass(ClassNode var1, String var2);

        public boolean isLoggingMethod(String var1);

        public Expression wrapLoggingMethodCall(Expression var1, String var2, Expression var3);
    }
}

