/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ODistributedCounter
extends OOrientListenerAbstract {
    private static final int HASH_INCREMENT = 1640531527;
    private static final AtomicInteger nextHashCode = new AtomicInteger();
    private final AtomicBoolean poolBusy = new AtomicBoolean();
    private final int maxPartitions = Runtime.getRuntime().availableProcessors() << 3;
    private final int MAX_RETRIES = 8;
    private volatile ThreadLocal<Integer> threadHashCode = new ThreadHashCode();
    private volatile AtomicLong[] counters = new AtomicLong[2];

    public ODistributedCounter() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new AtomicLong();
        }
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    @Override
    public void onStartup() {
        if (this.threadHashCode == null) {
            this.threadHashCode = new ThreadHashCode();
        }
    }

    @Override
    public void onShutdown() {
        this.threadHashCode = null;
    }

    public void increment() {
        this.updateCounter(1L);
    }

    public void decrement() {
        this.updateCounter(-1L);
    }

    public void add(long delta) {
        this.updateCounter(delta);
    }

    public void clear() {
        while (!this.poolBusy.compareAndSet(false, true)) {
        }
        AtomicLong[] cts = new AtomicLong[this.counters.length];
        for (int i = 0; i < this.counters.length; ++i) {
            cts[i] = new AtomicLong();
        }
        this.counters = cts;
        this.poolBusy.set(true);
    }

    private void updateCounter(long delta) {
        int hashCode = this.threadHashCode.get();
        while (true) {
            int index;
            AtomicLong[] cts;
            AtomicLong counter;
            if ((counter = (cts = this.counters)[index = cts.length - 1 & hashCode]) == null) {
                if (this.poolBusy.get() || !this.poolBusy.compareAndSet(false, true)) continue;
                if (cts == this.counters && (counter = cts[index]) == null) {
                    cts[index] = new AtomicLong();
                }
                this.poolBusy.set(false);
                continue;
            }
            long v = counter.get();
            if (cts.length < this.maxPartitions) {
                for (int retries = 0; retries < 8; ++retries) {
                    if (!counter.compareAndSet(v, v + delta)) {
                        v = counter.get();
                        continue;
                    }
                    return;
                }
            } else {
                counter.addAndGet(delta);
                return;
            }
            if (this.poolBusy.get() || !this.poolBusy.compareAndSet(false, true)) continue;
            if (cts == this.counters && cts.length < this.maxPartitions) {
                this.counters = new AtomicLong[cts.length << 1];
                System.arraycopy(cts, 0, this.counters, 0, cts.length);
            }
            this.poolBusy.set(false);
        }
    }

    public boolean isEmpty() {
        return this.get() == 0L;
    }

    public long get() {
        long sum = 0L;
        for (AtomicLong counter : this.counters) {
            if (counter == null) continue;
            sum += counter.get();
        }
        return sum;
    }

    private static int nextHashCode() {
        return nextHashCode.getAndAdd(1640531527);
    }

    private static final class ThreadHashCode
    extends ThreadLocal<Integer> {
        private ThreadHashCode() {
        }

        @Override
        protected Integer initialValue() {
            return ODistributedCounter.nextHashCode();
        }
    }
}

