/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.orientechnologies.common.concur.resource.OPartitionedObjectPool;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class OPartitionedObjectPoolFactory<K, T>
extends OOrientListenerAbstract {
    private volatile int maxPartitions = Runtime.getRuntime().availableProcessors() << 3;
    private volatile int maxPoolSize = 64;
    private boolean closed = false;
    private final ConcurrentLinkedHashMap<K, OPartitionedObjectPool<T>> poolStore;
    private final ObjectFactoryFactory<K, T> objectFactoryFactory;
    private final EvictionListener<K, OPartitionedObjectPool<T>> evictionListener = new EvictionListener<K, OPartitionedObjectPool<T>>(){

        @Override
        public void onEviction(K key, OPartitionedObjectPool<T> partitionedObjectPool) {
            partitionedObjectPool.close();
        }
    };

    public OPartitionedObjectPoolFactory(ObjectFactoryFactory<K, T> objectFactoryFactory) {
        this(objectFactoryFactory, 100);
    }

    public OPartitionedObjectPoolFactory(ObjectFactoryFactory<K, T> objectFactoryFactory, int capacity) {
        this.objectFactoryFactory = objectFactoryFactory;
        this.poolStore = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(capacity).listener(this.evictionListener).build();
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.checkForClose();
        this.maxPoolSize = maxPoolSize;
    }

    public OPartitionedObjectPool<T> get(K key) {
        this.checkForClose();
        OPartitionedObjectPool<T> pool = this.poolStore.get(key);
        if (pool != null) {
            return pool;
        }
        pool = new OPartitionedObjectPool(this.objectFactoryFactory.create(key), this.maxPoolSize, this.maxPartitions);
        OPartitionedObjectPool<T> oldPool = this.poolStore.putIfAbsent(key, pool);
        if (oldPool != null) {
            pool.close();
            return oldPool;
        }
        return pool;
    }

    public int getMaxPartitions() {
        return this.maxPartitions;
    }

    public void setMaxPartitions(int maxPartitions) {
        this.maxPartitions = maxPartitions;
    }

    public Collection<OPartitionedObjectPool<T>> getPools() {
        this.checkForClose();
        return Collections.unmodifiableCollection(this.poolStore.values());
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        while (!this.poolStore.isEmpty()) {
            Iterator<OPartitionedObjectPool<T>> poolIterator = this.poolStore.values().iterator();
            while (poolIterator.hasNext()) {
                OPartitionedObjectPool<T> pool = poolIterator.next();
                try {
                    pool.close();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error during pool close", (Throwable)e, new Object[0]);
                }
                poolIterator.remove();
            }
        }
        for (OPartitionedObjectPool<T> pool : this.poolStore.values()) {
            pool.close();
        }
        this.poolStore.clear();
    }

    @Override
    public void onShutdown() {
        this.close();
    }

    private void checkForClose() {
        if (this.closed) {
            throw new IllegalStateException("Pool factory is closed");
        }
    }

    public static interface ObjectFactoryFactory<K, T> {
        public OPartitionedObjectPool.ObjectFactory<T> create(K var1);
    }
}

