/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelListener;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ORemoteConnectionManager
implements OChannelListener {
    public static final String PARAM_MAX_POOL = "maxpool";
    protected final ConcurrentHashMap<String, OResourcePool<String, OChannelBinaryAsynchClient>> connections = new ConcurrentHashMap();
    protected final long timeout;

    public ORemoteConnectionManager(int iMaxConnectionPerURL, long iTimeout) {
        this.timeout = iTimeout;
    }

    public void close() {
        for (Map.Entry<String, OResourcePool<String, OChannelBinaryAsynchClient>> entry : this.connections.entrySet()) {
            this.closePool(entry.getValue());
        }
        this.connections.clear();
    }

    public OChannelBinaryAsynchClient acquire(String iServerURL, OContextConfiguration clientConfiguration, Map<String, Object> iConfiguration, ORemoteServerEventListener iListener) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(iServerURL);
        if (pool == null) {
            OResourcePool<String, OChannelBinaryAsynchClient> prev;
            int maxPool = OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL.getValueAsInteger();
            if (iConfiguration != null && iConfiguration.size() > 0 && iConfiguration.containsKey(PARAM_MAX_POOL)) {
                maxPool = Integer.parseInt(iConfiguration.get(PARAM_MAX_POOL).toString());
            }
            if ((prev = this.connections.putIfAbsent(iServerURL, pool = new OResourcePool<String, OChannelBinaryAsynchClient>(maxPool, new OResourcePoolListener<String, OChannelBinaryAsynchClient>(){

                @Override
                public OChannelBinaryAsynchClient createNewResource(String iKey, Object ... iAdditionalArgs) {
                    return ORemoteConnectionManager.this.createNetworkConnection(iKey, (OContextConfiguration)iAdditionalArgs[0], (Map)iAdditionalArgs[1], (ORemoteServerEventListener)iAdditionalArgs[2]);
                }

                @Override
                public boolean reuseResource(String iKey, Object[] iAdditionalArgs, OChannelBinaryAsynchClient iValue) {
                    return iValue.isConnected();
                }
            }))) != null) {
                pool.close();
                pool = prev;
            }
        }
        try {
            OChannelBinaryAsynchClient ret = pool.getResource(iServerURL, this.timeout, clientConfiguration, iConfiguration, iListener);
            return ret;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on retrieving the connection from pool: " + iServerURL, (Throwable)e, new Object[0]);
            return null;
        }
    }

    public void release(OChannelBinaryAsynchClient conn) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(conn.getServerURL());
        if (pool != null) {
            if (!conn.isConnected()) {
                OLogManager.instance().debug((Object)this, "Network connection pool is receiving a closed connection to reuse: discard it", new Object[0]);
                this.remove(conn);
            } else {
                pool.returnResource(conn);
            }
        }
    }

    public void remove(OChannelBinaryAsynchClient conn) {
        try {
            conn.unlock();
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Cannot unlock connection lock", (Throwable)e, new Object[0]);
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Cannot close connection", (Throwable)e, new Object[0]);
        }
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(conn.getServerURL());
        if (pool == null) {
            throw new IllegalStateException("Connection cannot be released because the pool doesn't exist anymore");
        }
        pool.remove(conn);
    }

    @Override
    public void onChannelClose(OChannel channel) {
        OChannelBinaryAsynchClient conn = (OChannelBinaryAsynchClient)channel;
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(conn.getServerURL());
        if (pool == null) {
            throw new IllegalStateException("Connection cannot be released because the pool doesn't exist anymore");
        }
        pool.remove(conn);
    }

    public Set<String> getURLs() {
        return this.connections.keySet();
    }

    public int getMaxResources(String url) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getMaxResources();
    }

    public int getAvailableConnections(String url) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getAvailableResources();
    }

    public int getReusableConnections(String url) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getInPoolResources();
    }

    public int getCreatedInstancesInPool(String url) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getCreatedInstances();
    }

    public void closePool(String url) {
        OResourcePool<String, OChannelBinaryAsynchClient> pool = this.connections.remove(url);
        if (pool == null) {
            return;
        }
        this.closePool(pool);
    }

    protected void closePool(OResourcePool<String, OChannelBinaryAsynchClient> pool) {
        ArrayList<OChannelBinaryAsynchClient> conns = new ArrayList<OChannelBinaryAsynchClient>(pool.getAllResources());
        for (OChannelBinaryAsynchClient c : conns) {
            try {
                c.unregisterListener(this);
                c.close();
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Cannot close binary channel", (Throwable)e, new Object[0]);
            }
        }
        pool.close();
    }

    protected OChannelBinaryAsynchClient createNetworkConnection(String iServerURL, OContextConfiguration clientConfiguration, Map<String, Object> iAdditionalArg, ORemoteServerEventListener asynchEventListener) throws OIOException {
        if (iServerURL == null) {
            throw new IllegalArgumentException("server url is null");
        }
        try {
            String databaseName;
            String serverURL;
            OLogManager.instance().debug((Object)this, "Trying to connect to the remote host %s...", iServerURL);
            int sepPos = iServerURL.indexOf("/");
            if (sepPos > -1) {
                serverURL = iServerURL.substring(0, sepPos);
                databaseName = iServerURL.substring(sepPos + 1);
            } else {
                serverURL = iServerURL;
                databaseName = null;
            }
            sepPos = serverURL.indexOf(":");
            String remoteHost = serverURL.substring(0, sepPos);
            int remotePort = Integer.parseInt(serverURL.substring(sepPos + 1));
            OChannelBinaryAsynchClient ch = new OChannelBinaryAsynchClient(remoteHost, remotePort, databaseName, clientConfiguration, 32, asynchEventListener);
            ch.registerListener(this);
            return ch;
        }
        catch (OIOException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on connecting to %s", (Throwable)e, iServerURL);
            throw new OIOException("Error on connecting to " + iServerURL, e);
        }
    }
}

