/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.resource.OPartitionedObjectPool;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandExecutorUtility;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class OCommandExecutorScript
extends OCommandExecutorAbstract
implements OCommandDistributedReplicateRequest {
    private static final int MAX_DELAY = 100;
    protected OCommandScript request;
    protected OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE executionMode = OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;

    public OCommandExecutorScript parse(OCommandRequest iRequest) {
        this.request = (OCommandScript)iRequest;
        this.executionMode = ((OCommandScript)iRequest).getExecutionMode();
        return this;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return this.executionMode;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        return this.executeInContext(this.context, iArgs);
    }

    public Object executeInContext(OCommandContext iContext, Map<Object, Object> iArgs) {
        String language = this.request.getLanguage();
        this.parserText = this.request.getText();
        this.parameters = iArgs;
        this.parameters = iArgs;
        if (language.equalsIgnoreCase("SQL")) {
            return this.executeSQL();
        }
        return this.executeJsr223Script(language, iContext, iArgs);
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    /*
     * Loose catch block
     */
    protected Object executeJsr223Script(String language, OCommandContext iContext, Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        OScriptManager scriptManager = Orient.instance().getScriptManager();
        CompiledScript compiledScript = this.request.getCompiledScript();
        OPartitionedObjectPool.PoolEntry<ScriptEngine> entry = scriptManager.acquireDatabaseEngine(db.getName(), language);
        ScriptEngine scriptEngine = (ScriptEngine)entry.object;
        try {
            if (compiledScript == null) {
                if (!(scriptEngine instanceof Compilable)) {
                    throw new OCommandExecutionException("Language '" + language + "' does not support compilation");
                }
                Compilable c = (Compilable)((Object)scriptEngine);
                try {
                    compiledScript = c.compile(this.parserText);
                }
                catch (ScriptException e) {
                    scriptManager.throwErrorMessage(e, this.parserText);
                }
                this.request.setCompiledScript(compiledScript);
            }
            Bindings binding = scriptManager.bind(compiledScript.getEngine().getBindings(100), (ODatabaseDocumentTx)db, iContext, iArgs);
            try {
                Object ob = compiledScript.eval(binding);
                Object object = OCommandExecutorUtility.transformResult(ob);
                return object;
            }
            catch (ScriptException e) {
                throw new OCommandScriptException("Error on execution of the script", this.request.getText(), e.getColumnNumber(), e);
            }
            finally {
                scriptManager.unbind(binding, iContext, iArgs);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            scriptManager.releaseDatabaseEngine(language, db.getName(), entry);
        }
    }

    protected Object executeSQL() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        try {
            return this.executeSQLScript(this.parserText, db);
        }
        catch (IOException e) {
            throw new OCommandExecutionException("Error on executing command: " + this.parserText, e);
        }
    }

    @Override
    protected void throwSyntaxErrorException(String iText) {
        throw new OCommandScriptException("Error on execution of the script: " + iText, this.request.getText(), 0);
    }

    protected Object executeSQLScript(String iText, ODatabaseDocument db) throws IOException {
        Object lastResult = null;
        int maxRetry = 1;
        this.context.setVariable("transactionRetries", 0);
        for (int retry = 1; retry <= maxRetry; ++retry) {
            try {
                try {
                    String lastLine;
                    int line;
                    int txBegunAtLine = -1;
                    int txBegunAtPart = -1;
                    lastResult = null;
                    BufferedReader reader = new BufferedReader(new StringReader(iText));
                    int linePart = 0;
                    boolean txBegun = false;
                    for (line = 0; line < txBegunAtLine; ++line) {
                        reader.readLine();
                    }
                    while ((lastLine = reader.readLine()) != null) {
                        lastLine = lastLine.trim();
                        List<String> lineParts = OStringSerializerHelper.smartSplit(lastLine, ';', true, new char[0]);
                        for (linePart = line == txBegunAtLine ? txBegunAtPart : 0; linePart < lineParts.size(); ++linePart) {
                            String next;
                            String lastCommand = lineParts.get(linePart);
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "let ")) {
                                lastResult = this.executeLet(lastCommand, db);
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "begin")) {
                                if (txBegun) {
                                    throw new OCommandSQLParsingException("Transaction already begun");
                                }
                                if (db.getTransaction().isActive()) {
                                    db.commit();
                                }
                                txBegun = true;
                                txBegunAtLine = line;
                                txBegunAtPart = linePart;
                                db.begin();
                                if (lastCommand.length() <= "begin ".length() || !OStringSerializerHelper.startsWithIgnoreCase(next = lastCommand.substring("begin ".length()).trim(), "isolation ")) continue;
                                next = next.substring("isolation ".length()).trim();
                                db.getTransaction().setIsolationLevel(OTransaction.ISOLATION_LEVEL.valueOf(next.toUpperCase()));
                                continue;
                            }
                            if ("rollback".equalsIgnoreCase(lastCommand)) {
                                if (!txBegun) {
                                    throw new OCommandSQLParsingException("Transaction not begun");
                                }
                                db.rollback();
                                txBegun = false;
                                txBegunAtLine = -1;
                                txBegunAtPart = -1;
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "commit")) {
                                if (txBegunAtLine < 0) {
                                    throw new OCommandSQLParsingException("Transaction not begun");
                                }
                                if (retry == 1 && lastCommand.length() > "commit ".length() && OStringSerializerHelper.startsWithIgnoreCase(next = lastCommand.substring("commit ".length()).trim(), "retry ")) {
                                    next = next.substring("retry ".length()).trim();
                                    maxRetry = Integer.parseInt(next);
                                }
                                db.commit();
                                txBegun = false;
                                txBegunAtLine = -1;
                                txBegunAtPart = -1;
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "sleep ")) {
                                this.executeSleep(lastCommand);
                                continue;
                            }
                            if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "return ")) {
                                lastResult = this.executeReturn(lastCommand, lastResult);
                                break;
                            }
                            if (lastCommand == null || lastCommand.length() <= 0) continue;
                            lastResult = this.executeCommand(lastCommand, db);
                        }
                        ++line;
                    }
                    break;
                }
                catch (RuntimeException ex) {
                    if (db.getTransaction().isActive()) {
                        db.rollback();
                    }
                    throw ex;
                }
            }
            catch (OTransactionException e) {
                this.context.setVariable("retries", retry);
                OCommandExecutorScript.getDatabase().getLocalCache().clear();
                if (retry >= maxRetry) {
                    throw e;
                }
                this.waitForNextRetry();
                continue;
            }
            catch (ORecordDuplicatedException e) {
                this.context.setVariable("retries", retry);
                OCommandExecutorScript.getDatabase().getLocalCache().clear();
                if (retry >= maxRetry) {
                    throw e;
                }
                this.waitForNextRetry();
                continue;
            }
            catch (ORecordNotFoundException e) {
                this.context.setVariable("retries", retry);
                OCommandExecutorScript.getDatabase().getLocalCache().clear();
                if (retry < maxRetry) continue;
                throw e;
            }
            catch (ONeedRetryException e) {
                this.context.setVariable("retries", retry);
                OCommandExecutorScript.getDatabase().getLocalCache().clear();
                if (retry >= maxRetry) {
                    throw e;
                }
                this.waitForNextRetry();
            }
        }
        return lastResult;
    }

    protected void waitForNextRetry() {
        try {
            Thread.sleep(new Random().nextInt(99) + 1);
        }
        catch (InterruptedException e) {
            OLogManager.instance().error((Object)this, "Wait was interrupted", (Throwable)e, new Object[0]);
        }
    }

    private Object executeCommand(String lastCommand, ODatabaseDocument db) {
        return db.command(new OCommandSQL(lastCommand).setContext(this.getContext())).execute(this.toMap(this.parameters));
    }

    private Object toMap(Object parameters) {
        if (parameters instanceof SimpleBindings) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.putAll((SimpleBindings)parameters);
            return result;
        }
        return parameters;
    }

    private Object executeReturn(String lastCommand, Object lastResult) {
        String variable = lastCommand.substring("return ".length()).trim();
        if (variable.equalsIgnoreCase("NULL")) {
            lastResult = null;
        } else if (variable.startsWith("$")) {
            lastResult = this.getContext().getVariable(variable);
        } else if (variable.startsWith("[") && variable.endsWith("]")) {
            ArrayList<String> items = new ArrayList<String>();
            OStringSerializerHelper.getCollection(variable, 0, items);
            ArrayList<Object> result = new ArrayList<Object>(items.size());
            for (int i = 0; i < items.size(); ++i) {
                String item = (String)items.get(i);
                Object res = item.startsWith("$") ? this.getContext().getVariable(item) : item;
                if (OMultiValue.isMultiValue(res) && OMultiValue.getSize(res) == 1) {
                    res = OMultiValue.getFirstValue(res);
                }
                result.add(res);
            }
            lastResult = result;
        } else if (variable.startsWith("{") && variable.endsWith("}")) {
            Map<String, String> map = OStringSerializerHelper.getMap(variable);
            HashMap<Object, Object> result = new HashMap<Object, Object>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String stringValue;
                String stringKey = entry.getKey();
                if (stringKey == null) continue;
                Object key = (stringKey = stringKey.trim()).startsWith("$") ? this.getContext().getVariable(stringKey) : stringKey;
                if (OMultiValue.isMultiValue(key) && OMultiValue.getSize(key) == 1) {
                    key = OMultiValue.getFirstValue(key);
                }
                if ((stringValue = entry.getValue()) == null) continue;
                Object value = (stringValue = stringValue.trim()).toString().startsWith("$") ? this.getContext().getVariable(stringValue) : stringValue;
                result.put(key, value);
            }
            lastResult = result;
        } else {
            lastResult = variable;
        }
        return lastResult;
    }

    private void executeSleep(String lastCommand) {
        String sleepTimeInMs = lastCommand.substring("sleep ".length()).trim();
        try {
            Thread.sleep(Integer.parseInt(sleepTimeInMs));
        }
        catch (InterruptedException e) {
            OLogManager.instance().error((Object)this, "Sleep was interrupted", (Throwable)e, new Object[0]);
        }
    }

    private Object executeLet(String lastCommand, ODatabaseDocument db) {
        int equalsPos = lastCommand.indexOf(61);
        String variable = lastCommand.substring("let ".length(), equalsPos).trim();
        String cmd = lastCommand.substring(equalsPos + 1).trim();
        Object lastResult = this.executeCommand(cmd, db);
        this.getContext().setVariable(variable, lastResult);
        return lastResult;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }
}

