/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OLazyRecordIterator;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.record.OIdentityChangeListener;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationSetThreadLocal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ORecordLazySet
extends ORecordTrackedSet
implements Set<OIdentifiable>,
ORecordLazyMultiValue,
ORecordElement,
OIdentityChangeListener {
    protected boolean autoConvertToRecord = true;

    public ORecordLazySet(ODocument iSourceRecord) {
        super(iSourceRecord);
    }

    public ORecordLazySet(ODocument iSourceRecord, Collection<OIdentifiable> iOrigin) {
        this(iSourceRecord);
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.addAll((Collection<? extends OIdentifiable>)iOrigin);
        }
    }

    @Override
    public boolean detach() {
        return this.convertRecords2Links();
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new OLazyRecordIterator((Iterator<? extends OIdentifiable>)new OLazyIterator<OIdentifiable>(){
            private Iterator<Map.Entry<OIdentifiable, Object>> iter;
            private Map.Entry<OIdentifiable, Object> last;
            {
                ORecordElement cur = null;
                if (ORecordLazySet.this.sourceRecord != null) {
                    cur = ORecordLazySet.this.sourceRecord.getOwner();
                }
                if (!(cur instanceof ODocument)) {
                    cur = ORecordLazySet.this.sourceRecord;
                }
                this.iter = OSerializationSetThreadLocal.check((ODocument)cur) ? new HashSet(ORecordLazySet.this.map.entrySet()).iterator() : ORecordLazySet.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public OIdentifiable next() {
                Map.Entry<OIdentifiable, Object> entry = this.iter.next();
                this.last = entry;
                if (entry.getValue() != ORecordTrackedSet.ENTRY_REMOVAL) {
                    return (OIdentifiable)entry.getValue();
                }
                return entry.getKey();
            }

            @Override
            public void remove() {
                this.iter.remove();
                if (this.last.getKey() instanceof ORecord) {
                    ORecordInternal.removeIdentityChangeListener((ORecord)this.last.getKey(), ORecordLazySet.this);
                }
            }

            @Override
            public OIdentifiable update(OIdentifiable iValue) {
                if (iValue != null) {
                    ORecordLazySet.this.map.put(iValue.getIdentity(), iValue.getRecord());
                }
                return iValue;
            }
        }, this.autoConvertToRecord && this.getOwner().getInternalStatus() != ORecordElement.STATUS.MARSHALLING);
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        return new OLazyRecordIterator(super.iterator(), false);
    }

    @Override
    public boolean add(OIdentifiable e) {
        if (this.map.containsKey(e)) {
            return false;
        }
        if (e == null) {
            this.map.put(null, null);
        } else if (e instanceof ORecord && e.getIdentity().isNew()) {
            ORecordInternal.addIdentityChangeListener((ORecord)e, this);
            this.map.put(e, e);
        } else if (!e.getIdentity().isPersistent()) {
            Object record = e.getRecord();
            if (record == null) {
                throw new IllegalArgumentException("Record with id " + e.getIdentity() + " has not be found");
            }
            ORecordInternal.addIdentityChangeListener(record, this);
            this.map.put(e, record);
        } else {
            this.map.put(e, ENTRY_REMOVAL);
        }
        this.setDirty();
        this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.ADD, e, e));
        return true;
    }

    @Override
    public void convertLinks2Records() {
        for (Map.Entry entry : this.map.entrySet()) {
            if (entry.getValue() != ENTRY_REMOVAL) continue;
            try {
                entry.setValue(((OIdentifiable)entry.getKey()).getRecord());
            }
            catch (ORecordNotFoundException oRecordNotFoundException) {}
        }
    }

    @Override
    public void onAfterIdentityChange(ORecord record) {
        this.map.put(record, record);
    }

    @Override
    public void onBeforeIdentityChange(ORecord record) {
        this.map.remove(record);
    }

    @Override
    public boolean convertRecords2Links() {
        return true;
    }

    public boolean clearDeletedRecords() {
        boolean removed = false;
        Iterator all = this.map.entrySet().iterator();
        while (all.hasNext()) {
            Map.Entry entry = all.next();
            if (entry.getValue() != ENTRY_REMOVAL) continue;
            try {
                if (((OIdentifiable)entry.getKey()).getRecord() != null) continue;
                all.remove();
                removed = true;
            }
            catch (ORecordNotFoundException e) {
                all.remove();
                removed = true;
            }
        }
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return this.clearDeletedRecords();
        }
        Object old = this.map.remove(o);
        if (old != null) {
            if (o instanceof ORecord) {
                ORecordInternal.removeIdentityChangeListener((ORecord)o, this);
            }
            this.setDirty();
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, (OIdentifiable)o, null, (OIdentifiable)o));
            return true;
        }
        return false;
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.autoConvertToRecord = convertToRecord;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Set) {
            Set coll = (Set)obj;
            if (this.map.size() == coll.size()) {
                for (Object obje : coll) {
                    if (this.map.containsKey(obje)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

