/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.fetch;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.fetch.OFetchPlan;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OFetchHelper {
    public static final String DEFAULT = "*:0";
    public static final OFetchPlan DEFAULT_FETCHPLAN = new OFetchPlan("*:0");

    public static OFetchPlan buildFetchPlan(String iFetchPlan) {
        if (iFetchPlan == null) {
            return null;
        }
        if (DEFAULT.equals(iFetchPlan)) {
            return DEFAULT_FETCHPLAN;
        }
        return new OFetchPlan(iFetchPlan);
    }

    public static void fetch(ORecord iRootRecord, Object iUserObject, OFetchPlan iFetchPlan, OFetchListener iListener, OFetchContext iContext, String iFormat) {
        try {
            if (iRootRecord instanceof ODocument) {
                boolean isEmbedded;
                ODocument record = (ODocument)iRootRecord;
                HashMap<ORID, Integer> parsedRecords = new HashMap<ORID, Integer>();
                boolean bl = isEmbedded = record.isEmbedded() || !record.getIdentity().isPersistent();
                if (!isEmbedded) {
                    parsedRecords.put(iRootRecord.getIdentity(), 0);
                }
                if (!iFormat.contains("shallow")) {
                    OFetchHelper.processRecordRidMap(record, iFetchPlan, 0, 0, -1, parsedRecords, "", iContext);
                }
                OFetchHelper.processRecord(record, iUserObject, iFetchPlan, 0, 0, -1, parsedRecords, "", iListener, iContext, iFormat);
            }
        }
        catch (Exception e) {
            OLogManager.instance().error(null, "Fetching error on record %s", (Throwable)e, iRootRecord.getIdentity());
        }
    }

    public static void checkFetchPlanValid(String iFetchPlan) {
        if (iFetchPlan != null && !iFetchPlan.isEmpty()) {
            List<String> planParts = OStringSerializerHelper.split(iFetchPlan, ' ', new char[0]);
            if (!planParts.isEmpty()) {
                for (String planPart : planParts) {
                    List<String> parts = OStringSerializerHelper.split(planPart, ':', new char[0]);
                    if (parts.size() == 2) continue;
                    throw new IllegalArgumentException("Fetch plan '" + iFetchPlan + "' is invalid");
                }
            } else {
                throw new IllegalArgumentException("Fetch plan '" + iFetchPlan + "' is invalid");
            }
        }
    }

    public static boolean isFetchPlanValid(String iFetchPlan) {
        if (iFetchPlan != null && !iFetchPlan.isEmpty()) {
            List<String> planParts = OStringSerializerHelper.split(iFetchPlan, ' ', new char[0]);
            if (!planParts.isEmpty()) {
                for (String planPart : planParts) {
                    List<String> parts = OStringSerializerHelper.split(planPart, ':', new char[0]);
                    if (parts.size() == 2) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static int getDepthLevel(OFetchPlan iFetchPlan, String iFieldPath, int iCurrentLevel) {
        if (iFetchPlan == null) {
            return 0;
        }
        return iFetchPlan.getDepthLevel(iFieldPath, iCurrentLevel);
    }

    public static void processRecordRidMap(ODocument record, OFetchPlan iFetchPlan, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        if (iFetchPlan == null) {
            return;
        }
        if (iFetchPlan == DEFAULT_FETCHPLAN) {
            return;
        }
        for (String fieldName : record.fieldNames()) {
            Object fieldValue;
            String fieldPath = !iFieldPathFromRoot.isEmpty() ? iFieldPathFromRoot + "." + fieldName : fieldName;
            int depthLevel = OFetchHelper.getDepthLevel(iFetchPlan, fieldPath, iCurrentLevel);
            if (depthLevel == -2) continue;
            if (iFieldDepthLevel > -1) {
                depthLevel = iFieldDepthLevel;
            }
            if (!((fieldValue = record.rawField(fieldName)) != null && (fieldValue instanceof OIdentifiable || fieldValue instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)fieldValue).rawIterator().hasNext() && ((ORecordLazyMultiValue)fieldValue).rawIterator().next() instanceof OIdentifiable || fieldValue instanceof Collection && ((Collection)fieldValue).size() != 0 && ((Collection)fieldValue).iterator().next() instanceof OIdentifiable || fieldValue.getClass().isArray() && Array.getLength(fieldValue) != 0 && Array.get(fieldValue, 0) instanceof OIdentifiable || fieldValue instanceof OMultiCollectionIterator || fieldValue instanceof Map && ((Map)fieldValue).size() != 0 && ((Map)fieldValue).values().iterator().next() instanceof OIdentifiable))) continue;
            try {
                int nextLevel;
                boolean isEmbedded = OFetchHelper.isEmbedded(fieldValue);
                if (iFetchPlan == null || (!isEmbedded || !iContext.fetchEmbeddedDocuments()) && !iFetchPlan.has(fieldPath, iCurrentLevel) && depthLevel > -1 && iCurrentLevel >= depthLevel) continue;
                int n = nextLevel = isEmbedded ? iLevelFromRoot : iLevelFromRoot + 1;
                if (fieldValue instanceof ORecordId) {
                    fieldValue = ((ORecordId)fieldValue).getRecord();
                }
                OFetchHelper.fetchRidMap(record, iFetchPlan, fieldValue, fieldName, iCurrentLevel, nextLevel, iFieldDepthLevel, parsedRecords, fieldPath, iContext);
            }
            catch (Exception e) {
                OLogManager.instance().error(null, "Fetching error on record %s", (Throwable)e, record.getIdentity());
            }
        }
    }

    private static void fetchRidMap(ODocument iRootRecord, OFetchPlan iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof ODocument) {
            OFetchHelper.fetchDocumentRidMap(iFetchPlan, fieldValue, fieldName, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        } else if (fieldValue instanceof Iterable) {
            OFetchHelper.fetchCollectionRidMap(iFetchPlan, fieldValue, fieldName, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        } else if (fieldValue.getClass().isArray()) {
            OFetchHelper.fetchArrayRidMap(iFetchPlan, fieldValue, fieldName, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        } else if (fieldValue instanceof Map) {
            OFetchHelper.fetchMapRidMap(iFetchPlan, fieldValue, fieldName, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        }
    }

    private static void fetchDocumentRidMap(OFetchPlan iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        OFetchHelper.updateRidMap(iFetchPlan, (ODocument)fieldValue, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
    }

    private static void fetchCollectionRidMap(OFetchPlan iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        Iterable linked = (Iterable)fieldValue;
        for (OIdentifiable d : linked) {
            if (d == null) continue;
            d = d.getRecord();
            OFetchHelper.updateRidMap(iFetchPlan, (ODocument)d, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        }
    }

    private static void fetchArrayRidMap(OFetchPlan iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        if (fieldValue instanceof ODocument[]) {
            ODocument[] linked;
            for (ODocument d : linked = (ODocument[])fieldValue) {
                OFetchHelper.updateRidMap(iFetchPlan, d, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
            }
        }
    }

    private static void fetchMapRidMap(OFetchPlan iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        Map linked = (Map)fieldValue;
        for (ODocument d : linked.values()) {
            OFetchHelper.updateRidMap(iFetchPlan, d, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        }
    }

    private static void updateRidMap(OFetchPlan iFetchPlan, ODocument fieldValue, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        boolean isEmbedded;
        Integer fetchedLevel = parsedRecords.get(fieldValue.getIdentity());
        int currentLevel = iCurrentLevel + 1;
        int fieldDepthLevel = iFieldDepthLevel;
        if (iFetchPlan != null && iFetchPlan.has(iFieldPathFromRoot, iCurrentLevel)) {
            currentLevel = 1;
            fieldDepthLevel = iFetchPlan.getDepthLevel(iFieldPathFromRoot, iCurrentLevel);
        }
        if ((isEmbedded = OFetchHelper.isEmbedded(fieldValue)) || fetchedLevel == null) {
            if (!isEmbedded) {
                parsedRecords.put(fieldValue.getIdentity(), iLevelFromRoot);
            }
            OFetchHelper.processRecordRidMap(fieldValue, iFetchPlan, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        }
    }

    private static void processRecord(ODocument record, Object iUserObject, OFetchPlan iFetchPlan, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext, String iFormat) throws IOException {
        if (record == null) {
            return;
        }
        iContext.onBeforeFetch(record);
        HashSet<String> toRemove = new HashSet<String>();
        for (String fieldName : record.fieldNames()) {
            String fieldPath = !iFieldPathFromRoot.isEmpty() ? iFieldPathFromRoot + "." + fieldName : fieldName;
            int depthLevel = OFetchHelper.getDepthLevel(iFetchPlan, fieldPath, iCurrentLevel);
            if (depthLevel == -2) {
                toRemove.add(fieldName);
                continue;
            }
            if (iFieldDepthLevel > -1) {
                depthLevel = iFieldDepthLevel;
            }
            Object fieldValue = record.rawField(fieldName);
            boolean fetch = !iFormat.contains("shallow") && (!(fieldValue instanceof OIdentifiable) || depthLevel == -1 || iCurrentLevel <= depthLevel || iFetchPlan != null && iFetchPlan.has(fieldPath, iCurrentLevel));
            boolean isEmbedded = OFetchHelper.isEmbedded(fieldValue);
            if (!fetch && isEmbedded && iContext.fetchEmbeddedDocuments()) {
                fetch = true;
            }
            if (!(!iFormat.contains("shallow") && fieldValue != null && (fetch || !(fieldValue instanceof OIdentifiable)) && (fieldValue instanceof OIdentifiable || fieldValue instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)fieldValue).rawIterator().hasNext() && ((ORecordLazyMultiValue)fieldValue).rawIterator().next() instanceof OIdentifiable || fieldValue.getClass().isArray() && Array.getLength(fieldValue) != 0 && Array.get(fieldValue, 0) instanceof OIdentifiable || OMultiValue.getFirstValue(fieldValue) instanceof OIdentifiable || OMultiValue.getFirstValue(OMultiValue.getFirstValue(fieldValue)) instanceof OIdentifiable || OMultiValue.getFirstValue(OMultiValue.getFirstValue(OMultiValue.getFirstValue(fieldValue))) instanceof OIdentifiable))) {
                iContext.onBeforeStandardField(fieldValue, fieldName, iUserObject);
                iListener.processStandardField(record, fieldValue, fieldName, iContext, iUserObject, iFormat);
                iContext.onAfterStandardField(fieldValue, fieldName, iUserObject);
                continue;
            }
            try {
                if (!fetch) continue;
                int nextLevel = isEmbedded ? iLevelFromRoot : iLevelFromRoot + 1;
                OFetchHelper.fetch(record, iUserObject, iFetchPlan, fieldValue, fieldName, iCurrentLevel, nextLevel, iFieldDepthLevel, parsedRecords, depthLevel, fieldPath, iListener, iContext);
            }
            catch (Exception e) {
                OLogManager.instance().error(null, "Fetching error on record %s", (Throwable)e, record.getIdentity());
            }
        }
        for (String fieldName : toRemove) {
            iListener.skipStandardField(record, fieldName, iContext, iUserObject, iFormat);
        }
        iContext.onAfterFetch(record);
    }

    public static boolean isEmbedded(Object fieldValue) {
        boolean isEmbedded;
        boolean bl = isEmbedded = fieldValue instanceof ODocument && (((ODocument)fieldValue).isEmbedded() || !((ODocument)fieldValue).getIdentity().isPersistent());
        if (fieldValue instanceof ORidBag) {
            return false;
        }
        if (!isEmbedded) {
            try {
                Object f = OMultiValue.getFirstValue(fieldValue);
                isEmbedded = f != null && f instanceof ODocument && (((ODocument)f).isEmbedded() || !((ODocument)f).getIdentity().isPersistent());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isEmbedded;
    }

    private static void fetch(ODocument iRootRecord, Object iUserObject, OFetchPlan iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, int depthLevel, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        int currentLevel = iCurrentLevel + 1;
        int fieldDepthLevel = iFieldDepthLevel;
        if (iFetchPlan != null && iFetchPlan.has(iFieldPathFromRoot, iCurrentLevel)) {
            currentLevel = 0;
            fieldDepthLevel = iFetchPlan.getDepthLevel(iFieldPathFromRoot, iCurrentLevel);
        }
        if (fieldValue == null) {
            iListener.processStandardField(iRootRecord, null, fieldName, iContext, iUserObject, "");
        } else if (fieldValue instanceof OIdentifiable) {
            if (fieldValue instanceof ODocument && ((ODocument)fieldValue).getClassName() != null && ((ODocument)fieldValue).getClassName().equals("ORIDs")) {
                OFetchHelper.fetchCollection(iRootRecord, iUserObject, iFetchPlan, fieldValue, fieldName, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
            } else {
                OFetchHelper.fetchDocument(iRootRecord, iUserObject, iFetchPlan, (OIdentifiable)fieldValue, fieldName, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
            }
        } else if (fieldValue instanceof Map) {
            OFetchHelper.fetchMap(iRootRecord, iUserObject, iFetchPlan, fieldValue, fieldName, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
        } else if (OMultiValue.isMultiValue(fieldValue)) {
            OFetchHelper.fetchCollection(iRootRecord, iUserObject, iFetchPlan, fieldValue, fieldName, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
        } else if (fieldValue.getClass().isArray()) {
            OFetchHelper.fetchArray(iRootRecord, iUserObject, iFetchPlan, fieldValue, fieldName, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
        }
    }

    private static void fetchMap(ODocument iRootRecord, Object iUserObject, OFetchPlan iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        Map linked = (Map)fieldValue;
        iContext.onBeforeMap(iRootRecord, fieldName, iUserObject);
        for (Object key : linked.keySet()) {
            Object o = linked.get(key);
            if (o instanceof OIdentifiable) {
                Object r = ((OIdentifiable)o).getRecord();
                if (r == null) continue;
                if (r instanceof ODocument) {
                    ODocument d = (ODocument)r;
                    Integer fieldDepthLevel = parsedRecords.get(d.getIdentity());
                    if (!d.getIdentity().isValid() || fieldDepthLevel != null && fieldDepthLevel == iLevelFromRoot) {
                        OFetchHelper.removeParsedFromMap(parsedRecords, d);
                        iContext.onBeforeDocument(iRootRecord, d, key.toString(), iUserObject);
                        Object userObject = iListener.fetchLinkedMapEntry(iRootRecord, iUserObject, fieldName, key.toString(), d, iContext);
                        OFetchHelper.processRecord(d, userObject, iFetchPlan, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext, "");
                        iContext.onAfterDocument(iRootRecord, d, key.toString(), iUserObject);
                        continue;
                    }
                    iListener.parseLinked(iRootRecord, d, iUserObject, key.toString(), iContext);
                    continue;
                }
                iListener.parseLinked(iRootRecord, (OIdentifiable)r, iUserObject, key.toString(), iContext);
                continue;
            }
            if (o instanceof Map) {
                OFetchHelper.fetchMap(iRootRecord, iUserObject, iFetchPlan, o, key.toString(), iCurrentLevel + 1, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
                continue;
            }
            if (OMultiValue.isMultiValue(o)) {
                OFetchHelper.fetchCollection(iRootRecord, iUserObject, iFetchPlan, o, key.toString(), iCurrentLevel + 1, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
                continue;
            }
            iListener.processStandardField(iRootRecord, o, key.toString(), iContext, iUserObject, "");
        }
        iContext.onAfterMap(iRootRecord, fieldName, iUserObject);
    }

    private static void fetchArray(ODocument iRootRecord, Object iUserObject, OFetchPlan iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        if (fieldValue instanceof ODocument[]) {
            OIdentifiable[] linked = (ODocument[])fieldValue;
            iContext.onBeforeArray(iRootRecord, fieldName, iUserObject, linked);
            for (OIdentifiable d : linked) {
                Integer fieldDepthLevel = parsedRecords.get(((ORecordAbstract)d).getIdentity());
                if (!((ORecordAbstract)d).getIdentity().isValid() || fieldDepthLevel != null && fieldDepthLevel == iLevelFromRoot) {
                    OFetchHelper.removeParsedFromMap(parsedRecords, d);
                    iContext.onBeforeDocument(iRootRecord, (ODocument)d, fieldName, iUserObject);
                    Object userObject = iListener.fetchLinked(iRootRecord, iUserObject, fieldName, (ODocument)d, iContext);
                    OFetchHelper.processRecord((ODocument)d, userObject, iFetchPlan, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext, "");
                    iContext.onAfterDocument(iRootRecord, (ODocument)d, fieldName, iUserObject);
                    continue;
                }
                iListener.parseLinkedCollectionValue(iRootRecord, d, iUserObject, fieldName, iContext);
            }
            iContext.onAfterArray(iRootRecord, fieldName, iUserObject);
        } else {
            iListener.processStandardField(iRootRecord, fieldValue, fieldName, iContext, iUserObject, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetchCollection(ODocument iRootRecord, Object iUserObject, OFetchPlan iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        Iterable<Object> linked;
        if (fieldValue instanceof ODocument) {
            linked = new OMVRBTreeRIDSet().fromDocument((ODocument)fieldValue);
        } else if (fieldValue instanceof Iterable || fieldValue instanceof ORidBag) {
            linked = (Iterable<Object>)fieldValue;
            iContext.onBeforeCollection(iRootRecord, fieldName, iUserObject, linked);
        } else if (fieldValue.getClass().isArray()) {
            linked = OMultiValue.getMultiValueIterable(fieldValue);
            iContext.onBeforeCollection(iRootRecord, fieldName, iUserObject, linked);
        } else if (fieldValue instanceof Map) {
            linked = ((Map)fieldValue).values();
            iContext.onBeforeMap(iRootRecord, fieldName, iUserObject);
        } else {
            throw new IllegalStateException("Unrecognized type: " + fieldValue.getClass());
        }
        Iterator<Object> iter = linked instanceof ORecordLazyMultiValue ? ((ORecordLazyMultiValue)((Object)linked)).rawIterator() : linked.iterator();
        try {
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o == null) continue;
                if (o instanceof OIdentifiable) {
                    OIdentifiable d = (OIdentifiable)o;
                    Integer fieldDepthLevel = parsedRecords.get(d.getIdentity());
                    if (!d.getIdentity().isPersistent() || fieldDepthLevel != null && fieldDepthLevel == iLevelFromRoot) {
                        OFetchHelper.removeParsedFromMap(parsedRecords, d);
                        d = d.getRecord();
                        if (d == null) {
                            iListener.processStandardField(null, d, null, iContext, iUserObject, "");
                            continue;
                        }
                        if (!(d instanceof ODocument)) {
                            iListener.processStandardField(null, d, fieldName, iContext, iUserObject, "");
                            continue;
                        }
                        iContext.onBeforeDocument(iRootRecord, (ODocument)d, fieldName, iUserObject);
                        Object userObject = iListener.fetchLinkedCollectionValue(iRootRecord, iUserObject, fieldName, (ODocument)d, iContext);
                        OFetchHelper.processRecord((ODocument)d, userObject, iFetchPlan, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext, "");
                        iContext.onAfterDocument(iRootRecord, (ODocument)d, fieldName, iUserObject);
                        continue;
                    }
                    iListener.parseLinkedCollectionValue(iRootRecord, d, iUserObject, fieldName, iContext);
                    continue;
                }
                if (o instanceof Map) {
                    OFetchHelper.fetchMap(iRootRecord, iUserObject, iFetchPlan, o, null, iCurrentLevel + 1, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
                    continue;
                }
                if (!OMultiValue.isMultiValue(o)) continue;
                OFetchHelper.fetchCollection(iRootRecord, iUserObject, iFetchPlan, o, null, iCurrentLevel + 1, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
            }
        }
        finally {
            if (fieldValue instanceof Iterable || fieldValue instanceof ORidBag) {
                iContext.onAfterCollection(iRootRecord, fieldName, iUserObject);
            } else if (fieldValue.getClass().isArray()) {
                iContext.onAfterCollection(iRootRecord, fieldName, iUserObject);
            } else if (fieldValue instanceof Map) {
                iContext.onAfterMap(iRootRecord, fieldName, iUserObject);
            }
        }
    }

    private static void fetchDocument(ODocument iRootRecord, Object iUserObject, OFetchPlan iFetchPlan, OIdentifiable fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        if (fieldValue instanceof ORID && !((ORID)fieldValue).isValid()) {
            iContext.onBeforeStandardField(fieldValue, fieldName, iRootRecord);
            iListener.parseLinked(iRootRecord, fieldValue, iUserObject, fieldName, iContext);
            iContext.onAfterStandardField(fieldValue, fieldName, iRootRecord);
            return;
        }
        Integer fieldDepthLevel = parsedRecords.get(fieldValue.getIdentity());
        if (!fieldValue.getIdentity().isValid() || fieldDepthLevel != null && fieldDepthLevel == iLevelFromRoot) {
            OFetchHelper.removeParsedFromMap(parsedRecords, fieldValue);
            ODocument linked = (ODocument)fieldValue.getRecord();
            if (linked == null) {
                return;
            }
            iContext.onBeforeDocument(iRootRecord, linked, fieldName, iUserObject);
            Object userObject = iListener.fetchLinked(iRootRecord, iUserObject, fieldName, linked, iContext);
            OFetchHelper.processRecord(linked, userObject, iFetchPlan, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext, "");
            iContext.onAfterDocument(iRootRecord, linked, fieldName, iUserObject);
        } else {
            iContext.onBeforeStandardField(fieldValue, fieldName, iRootRecord);
            iListener.parseLinked(iRootRecord, fieldValue, iUserObject, fieldName, iContext);
            iContext.onAfterStandardField(fieldValue, fieldName, iRootRecord);
        }
    }

    protected static void removeParsedFromMap(Map<ORID, Integer> parsedRecords, OIdentifiable d) {
        parsedRecords.remove(d.getIdentity());
    }
}

