/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.OHookReplacedRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexRecorder;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class OClassIndexManager
extends ODocumentHookAbstract
implements OOrientStartupListener,
OOrientShutdownListener {
    private volatile ThreadLocal<Deque<TreeMap<OIndex<?>, List<Object>>>> lockedKeys = new ThreadLocal();

    public OClassIndexManager(ODatabaseDocument database) {
        super(database);
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    @Override
    public void onShutdown() {
        this.lockedKeys = null;
    }

    @Override
    public void onStartup() {
        if (this.lockedKeys == null) {
            this.lockedKeys = new ThreadLocal();
        }
    }

    private static void processCompositeIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        String multiValueField = indexDefinition.getMultiValueField();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField == null) {
                Object origValue = indexDefinition.createValue(origValues);
                Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                if (!indexDefinition.isNullValuesIgnored() || origValue != null) {
                    index.remove(origValue, iRecord);
                }
                if (!indexDefinition.isNullValuesIgnored() || newValue != null) {
                    index.put(newValue, iRecord.getIdentity());
                }
            } else {
                OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine == null) {
                    if (dirtyFields.contains(multiValueField)) {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                    } else {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                    }
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                } else if (dirtyFields.size() == 1) {
                    HashMap<OCompositeKey, Integer> keysToAdd = new HashMap<OCompositeKey, Integer>();
                    HashMap<OCompositeKey, Integer> keysToRemove = new HashMap<OCompositeKey, Integer>();
                    for (OMultiValueChangeEvent<Object, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                        indexDefinition.processChangeEvent(changeEvent, keysToAdd, keysToRemove, origValues.toArray());
                    }
                    for (OMultiValueChangeEvent<Object, Object> keyToRemove : keysToRemove.keySet()) {
                        index.remove(keyToRemove, iRecord);
                    }
                    for (OMultiValueChangeEvent<Object, Object> keyToAdd : keysToAdd.keySet()) {
                        index.put(keyToAdd, iRecord.getIdentity());
                    }
                } else {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                }
            }
            return;
        }
    }

    private static void processSingleIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return;
        }
        String indexField = indexFields.get(0);
        if (!dirtyFields.contains(indexField)) {
            return;
        }
        OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
        if (multiValueChangeTimeLine != null) {
            OIndexDefinitionMultiValue indexDefinitionMultiValue = (OIndexDefinitionMultiValue)indexDefinition;
            HashMap<Object, Integer> keysToAdd = new HashMap<Object, Integer>();
            HashMap<Object, Integer> keysToRemove = new HashMap<Object, Integer>();
            for (OMultiValueChangeEvent<Object, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                indexDefinitionMultiValue.processChangeEvent(changeEvent, keysToAdd, keysToRemove);
            }
            for (OMultiValueChangeEvent<Object, Object> keyToRemove : keysToRemove.keySet()) {
                index.remove(keyToRemove, iRecord);
            }
            for (OMultiValueChangeEvent<Object, Object> keyToAdd : keysToAdd.keySet()) {
                index.put(keyToAdd, iRecord.getIdentity());
            }
        } else {
            Object origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
            OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
        }
    }

    private static void processIndexUpdateFieldAssignment(OIndex<?> index, ODocument iRecord, Object origValue, Object newValue) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (origValue instanceof Collection && newValue instanceof Collection) {
            HashSet valuesToRemove = new HashSet((Collection)origValue);
            HashSet valuesToAdd = new HashSet((Collection)newValue);
            valuesToRemove.removeAll((Collection)newValue);
            valuesToAdd.removeAll((Collection)origValue);
            for (Object valueToRemove : valuesToRemove) {
                if (indexDefinition.isNullValuesIgnored() && valueToRemove == null) continue;
                index.remove(valueToRemove, iRecord);
            }
            for (Object valueToAdd : valuesToAdd) {
                if (indexDefinition.isNullValuesIgnored() && valueToAdd == null) continue;
                index.put(valueToAdd, iRecord);
            }
        } else {
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            if (newValue instanceof Collection) {
                for (Object newValueItem : (Collection)newValue) {
                    index.put(newValueItem, iRecord.getIdentity());
                }
            } else if (!indexDefinition.isNullValuesIgnored() || newValue != null) {
                index.put(newValue, iRecord.getIdentity());
            }
        }
    }

    private static boolean processCompositeIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        String multiValueField = indexDefinition.getMultiValueField();
        List<String> indexFields = indexDefinition.getFields();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField != null) {
                OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine != null) {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                } else if (dirtyFields.contains(multiValueField)) {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                } else {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                }
            }
            Object origValue = indexDefinition.createValue(origValues);
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private static void deleteIndexKey(OIndex<?> index, ODocument iRecord, Object origValue) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (origValue instanceof Collection) {
            for (Object valueItem : (Collection)origValue) {
                if (indexDefinition.isNullValuesIgnored() && valueItem == null) continue;
                index.remove(valueItem, iRecord);
            }
        } else if (!indexDefinition.isNullValuesIgnored() || origValue != null) {
            index.remove(origValue, iRecord);
        }
    }

    private static boolean processSingleIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return false;
        }
        String indexField = indexFields.iterator().next();
        if (dirtyFields.contains(indexField)) {
            Object origValue;
            OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
            if (multiValueChangeTimeLine != null) {
                OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(indexField);
                Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                origValue = indexDefinition.createValue(restoredMultiValue);
            } else {
                origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            }
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private ODocument checkIndexedPropertiesOnCreation(ODocument record, Collection<OIndex<?>> indexes) {
        OIndex index;
        ODocument replaced = null;
        Deque<TreeMap<OIndex<?>, List<Object>>> indexKeysMapQueue = this.lockedKeys.get();
        if (indexKeysMapQueue == null) {
            indexKeysMapQueue = new ArrayDeque();
            this.lockedKeys.set(indexKeysMapQueue);
        }
        TreeMap indexKeysMap = new TreeMap();
        for (OIndex<?> oIndex : indexes) {
            if (!(oIndex.getInternal() instanceof OIndexUnique)) continue;
            OIndexRecorder indexRecorder = new OIndexRecorder((OIndexUnique)oIndex.getInternal());
            this.addIndexEntry(record, record.getIdentity(), indexRecorder);
            indexKeysMap.put(oIndex, indexRecorder.getAffectedKeys());
        }
        for (Map.Entry entry : indexKeysMap.entrySet()) {
            index = ((OIndex)entry.getKey()).getInternal();
            index.lockKeysForUpdateNoTx((Collection)entry.getValue());
        }
        indexKeysMapQueue.push(indexKeysMap);
        for (Map.Entry entry : indexKeysMap.entrySet()) {
            index = (OIndex)entry.getKey();
            for (Object keyItem : (List)entry.getValue()) {
                ODocument r = index.checkEntry(record, keyItem);
                if (r == null) continue;
                if (replaced == null) {
                    replaced = r;
                    continue;
                }
                throw new OIndexException("Cannot merge record from multiple indexes. Use this strategy when you have only one index");
            }
        }
        return replaced;
    }

    private void checkIndexedPropertiesOnUpdate(ODocument record, Collection<OIndex<?>> indexes) {
        OIndex index;
        Deque<TreeMap<OIndex<?>, List<Object>>> indexKeysMapQueue = this.lockedKeys.get();
        if (indexKeysMapQueue == null) {
            indexKeysMapQueue = new ArrayDeque();
            this.lockedKeys.set(indexKeysMapQueue);
        }
        TreeMap indexKeysMap = new TreeMap();
        HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(record.getDirtyFields()));
        if (dirtyFields.isEmpty()) {
            return;
        }
        for (OIndex<?> oIndex : indexes) {
            if (!(oIndex.getInternal() instanceof OIndexUnique)) continue;
            OIndexRecorder indexRecorder = new OIndexRecorder(oIndex.getInternal());
            this.processIndexUpdate(record, dirtyFields, indexRecorder);
            indexKeysMap.put(oIndex, indexRecorder.getAffectedKeys());
        }
        for (Map.Entry entry : indexKeysMap.entrySet()) {
            index = ((OIndex)entry.getKey()).getInternal();
            index.lockKeysForUpdateNoTx((Collection)entry.getValue());
        }
        indexKeysMapQueue.push(indexKeysMap);
        for (Map.Entry entry : indexKeysMap.entrySet()) {
            index = (OIndex)entry.getKey();
            for (Object keyItem : (List)entry.getValue()) {
                index.checkEntry(record, keyItem);
            }
        }
    }

    private static ODocument checkForLoading(ODocument iRecord) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                return (ODocument)iRecord.load();
            }
            catch (ORecordNotFoundException e) {
                throw new OIndexException("Error during loading of record with id : " + iRecord.getIdentity(), e);
            }
        }
        return iRecord;
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument document) {
        ODocument replaced = this.checkIndexes(document, ORecordHook.TYPE.BEFORE_CREATE);
        if (replaced != null) {
            OHookReplacedRecordThreadLocal.INSTANCE.set(replaced);
            return ORecordHook.RESULT.RECORD_REPLACED;
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterCreate(ODocument document) {
        document = OClassIndexManager.checkForLoading(document);
        ORID rid = document.getIdentity();
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(document);
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            this.addIndexesEntries(document, indexes);
        }
    }

    @Override
    public void onRecordCreateFailed(ODocument iDocument) {
    }

    @Override
    public void onRecordCreateReplicated(ODocument iDocument) {
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        this.checkIndexes(iDocument, ORecordHook.TYPE.BEFORE_UPDATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterUpdate(ODocument iDocument) {
        HashSet<String> dirtyFields;
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(iDocument = OClassIndexManager.checkForLoading(iDocument));
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        if (!indexes.isEmpty() && !(dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()))).isEmpty()) {
            for (OIndex oIndex : indexes) {
                this.processIndexUpdate(iDocument, dirtyFields, oIndex);
            }
        }
    }

    private void processIndexUpdate(ODocument iDocument, Set<String> dirtyFields, OIndex<?> index) {
        if (index.getDefinition() instanceof OCompositeIndexDefinition) {
            OClassIndexManager.processCompositeIndexUpdate(index, dirtyFields, iDocument);
        } else {
            OClassIndexManager.processSingleIndexUpdate(index, dirtyFields, iDocument);
        }
    }

    @Override
    public void onRecordUpdateFailed(ODocument iDocument) {
    }

    @Override
    public void onRecordUpdateReplicated(ODocument iDocument) {
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        ORecordVersion version = iDocument.getRecordVersion();
        if (iDocument.fields() == 0 && iDocument.getIdentity().isPersistent()) {
            iDocument.reload();
            if (version.getCounter() > -1 && iDocument.getRecordVersion().compareTo(version) != 0) {
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(iDocument.getIdentity(), iDocument.getRecordVersion(), version, 2);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterDelete(ODocument iDocument) {
        this.deleteIndexEntries(iDocument);
    }

    @Override
    public void onRecordDeleteFailed(ODocument iDocument) {
    }

    @Override
    public void onRecordDeleteReplicated(ODocument iDocument) {
    }

    private void addIndexesEntries(ODocument document, Collection<OIndex<?>> indexes) {
        ORID rid = document.getIdentity();
        for (OIndex<?> index : indexes) {
            this.addIndexEntry(document, rid, index);
        }
    }

    private void addIndexEntry(ODocument document, OIdentifiable rid, OIndex<?> index) {
        OIndexDefinition indexDefinition = index.getDefinition();
        Object key = indexDefinition.getDocumentValueToIndex(document);
        if (key instanceof Collection) {
            for (Object keyItem : (Collection)key) {
                if (indexDefinition.isNullValuesIgnored() && keyItem == null) continue;
                index.put(keyItem, rid);
            }
        } else if (!indexDefinition.isNullValuesIgnored() || key != null) {
            try {
                index.put(key, rid);
            }
            catch (ORecordDuplicatedException e) {
                if (!this.database.getTransaction().isActive()) {
                    this.database.delete(document);
                }
                throw e;
            }
        }
    }

    private void deleteIndexEntries(ODocument iDocument) {
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(iDocument);
        if (cls == null) {
            return;
        }
        ArrayList indexes = new ArrayList(cls.getIndexes());
        if (!indexes.isEmpty()) {
            HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()));
            if (!dirtyFields.isEmpty()) {
                Iterator indexIterator = indexes.iterator();
                while (indexIterator.hasNext()) {
                    OIndex oIndex = (OIndex)indexIterator.next();
                    boolean result = oIndex.getDefinition() instanceof OCompositeIndexDefinition ? OClassIndexManager.processCompositeIndexDelete(oIndex, dirtyFields, iDocument) : OClassIndexManager.processSingleIndexDelete(oIndex, dirtyFields, iDocument);
                    if (!result) continue;
                    indexIterator.remove();
                }
            }
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iDocument);
                OClassIndexManager.deleteIndexKey(oIndex, iDocument, key);
            }
        }
    }

    private ODocument checkIndexes(ODocument document, ORecordHook.TYPE hookType) {
        document = OClassIndexManager.checkForLoading(document);
        ODocument replaced = null;
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(document);
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            switch (hookType) {
                case BEFORE_CREATE: {
                    replaced = this.checkIndexedPropertiesOnCreation(document, indexes);
                    break;
                }
                case BEFORE_UPDATE: {
                    this.checkIndexedPropertiesOnUpdate(document, indexes);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid hook type: " + (Object)((Object)hookType));
                }
            }
        }
        return replaced;
    }

    @Override
    public void onRecordFinalizeUpdate(ODocument document) {
        this.unlockKeys();
    }

    @Override
    public void onRecordFinalizeCreation(ODocument document) {
        this.unlockKeys();
    }

    private void unlockKeys() {
        Deque<TreeMap<OIndex<?>, List<Object>>> indexKeysMapQueue = this.lockedKeys.get();
        if (indexKeysMapQueue == null) {
            return;
        }
        TreeMap<OIndex<?>, List<Object>> indexKeyMap = indexKeysMapQueue.poll();
        if (indexKeyMap == null) {
            return;
        }
        for (Map.Entry<OIndex<?>, List<Object>> entry : indexKeyMap.entrySet()) {
            OIndexInternal<?> index = entry.getKey().getInternal();
            try {
                index.releaseKeysForUpdateNoTx((Collection<Object>)entry.getValue());
            }
            catch (RuntimeException e) {
                OLogManager.instance().error((Object)this, "Error during unlock of keys for index %s", (Throwable)e, index.getName());
            }
        }
    }
}

