/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.engine.OHashTableIndexEngine;
import com.orientechnologies.orient.core.index.engine.ORemoteIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OHashIndexFactory
implements OIndexFactory {
    private static final Set<String> TYPES;
    public static final String SBTREE_ALGORITHM = "SBTREE";
    public static final String MVRBTREE_ALGORITHM = "MVRBTREE";
    private static final Set<String> ALGORITHMS;

    @Override
    public Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    @Override
    public OIndexInternal<?> createIndex(String name, ODatabaseDocumentInternal database, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException {
        OHashTableIndexEngine<OIdentifiable> indexEngine;
        if (version < 0) {
            version = this.getLastVersion();
        }
        if (valueContainerAlgorithm == null) {
            valueContainerAlgorithm = "NONE";
        }
        OStorage storage = database.getStorage();
        Object durable = null;
        if (metadata != null) {
            durable = metadata.field("durableInNonTxMode");
        }
        Boolean durableInNonTxMode = durable instanceof Boolean ? (Boolean)durable : null;
        String storageType = storage.getType();
        if (storageType.equals("memory") || storageType.equals("plocal")) {
            indexEngine = new OHashTableIndexEngine(name, durableInNonTxMode, (OAbstractPaginatedStorage)database.getStorage(), version);
        } else if (storageType.equals("distributed")) {
            indexEngine = new OHashTableIndexEngine(name, durableInNonTxMode, (OAbstractPaginatedStorage)database.getStorage().getUnderlying(), version);
        } else if (storageType.equals("remote")) {
            indexEngine = new ORemoteIndexEngine();
        } else {
            throw new OIndexException("Unsupported storage type : " + storageType);
        }
        if (OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexUnique(name, indexType, algorithm, (OIndexEngine<OIdentifiable>)indexEngine, valueContainerAlgorithm, metadata);
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexNotUnique(name, indexType, algorithm, (OIndexEngine<Set<OIdentifiable>>)indexEngine, valueContainerAlgorithm, metadata);
        }
        if (OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexFullText(name, indexType, algorithm, (OIndexEngine<Set<OIdentifiable>>)indexEngine, valueContainerAlgorithm, metadata);
        }
        if (OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexDictionary(name, indexType, algorithm, (OIndexEngine<OIdentifiable>)indexEngine, valueContainerAlgorithm, metadata);
        }
        throw new OConfigurationException("Unsupported type : " + indexType);
    }

    @Override
    public int getLastVersion() {
        return 2;
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add(SBTREE_ALGORITHM);
        algorithms.add(MVRBTREE_ALGORITHM);
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

