/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OImmutableProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OImmutableClass
implements OClass {
    public static final String EDGE_CLASS_NAME = "E";
    public static final String VERTEX_CLASS_NAME = "V";
    private boolean inited = false;
    private final boolean isAbstract;
    private final boolean strictMode;
    private final String name;
    private final String streamAbleName;
    private final Map<String, OProperty> properties;
    private Map<String, OProperty> allPropertiesMap;
    private Collection<OProperty> allProperties;
    private final Class<?> javaClass;
    private final OClusterSelectionStrategy clusterSelection;
    private final int defaultClusterId;
    private final int[] clusterIds;
    private final int[] polymorphicClusterIds;
    private final Collection<String> baseClassesNames;
    private final List<String> superClassesNames;
    private final float overSize;
    private final float classOverSize;
    private final String shortName;
    private final Map<String, String> customFields;
    private final OImmutableSchema schema;
    private final List<OImmutableClass> superClasses;
    private Collection<OImmutableClass> subclasses;
    private boolean restricted;
    private boolean isVertexType;
    private boolean isEdgeType;

    public OImmutableClass(OClass oClass, OImmutableSchema schema) {
        this.isAbstract = oClass.isAbstract();
        this.strictMode = oClass.isStrictMode();
        this.schema = schema;
        this.superClassesNames = oClass.getSuperClassesNames();
        this.superClasses = new ArrayList<OImmutableClass>();
        this.name = oClass.getName();
        this.streamAbleName = oClass.getStreamableName();
        this.clusterSelection = oClass.getClusterSelection();
        this.defaultClusterId = oClass.getDefaultClusterId();
        this.clusterIds = oClass.getClusterIds();
        this.polymorphicClusterIds = oClass.getPolymorphicClusterIds();
        this.baseClassesNames = new ArrayList<String>();
        for (OClass baseClass : oClass.getSubclasses()) {
            this.baseClassesNames.add(baseClass.getName());
        }
        this.overSize = oClass.getOverSize();
        this.classOverSize = oClass.getClassOverSize();
        this.shortName = oClass.getShortName();
        this.javaClass = oClass.getJavaClass();
        this.properties = new HashMap<String, OProperty>();
        for (OProperty p : oClass.declaredProperties()) {
            this.properties.put(p.getName().toLowerCase(), new OImmutableProperty(p, this));
        }
        HashMap<String, String> customFields = new HashMap<String, String>();
        for (String key : oClass.getCustomKeys()) {
            customFields.put(key, oClass.getCustom(key));
        }
        this.customFields = Collections.unmodifiableMap(customFields);
    }

    public void init() {
        if (!this.inited) {
            this.initSuperClasses();
            ArrayList<OProperty> allProperties = new ArrayList<OProperty>();
            HashMap<String, OProperty> allPropsMap = new HashMap<String, OProperty>(20);
            for (int i = this.superClasses.size() - 1; i >= 0; --i) {
                allProperties.addAll(this.superClasses.get((int)i).allProperties);
                allPropsMap.putAll(this.superClasses.get((int)i).allPropertiesMap);
            }
            allProperties.addAll(this.properties.values());
            for (OProperty p : this.properties.values()) {
                String propName = p.getName();
                if (allPropsMap.containsKey(propName)) continue;
                allPropsMap.put(propName, p);
            }
            this.allProperties = Collections.unmodifiableCollection(allProperties);
            this.allPropertiesMap = Collections.unmodifiableMap(allPropsMap);
            this.restricted = this.isSubClassOf("ORestricted");
            this.isVertexType = this.isSubClassOf(VERTEX_CLASS_NAME);
            this.isEdgeType = this.isSubClassOf(EDGE_CLASS_NAME);
            this.inited = true;
        }
    }

    @Override
    public <T> T newInstance() throws InstantiationException, IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public OClass setAbstract(boolean iAbstract) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStrictMode() {
        return this.strictMode;
    }

    @Override
    public OClass setStrictMode(boolean iMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass getSuperClass() {
        this.initSuperClasses();
        return this.superClasses.isEmpty() ? null : this.superClasses.get(0);
    }

    @Override
    public OClass setSuperClass(OClass iSuperClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<OClass> getSuperClasses() {
        return Collections.unmodifiableList(this.superClasses);
    }

    @Override
    public boolean hasSuperClasses() {
        return !this.superClasses.isEmpty();
    }

    @Override
    public List<String> getSuperClassesNames() {
        return this.superClassesNames;
    }

    @Override
    public OClass setSuperClasses(List<? extends OClass> classes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass addSuperClass(OClass superClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass removeSuperClass(OClass superClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OClass setName(String iName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStreamableName() {
        return this.streamAbleName;
    }

    @Override
    public Collection<OProperty> declaredProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    public Collection<OProperty> properties() {
        return this.allProperties;
    }

    @Override
    public Map<String, OProperty> propertiesMap() {
        return this.allPropertiesMap;
    }

    public void getIndexedProperties(Collection<OProperty> indexedProperties) {
        for (OProperty p : this.properties.values()) {
            if (!this.areIndexed(p.getName())) continue;
            indexedProperties.add(p);
        }
        this.initSuperClasses();
        for (OImmutableClass superClass : this.superClasses) {
            superClass.getIndexedProperties(indexedProperties);
        }
    }

    @Override
    public Collection<OProperty> getIndexedProperties() {
        HashSet<OProperty> indexedProps = new HashSet<OProperty>();
        this.getIndexedProperties(indexedProps);
        return indexedProps;
    }

    @Override
    public OProperty getProperty(String propertyName) {
        this.initSuperClasses();
        propertyName = propertyName.toLowerCase();
        OProperty p = this.properties.get(propertyName);
        if (p != null) {
            return p;
        }
        for (int i = 0; i < this.superClasses.size() && p == null; ++i) {
            p = this.superClasses.get(i).getProperty(propertyName);
        }
        return p;
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OType iLinkedType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropProperty(String iPropertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean existsProperty(String propertyName) {
        boolean result = this.properties.containsKey(propertyName = propertyName.toLowerCase());
        if (result) {
            return true;
        }
        for (OImmutableClass superClass : this.superClasses) {
            result = superClass.existsProperty(propertyName);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public int getClusterForNewInstance(ODocument doc) {
        return this.clusterSelection.getCluster(this, doc);
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public void setDefaultClusterId(int iDefaultClusterId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getClusterIds() {
        return this.clusterIds;
    }

    @Override
    public OClass addClusterId(int iId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClusterSelectionStrategy getClusterSelection() {
        return this.clusterSelection;
    }

    @Override
    public OClass setClusterSelection(OClusterSelectionStrategy clusterSelection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass setClusterSelection(String iStrategyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass addCluster(String iClusterName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass removeClusterId(int iId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getPolymorphicClusterIds() {
        return this.polymorphicClusterIds;
    }

    public OImmutableSchema getSchema() {
        return this.schema;
    }

    @Override
    public Collection<OClass> getSubclasses() {
        this.initBaseClasses();
        ArrayList<OClass> result = new ArrayList<OClass>();
        for (OClass oClass : this.subclasses) {
            result.add(oClass);
        }
        return result;
    }

    @Override
    public Collection<OClass> getAllSubclasses() {
        this.initBaseClasses();
        HashSet<OClass> set = new HashSet<OClass>();
        set.addAll(this.getSubclasses());
        for (OImmutableClass c : this.subclasses) {
            set.addAll(c.getAllSubclasses());
        }
        return set;
    }

    @Override
    public Collection<OClass> getBaseClasses() {
        return this.getSubclasses();
    }

    @Override
    public Collection<OClass> getAllBaseClasses() {
        return this.getAllSubclasses();
    }

    @Override
    public Collection<OClass> getAllSuperClasses() {
        HashSet<OClass> ret = new HashSet<OClass>();
        this.getAllSuperClasses(ret);
        return ret;
    }

    private void getAllSuperClasses(Set<OClass> set) {
        set.addAll(this.superClasses);
        for (OImmutableClass superClass : this.superClasses) {
            superClass.getAllSuperClasses(set);
        }
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (int clusterId : this.clusterIds) {
            size += this.getDatabase().getClusterRecordSizeById(clusterId);
        }
        return size;
    }

    @Override
    public float getOverSize() {
        return this.overSize;
    }

    @Override
    public float getClassOverSize() {
        return this.classOverSize;
    }

    @Override
    public OClass setOverSize(float overSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long count() {
        return this.count(true);
    }

    @Override
    public long count(boolean isPolymorphic) {
        if (isPolymorphic) {
            return this.getDatabase().countClusterElements(OClassImpl.readableClusters(this.getDatabase(), this.polymorphicClusterIds));
        }
        return this.getDatabase().countClusterElements(OClassImpl.readableClusters(this.getDatabase(), this.clusterIds));
    }

    @Override
    public void truncate() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSubClassOf(String iClassName) {
        if (iClassName == null) {
            return false;
        }
        if (iClassName.equalsIgnoreCase(this.getName()) || iClassName.equalsIgnoreCase(this.getShortName())) {
            return true;
        }
        int s = this.superClasses.size();
        for (int i = 0; i < s; ++i) {
            if (!this.superClasses.get(i).isSubClassOf(iClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubClassOf(OClass clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.equals(clazz)) {
            return true;
        }
        int s = this.superClasses.size();
        for (int i = 0; i < s; ++i) {
            if (!this.superClasses.get(i).isSubClassOf(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuperClassOf(OClass clazz) {
        return clazz != null && clazz.isSubClassOf(this);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public OClass setShortName(String shortName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(OClass.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case NAME: {
                return this.getName();
            }
            case SHORTNAME: {
                return this.getShortName();
            }
            case SUPERCLASS: {
                return this.getSuperClass();
            }
            case SUPERCLASSES: {
                return this.getSuperClasses();
            }
            case OVERSIZE: {
                return Float.valueOf(this.getOverSize());
            }
            case STRICTMODE: {
                return this.isStrictMode();
            }
            case ABSTRACT: {
                return this.isAbstract();
            }
            case CLUSTERSELECTION: {
                return this.getClusterSelection();
            }
            case CUSTOM: {
                return this.getCustomInternal();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)iAttribute) + "'");
    }

    @Override
    public OClass set(OClass.ATTRIBUTES attribute, Object iValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, String ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, String ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, OProgressListener iProgressListener, String ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OProgressListener iProgressListener, ODocument metadata, String algorithm, String ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OProgressListener iProgressListener, ODocument metadata, String ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(Collection<String> fields) {
        this.initSuperClasses();
        HashSet result = new HashSet(this.getClassInvolvedIndexes(fields));
        for (OImmutableClass superClass : this.superClasses) {
            result.addAll(superClass.getInvolvedIndexes(fields));
        }
        return result;
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(String ... fields) {
        return this.getInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        return indexManager.getClassInvolvedIndexes(this.name, fields);
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String ... fields) {
        return this.getClassInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public boolean areIndexed(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        boolean currentClassResult = indexManager.areIndexed(this.name, fields);
        this.initSuperClasses();
        if (currentClassResult) {
            return true;
        }
        for (OImmutableClass superClass : this.superClasses) {
            if (!superClass.areIndexed(fields)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areIndexed(String ... fields) {
        return this.areIndexed(Arrays.asList(fields));
    }

    @Override
    public OIndex<?> getClassIndex(String iName) {
        return this.getDatabase().getMetadata().getIndexManager().getClassIndex(this.name, this.name);
    }

    @Override
    public Set<OIndex<?>> getClassIndexes() {
        return this.getDatabase().getMetadata().getIndexManager().getClassIndexes(this.name);
    }

    @Override
    public void getClassIndexes(Collection<OIndex<?>> indexes) {
        this.getDatabase().getMetadata().getIndexManager().getClassIndexes(this.name, indexes);
    }

    @Override
    public void getIndexes(Collection<OIndex<?>> indexes) {
        this.initSuperClasses();
        this.getClassIndexes(indexes);
        for (OClass oClass : this.superClasses) {
            oClass.getIndexes(indexes);
        }
    }

    @Override
    public Set<OIndex<?>> getIndexes() {
        HashSet indexes = new HashSet();
        this.getIndexes(indexes);
        return indexes;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!OClass.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        OClass other = (OClass)obj;
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getCustom(String iName) {
        return this.customFields.get(iName);
    }

    @Override
    public OClass setCustom(String iName, String iValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeCustom(String iName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearCustom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getCustomKeys() {
        return Collections.unmodifiableSet(this.customFields.keySet());
    }

    @Override
    public boolean hasClusterId(int clusterId) {
        return Arrays.binarySearch(this.clusterIds, clusterId) >= 0;
    }

    @Override
    public boolean hasPolymorphicClusterId(int clusterId) {
        return Arrays.binarySearch(this.polymorphicClusterIds, clusterId) >= 0;
    }

    @Override
    public int compareTo(OClass other) {
        return this.name.compareTo(other.getName());
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private Map<String, String> getCustomInternal() {
        return this.customFields;
    }

    private void initSuperClasses() {
        if (this.superClassesNames != null && this.superClassesNames.size() != this.superClasses.size()) {
            this.superClasses.clear();
            for (String superClassName : this.superClassesNames) {
                OImmutableClass superClass = (OImmutableClass)this.schema.getClass(superClassName);
                superClass.init();
                this.superClasses.add(superClass);
            }
        }
    }

    private void initBaseClasses() {
        if (this.subclasses == null) {
            ArrayList<OImmutableClass> result = new ArrayList<OImmutableClass>(this.baseClassesNames.size());
            for (String clsName : this.baseClassesNames) {
                result.add((OImmutableClass)this.schema.getClass(clsName));
            }
            this.subclasses = result;
        }
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public boolean isEdgeType() {
        return this.isEdgeType;
    }

    public boolean isVertexType() {
        return this.isVertexType;
    }
}

