/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.live;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryListener;
import com.orientechnologies.orient.core.query.live.OLiveQueryQueueThread;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OLiveQueryHook
extends ODocumentHookAbstract
implements ODatabaseListener {
    protected static Map<ODatabaseDocument, List<ORecordOperation>> pendingOps = new ConcurrentHashMap<ODatabaseDocument, List<ORecordOperation>>();
    static OLiveQueryQueueThread queueThread = new OLiveQueryQueueThread();
    static Object threadLock = new Object();

    public OLiveQueryHook(ODatabaseDocumentTx db) {
        db.registerListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer subscribe(Integer token, OLiveQueryListener iListener) {
        Object object = threadLock;
        synchronized (object) {
            if (!queueThread.isAlive()) {
                queueThread = new OLiveQueryQueueThread();
                queueThread.start();
            }
        }
        return queueThread.subscribe(token, iListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsubscribe(Integer id) {
        try {
            Object object = threadLock;
            synchronized (object) {
                queueThread.unsubscribe(id);
            }
        }
        catch (Exception e) {
            OLogManager.instance().warn(OLiveQueryHook.class, "Error on unsubscribing client", new Object[0]);
        }
    }

    @Override
    public void onCreate(ODatabase iDatabase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(ODatabase iDatabase) {
        Map<ODatabaseDocument, List<ORecordOperation>> map = pendingOps;
        synchronized (map) {
            pendingOps.remove(iDatabase);
        }
    }

    @Override
    public void onOpen(ODatabase iDatabase) {
    }

    @Override
    public void onBeforeTxBegin(ODatabase iDatabase) {
    }

    @Override
    public void onBeforeTxRollback(ODatabase iDatabase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterTxRollback(ODatabase iDatabase) {
        Map<ODatabaseDocument, List<ORecordOperation>> map = pendingOps;
        synchronized (map) {
            pendingOps.remove(iDatabase);
        }
    }

    @Override
    public void onBeforeTxCommit(ODatabase iDatabase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterTxCommit(ODatabase iDatabase) {
        List<ORecordOperation> list;
        Map<ODatabaseDocument, List<ORecordOperation>> map = pendingOps;
        synchronized (map) {
            list = pendingOps.remove(iDatabase);
        }
        if (list != null) {
            for (ORecordOperation item : list) {
                queueThread.enqueue(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(ODatabase iDatabase) {
        Map<ODatabaseDocument, List<ORecordOperation>> map = pendingOps;
        synchronized (map) {
            pendingOps.remove(iDatabase);
        }
    }

    @Override
    public void onBeforeCommand(OCommandRequestText iCommand, OCommandExecutor executor) {
    }

    @Override
    public void onAfterCommand(OCommandRequestText iCommand, OCommandExecutor executor, Object result) {
    }

    @Override
    public void onRecordAfterCreate(ODocument iDocument) {
        this.addOp(iDocument, (byte)3);
    }

    @Override
    public void onRecordAfterUpdate(ODocument iDocument) {
        this.addOp(iDocument, (byte)1);
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        this.addOp(iDocument, (byte)2);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOp(ODocument iDocument, byte iType) {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (db.getTransaction() == null || !db.getTransaction().isActive()) {
            ORecordOperation op = new ORecordOperation(iDocument, iType);
            queueThread.enqueue(op);
            return;
        }
        ORecordOperation result = new ORecordOperation(iDocument, iType);
        Map<ODatabaseDocument, List<ORecordOperation>> map = pendingOps;
        synchronized (map) {
            List<ORecordOperation> list = pendingOps.get(db);
            if (list == null) {
                list = new ArrayList<ORecordOperation>();
                pendingOps.put(db, list);
            }
            list.add(result);
        }
    }

    @Override
    public boolean onCorruptionRepairDatabase(ODatabase iDatabase, String iReason, String iWhatWillbeFixed) {
        return false;
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }
}

