/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record;

import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerRaw;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinary;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ORecordSerializerFactory {
    private static final ORecordSerializerFactory instance = new ORecordSerializerFactory();
    private Map<String, ORecordSerializer> implementations = new HashMap<String, ORecordSerializer>();
    @Deprecated
    private ORecordSerializer defaultRecordFormat = new ORecordSerializerRaw();

    public ORecordSerializerFactory() {
        this.register("ORecordDocument2csv", ORecordSerializerSchemaAware2CSV.INSTANCE);
        this.register("json", ORecordSerializerJSON.INSTANCE);
        this.register("ORecordDocumentRaw", this.defaultRecordFormat);
        this.register("ORecordSerializerBinary", ORecordSerializerBinary.INSTANCE);
    }

    public void register(String iName, ORecordSerializer iInstance) {
        this.implementations.put(iName, iInstance);
    }

    public Collection<ORecordSerializer> getFormats() {
        return this.implementations.values();
    }

    public ORecordSerializer getFormat(String iFormatName) {
        if (iFormatName == null) {
            return null;
        }
        return this.implementations.get(iFormatName);
    }

    @Deprecated
    public ORecordSerializer getFormatForObject(Object iObject, String iFormatName) {
        if (iObject == null) {
            return null;
        }
        ORecordSerializer recordFormat = null;
        if (iFormatName != null) {
            recordFormat = this.implementations.get(iObject.getClass().getSimpleName() + "2" + iFormatName);
        }
        if (recordFormat == null) {
            recordFormat = this.defaultRecordFormat;
        }
        return recordFormat;
    }

    @Deprecated
    public ORecordSerializer getDefaultRecordFormat() {
        return this.defaultRecordFormat;
    }

    @Deprecated
    public void setDefaultRecordFormat(ORecordSerializer iDefaultFormat) {
        this.defaultRecordFormat = iDefaultFormat;
    }

    public static ORecordSerializerFactory instance() {
        return instance;
    }
}

