/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class OSQLFunctionDecimal
extends OSQLFunctionMathAbstract {
    public static final String NAME = "decimal";
    private Object result;

    public OSQLFunctionDecimal() {
        super(NAME, 1, 1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        Object inputValue = iParams[0];
        if (inputValue == null) {
            this.result = null;
        }
        if (inputValue instanceof BigDecimal) {
            this.result = inputValue;
        }
        if (inputValue instanceof BigInteger) {
            this.result = new BigDecimal((BigInteger)inputValue);
        }
        if (inputValue instanceof Integer) {
            this.result = new BigDecimal((Integer)inputValue);
        }
        if (inputValue instanceof Long) {
            this.result = new BigDecimal((Long)inputValue);
        }
        if (inputValue instanceof Number) {
            this.result = new BigDecimal(((Number)inputValue).doubleValue());
        }
        try {
            if (inputValue instanceof String) {
                this.result = new BigDecimal((String)inputValue);
            }
        }
        catch (Exception e) {
            this.result = null;
        }
        return this.getResult();
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    public String getSyntax() {
        return "decimal(<val>)";
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        return null;
    }
}

