/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.List;
import java.util.Map;

public class ODeleteEdgeStatement
extends OStatement {
    private static final Object unset = new Object();
    protected OIdentifier className;
    protected OIdentifier targetClusterName;
    protected ORid rid;
    protected List<ORid> rids;
    protected ORid leftRid;
    protected List<ORid> leftRids;
    protected OSelectStatement leftStatement;
    protected OInputParameter leftParam;
    protected Object leftParamValue = unset;
    protected OIdentifier leftIdentifier;
    protected ORid rightRid;
    protected List<ORid> rightRids;
    protected OSelectStatement rightStatement;
    protected OInputParameter rightParam;
    protected Object rightParamValue = unset;
    protected OIdentifier rightIdentifier;
    protected OWhereClause whereClause;
    protected OLimit limit;
    protected OBatch batch = null;

    public ODeleteEdgeStatement(int id) {
        super(id);
    }

    public ODeleteEdgeStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String toString() {
        boolean first;
        StringBuilder result = new StringBuilder();
        result.append("DELETE EDGE");
        if (this.className != null) {
            result.append(" ");
            result.append(this.className.toString());
            if (this.targetClusterName != null) {
                result.append(" CLUSTER ");
                result.append(this.targetClusterName.toString());
            }
        }
        if (this.rid != null) {
            result.append(" ");
            result.append(this.rid.toString());
        }
        if (this.rids != null) {
            result.append(" [");
            first = true;
            for (ORid rid : this.rids) {
                if (!first) {
                    result.append(", ");
                }
                result.append(rid.toString());
                first = false;
            }
            result.append("]");
        }
        if (this.leftRid != null || this.leftRids != null || this.leftStatement != null || this.leftParam != null || this.leftIdentifier != null) {
            result.append(" FROM ");
            if (this.leftRid != null) {
                result.append(this.leftRid.toString());
            } else if (this.leftRids != null) {
                result.append("[");
                first = true;
                for (ORid rid : this.leftRids) {
                    if (!first) {
                        result.append(", ");
                    }
                    result.append(rid.toString());
                    first = false;
                }
                result.append("]");
            } else if (this.leftStatement != null) {
                result.append("(");
                result.append(this.leftStatement.toString());
                result.append(")");
            } else if (this.leftParam != null) {
                if (this.leftParamValue == unset) {
                    result.append(this.leftParam.toString());
                } else if (this.leftParamValue == null) {
                    result.append("NULL");
                } else if (this.leftParamValue instanceof String) {
                    result.append("\"" + OExpression.encode("" + this.leftParamValue) + "\"");
                } else {
                    result.append(this.leftParamValue.toString());
                }
            } else if (this.leftIdentifier != null) {
                result.append(this.leftIdentifier.toString());
            }
        }
        if (this.rightRid != null || this.rightRids != null || this.rightStatement != null || this.rightParam != null || this.rightIdentifier != null) {
            result.append(" TO ");
            if (this.rightRid != null) {
                result.append(this.rightRid.toString());
            } else if (this.rightRids != null) {
                result.append("[");
                first = true;
                for (ORid rid : this.rightRids) {
                    if (!first) {
                        result.append(", ");
                    }
                    result.append(rid.toString());
                    first = false;
                }
                result.append("]");
            } else if (this.rightStatement != null) {
                result.append("(");
                result.append(this.rightStatement.toString());
                result.append(")");
            } else if (this.rightParam != null) {
                if (this.rightParamValue == unset) {
                    result.append(this.rightParam.toString());
                } else if (this.rightParamValue == null) {
                    result.append("NULL");
                } else if (this.rightParamValue instanceof String) {
                    result.append("\"" + OExpression.encode("" + this.rightParamValue) + "\"");
                } else {
                    result.append(this.rightParamValue.toString());
                }
            } else if (this.rightIdentifier != null) {
                result.append(this.rightIdentifier.toString());
            }
        }
        if (this.whereClause != null) {
            result.append(" WHERE ");
            result.append(this.whereClause.toString());
        }
        if (this.limit != null) {
            result.append(this.limit);
        }
        if (this.batch != null) {
            result.append(this.batch);
        }
        return result.toString();
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        Object val;
        if (this.leftStatement != null) {
            this.leftStatement.replaceParameters(params);
        }
        if (this.leftParam != null && (val = this.leftParam.bindFromInputParams(params)) != this.leftParam) {
            this.leftParamValue = val;
        }
        if (this.rightStatement != null) {
            this.rightStatement.replaceParameters(params);
        }
        if (this.rightParam != null && (val = this.rightParam.bindFromInputParams(params)) != this.rightParam) {
            this.rightParamValue = val;
        }
        if (this.whereClause != null) {
            this.whereClause.replaceParameters(params);
        }
        if (this.limit != null) {
            this.limit.replaceParameters(params);
        }
        if (this.batch != null) {
            this.batch.replaceParameters(params);
        }
    }
}

