/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.util.OPatternConst;
import com.orientechnologies.orient.core.sql.parser.OBaseIdentifier;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OClusterList;
import com.orientechnologies.orient.core.sql.parser.OIndexIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OMetadataIdentifier;
import com.orientechnologies.orient.core.sql.parser.OModifier;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.List;
import java.util.Map;

public class OFromItem
extends SimpleNode {
    protected List<ORid> rids;
    protected OCluster cluster;
    protected OClusterList clusterList;
    protected OIndexIdentifier index;
    protected OMetadataIdentifier metadata;
    protected OStatement statement;
    protected OInputParameter inputParam;
    protected OBaseIdentifier identifier;
    protected OModifier modifier;
    private static final Object UNSET = new Object();
    private Object inputFinalValue = UNSET;

    public OFromItem(int id) {
        super(id);
    }

    public OFromItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String toString(String prefix) {
        if (this.rids != null && this.rids.size() > 0) {
            if (this.rids.size() == 1) {
                return this.rids.get(0).toString();
            }
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            boolean first = true;
            for (ORid rid : this.rids) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(rid.toString());
                first = false;
            }
            builder.append("]");
            return builder.toString();
        }
        if (this.cluster != null) {
            return this.cluster.toString();
        }
        if (this.clusterList != null) {
            return this.clusterList.toString();
        }
        if (this.metadata != null) {
            return this.metadata.toString();
        }
        if (this.statement != null) {
            return "(" + this.statement.toString() + ")";
        }
        if (this.index != null) {
            return this.index.toString();
        }
        if (this.inputParam != null) {
            if (this.inputFinalValue == UNSET) {
                return this.inputParam.toString();
            }
            if (this.inputFinalValue == null) {
                return "NULL";
            }
            if (this.inputFinalValue instanceof String) {
                this.inputFinalValue = OPatternConst.PATTERN_SINGLE_SPACE.matcher((String)this.inputFinalValue).replaceAll("");
            }
            return this.inputFinalValue.toString();
        }
        if (this.identifier != null) {
            StringBuilder result = new StringBuilder();
            result.append(this.identifier.toString());
            if (this.modifier != null) {
                result.append(this.modifier.toString());
            }
            return result.toString();
        }
        return super.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public void replaceParameters(Map<Object, Object> params) {
        Object result;
        if (this.statement != null) {
            this.statement.replaceParameters(params);
        }
        if (this.inputParam != null && this.inputParam != (result = this.inputParam.bindFromInputParams(params))) {
            this.inputFinalValue = result;
        }
        if (this.identifier != null) {
            this.identifier.replaceParameters(params);
        }
        if (this.modifier != null) {
            this.modifier.replaceParameters(params);
        }
    }
}

