/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OFetchPlan;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OGroupBy;
import com.orientechnologies.orient.core.sql.parser.OLetClause;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OOrderBy;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OSkip;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OTimeout;
import com.orientechnologies.orient.core.sql.parser.OUnwind;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OSelectStatement
extends OStatement {
    protected OFromClause target;
    protected OProjection projection;
    protected OWhereClause whereClause;
    protected OGroupBy groupBy;
    protected OOrderBy orderBy;
    protected OUnwind unwind;
    protected OSkip skip;
    protected OLimit limit;
    protected Boolean lockRecord;
    protected OFetchPlan fetchPlan;
    protected OLetClause letClause;
    protected OTimeout timeout;
    protected Boolean parallel;
    protected Boolean noCache;

    public OSelectStatement(int id) {
        super(id);
    }

    public OSelectStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OCommandExecutorSQLAbstract buildExecutor(OCommandRequest iRequest) {
        OSQLSynchQuery<ODocument> request;
        OSelectStatement.getDatabase().checkSecurity(ORule.ResourceGeneric.COMMAND, ORole.PERMISSION_READ, new Object[0]);
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        if (iRequest instanceof OSQLSynchQuery) {
            request = (OSQLSynchQuery)iRequest;
        } else if (iRequest instanceof OSQLAsynchQuery) {
            request = (OSQLAsynchQuery)iRequest;
        } else {
            request = new OSQLSynchQuery<ODocument>(textRequest.getText());
            if (textRequest.getResultListener() != null) {
                request.setResultListener(textRequest.getResultListener());
            }
        }
        OCommandExecutorSQLSelect result = new OCommandExecutorSQLSelect();
        result.setRequest(request);
        result.initContext();
        result.setProjections(new LinkedHashMap<String, Object>());
        result.setProjectionDefinition(new LinkedHashMap<String, String>());
        if (this.projection != null && this.projection.getItems() != null) {
            for (OProjectionItem item : this.projection.getItems()) {
                result.getProjections().put(this.getAlias(item), item.getExpression().createExecutorFilter());
                result.getProjectionDefinition().put(this.getAlias(item), item.toString());
            }
        }
        return result;
    }

    private String getAlias(OProjectionItem item) {
        if (item.getAlias() != null) {
            return item.getAlias();
        }
        return item.getDefaultAlias();
    }

    public OProjection getProjection() {
        return this.projection;
    }

    public void setProjection(OProjection projection) {
        this.projection = projection;
    }

    public OFromClause getTarget() {
        return this.target;
    }

    public void setTarget(OFromClause target) {
        this.target = target;
    }

    public OWhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(OWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    public OGroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(OGroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public OOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public OSkip getSkip() {
        return this.skip;
    }

    public void setSkip(OSkip skip) {
        this.skip = skip;
    }

    public OLimit getLimit() {
        return this.limit;
    }

    public void setLimit(OLimit limit) {
        this.limit = limit;
    }

    public Boolean getLockRecord() {
        return this.lockRecord;
    }

    public void setLockRecord(Boolean lockRecord) {
        this.lockRecord = lockRecord;
    }

    public OFetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(OFetchPlan fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    public OLetClause getLetClause() {
        return this.letClause;
    }

    public void setLetClause(OLetClause letClause) {
        this.letClause = letClause;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        if (this.projection != null) {
            builder.append(" ");
            builder.append(this.projection.toString());
        }
        if (this.target != null) {
            builder.append(" FROM ");
            builder.append(this.target.toString());
        }
        if (this.letClause != null) {
            builder.append(" ");
            builder.append(this.letClause.toString());
        }
        if (this.whereClause != null) {
            builder.append(" WHERE ");
            builder.append(this.whereClause.toString());
        }
        if (this.groupBy != null) {
            builder.append(" ");
            builder.append(this.groupBy.toString());
        }
        if (this.orderBy != null) {
            builder.append(" ");
            builder.append(this.orderBy.toString());
        }
        if (this.unwind != null) {
            builder.append(" ");
            builder.append(this.unwind.toString());
        }
        if (this.skip != null) {
            builder.append(this.skip);
        }
        if (this.limit != null) {
            builder.append(this.limit);
        }
        if (Boolean.TRUE.equals(this.lockRecord)) {
            builder.append(" LOCK RECORD");
        }
        if (this.fetchPlan != null) {
            builder.append(" ");
            builder.append(this.fetchPlan.toString());
        }
        if (this.timeout != null) {
            builder.append(this.timeout);
        }
        if (Boolean.TRUE.equals(this.parallel)) {
            builder.append(" PARALLEL");
        }
        if (Boolean.TRUE.equals(this.noCache)) {
            builder.append(" NOCACHE");
        }
        return builder.toString();
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        if (this.target != null) {
            this.target.replaceParameters(params);
        }
        if (this.projection != null) {
            this.projection.replaceParameters(params);
        }
        if (this.letClause != null) {
            this.letClause.replaceParameters(params);
        }
        if (this.whereClause != null) {
            this.whereClause.replaceParameters(params);
        }
        if (this.groupBy != null) {
            this.groupBy.replaceParameters(params);
        }
        if (this.orderBy != null) {
            this.orderBy.replaceParameters(params);
        }
        if (this.skip != null) {
            this.skip.replaceParameters(params);
        }
        if (this.limit != null) {
            this.limit.replaceParameters(params);
        }
    }

    @Override
    public void validate(OrientSql.ValidationStats stats) throws OCommandSQLParsingException {
        if ((this.target == null || this.target.item == null || this.target.item.cluster != null || this.target.item.clusterList != null || this.target.item.metadata != null || this.target.item.modifier != null || this.target.item.rids.size() > 0 || this.target.item.statement != null || !this.isClassTarget(this.target) && !this.isIndexTarget(this.target)) && stats.luceneCount > 0) {
            throw new OQueryParsingException("LUCENE condition is allowed only when query target is a Class or an Index");
        }
        if (this.whereClause != null && this.whereClause.baseExpression.getNumberOfExternalCalculations() > 1) {
            StringBuilder exceptionText = new StringBuilder();
            exceptionText.append("Incompatible conditions found: \n");
            List<Object> conditions = this.whereClause.baseExpression.getExternalCalculationConditions();
            for (Object condition : conditions) {
                exceptionText.append(condition.toString() + "\n");
            }
            throw new OQueryParsingException(exceptionText.toString());
        }
    }

    private boolean isClassTarget(OFromClause target) {
        return target != null && target.item != null && target.item.identifier != null && target.item.identifier.suffix != null && target.item.identifier.suffix.identifier != null;
    }

    private boolean isIndexTarget(OFromClause target) {
        return target != null && target.item != null && target.item.index != null;
    }
}

