/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local;

import com.orientechnologies.common.concur.lock.ODistributedCounter;
import com.orientechnologies.common.concur.lock.ONewLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.OAllCacheEntriesAreUsedException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.ConcurrentLRUList;
import com.orientechnologies.orient.core.storage.cache.local.LRUList;
import com.orientechnologies.orient.core.storage.cache.local.O2QCacheMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class O2QCache
implements OReadCache,
O2QCacheMXBean {
    public static final int MIN_CACHE_SIZE = 256;
    private static final int MAX_CACHE_OVERFLOW = Runtime.getRuntime().availableProcessors() * 8;
    private final int maxSize;
    private final int K_IN;
    private final int K_OUT;
    private final LRUList am;
    private final LRUList a1out;
    private final LRUList a1in;
    private final int pageSize;
    private final ConcurrentMap<Long, Set<Long>> filePages;
    private final OReadersWriterSpinLock cacheLock = new OReadersWriterSpinLock();
    private final ONewLockManager fileLockManager = new ONewLockManager(true);
    private final ONewLockManager<PageKey> pageLockManager = new ONewLockManager();
    private final ConcurrentMap<PinnedPage, OCacheEntry> pinnedPages = new ConcurrentHashMap<PinnedPage, OCacheEntry>();
    private final AtomicBoolean coldPagesRemovalInProgress = new AtomicBoolean();
    private final ODistributedCounter cacheHitCounter = new ODistributedCounter();
    private final ODistributedCounter cacheQueriesCounter = new ODistributedCounter();
    private final AtomicBoolean mbeanIsRegistered = new AtomicBoolean();
    public static final String MBEAN_NAME = "com.orientechnologies.orient.core.storage.cache.local:type=O2QCacheMXBean";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public O2QCache(long readCacheMaxMemory, int pageSize, boolean checkMinSize) {
        this.cacheLock.acquireWriteLock();
        try {
            this.pageSize = pageSize;
            this.filePages = new ConcurrentHashMap<Long, Set<Long>>();
            int normalizedSize = this.normalizeMemory(readCacheMaxMemory, pageSize);
            if (checkMinSize && normalizedSize < 256) {
                normalizedSize = 256;
            }
            this.maxSize = normalizedSize;
            this.K_IN = this.maxSize >> 2;
            this.K_OUT = this.maxSize >> 1;
            this.am = new ConcurrentLRUList();
            this.a1out = new ConcurrentLRUList();
            this.a1in = new ConcurrentLRUList();
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    LRUList getAm() {
        return this.am;
    }

    LRUList getA1out() {
        return this.a1out;
    }

    LRUList getA1in() {
        return this.a1in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName, OWriteCache writeCache) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            long fileId = writeCache.addFile(fileName);
            Set oldPages = this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
            assert (oldPages == null || oldPages.isEmpty());
            long l = fileId;
            return l;
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long openFile(String fileName, OWriteCache writeCache) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            Long fileId = writeCache.isOpen(fileName);
            if (fileId != null) {
                long l = fileId;
                return l;
            }
            fileId = writeCache.openFile(fileName);
            Set oldPages = this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
            assert (oldPages == null || oldPages.isEmpty());
            long l = fileId;
            return l;
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                if (writeCache.isOpen(fileId)) {
                    return;
                }
                writeCache.openFile(fileId);
                Set oldPages = this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
                assert (oldPages == null || oldPages.isEmpty());
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(String fileName, long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireWriteLock();
        try {
            Long existingFileId = writeCache.isOpen(fileName);
            if (existingFileId != null) {
                if (fileId == existingFileId) {
                    return;
                }
                throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            writeCache.openFile(fileName, fileId);
            Set oldPages = this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
            assert (oldPages == null || oldPages.isEmpty());
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(String fileName, long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireWriteLock();
        try {
            writeCache.addFile(fileName, fileId);
            Set oldPages = this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
            assert (oldPages == null || oldPages.isEmpty());
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pinPage(OCacheEntry cacheEntry) throws IOException {
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(cacheEntry.getFileId());
            try {
                Lock pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(cacheEntry.getFileId(), cacheEntry.getPageIndex()));
                try {
                    this.remove(cacheEntry.getFileId(), cacheEntry.getPageIndex());
                    this.pinnedPages.put(new PinnedPage(cacheEntry.getFileId(), cacheEntry.getPageIndex()), cacheEntry);
                }
                finally {
                    this.pageLockManager.releaseLock(pageLock);
                }
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    @Override
    public OCacheEntry load(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        UpdateCacheResult cacheResult = this.doLoad(fileId, pageIndex, checkPinnedPages, false, writeCache);
        if (cacheResult == null) {
            return null;
        }
        try {
            if (cacheResult.removeColdPages) {
                this.removeColdestPagesIfNeeded();
            }
        }
        catch (RuntimeException e) {
            assert (!cacheResult.cacheEntry.isDirty());
            this.release(cacheResult.cacheEntry, writeCache);
            throw e;
        }
        return cacheResult.cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateCacheResult doLoad(long fileId, long pageIndex, boolean checkPinnedPages, boolean addNewPages, OWriteCache writeCache) throws IOException {
        boolean removeColdPages = false;
        OCacheEntry cacheEntry = null;
        this.cacheQueriesCounter.increment();
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(fileId);
            try {
                Lock pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(fileId, pageIndex));
                try {
                    if (checkPinnedPages) {
                        cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
                    }
                    if (cacheEntry == null) {
                        UpdateCacheResult cacheResult = this.updateCache(fileId, pageIndex, addNewPages, writeCache);
                        if (cacheResult == null) {
                            UpdateCacheResult updateCacheResult = null;
                            return updateCacheResult;
                        }
                        cacheEntry = cacheResult.cacheEntry;
                        removeColdPages = cacheResult.removeColdPages;
                    } else {
                        this.cacheHitCounter.increment();
                    }
                    cacheEntry.incrementUsages();
                }
                finally {
                    this.pageLockManager.releaseLock(pageLock);
                }
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
        return new UpdateCacheResult(removeColdPages, cacheEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry allocateNewPage(long fileId, OWriteCache writeCache) throws IOException {
        UpdateCacheResult cacheResult;
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                long filledUpTo = writeCache.getFilledUpTo(fileId);
                assert (filledUpTo >= 0L);
                cacheResult = this.doLoad(fileId, filledUpTo, false, true, writeCache);
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
        assert (cacheResult != null);
        try {
            if (cacheResult.removeColdPages) {
                this.removeColdestPagesIfNeeded();
            }
        }
        catch (RuntimeException e) {
            assert (!cacheResult.cacheEntry.isDirty());
            this.release(cacheResult.cacheEntry, writeCache);
            throw e;
        }
        return cacheResult.cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(OCacheEntry cacheEntry, OWriteCache writeCache) {
        Future flushFuture = null;
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(cacheEntry.getFileId());
            try {
                Lock pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(cacheEntry.getFileId(), cacheEntry.getPageIndex()));
                try {
                    cacheEntry.decrementUsages();
                    assert (cacheEntry.getUsagesCount() >= 0);
                    if (cacheEntry.getUsagesCount() == 0 && cacheEntry.isDirty()) {
                        flushFuture = writeCache.store(cacheEntry.getFileId(), cacheEntry.getPageIndex(), cacheEntry.getCachePointer());
                        cacheEntry.clearDirty();
                    }
                }
                finally {
                    this.pageLockManager.releaseLock(pageLock);
                }
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
        if (flushFuture != null) {
            try {
                flushFuture.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new OException("File flush was interrupted", e);
            }
            catch (Exception e) {
                throw new OException("File flush was abnormally terminated", e);
            }
        }
    }

    @Override
    public void clear() {
        this.cacheLock.acquireWriteLock();
        try {
            this.clearCacheContent();
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                writeCache.truncateFile(fileId);
                this.clearFile(fileId);
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    private void clearFile(long fileId) {
        Set pageEntries = (Set)this.filePages.get(fileId);
        if (pageEntries == null || pageEntries.isEmpty()) {
            assert (this.get(fileId, 0L, true) == null);
            return;
        }
        for (Long pageIndex : pageEntries) {
            OCacheEntry cacheEntry = this.get(fileId, pageIndex, true);
            if (cacheEntry == null) {
                cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
            }
            if (cacheEntry != null) {
                if (cacheEntry.getUsagesCount() == 0) {
                    OCachePointer cachePointer;
                    cacheEntry = this.remove(fileId, pageIndex);
                    if (cacheEntry == null) {
                        cacheEntry = (OCacheEntry)this.pinnedPages.remove(new PinnedPage(fileId, pageIndex));
                    }
                    if ((cachePointer = cacheEntry.getCachePointer()) == null) continue;
                    cachePointer.decrementReadersReferrer();
                    cacheEntry.clearCachePointer();
                    continue;
                }
                throw new OStorageException("Page with index " + pageIndex + " for file with id " + fileId + " cannot be freed because it is used.");
            }
            throw new OStorageException("Page with index " + pageIndex + " was  not found in cache for file with id " + fileId);
        }
        assert (this.get(fileId, 0L, true) == null);
        pageEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(long fileId, boolean flush, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                writeCache.close(fileId, flush);
                this.clearFile(fileId);
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                this.truncateFile(fileId, writeCache);
                this.filePages.remove(fileId);
                writeCache.deleteFile(fileId);
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStorage(OWriteCache writeCache) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            long[] filesToClear;
            for (long fileId : filesToClear = writeCache.close()) {
                this.clearFile(fileId);
            }
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteStorage(OWriteCache writeCache) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            long[] filesToClear;
            for (long fileId : filesToClear = writeCache.delete()) {
                this.clearFile(fileId);
            }
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    public void registerMBean() {
        if (this.mbeanIsRegistered.compareAndSet(false, true)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(MBEAN_NAME);
                server.registerMBean(this, mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw new OStorageException("Error during registration of read cache MBean.", e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new OStorageException("Error during registration of read cache MBean.", e);
            }
            catch (MBeanRegistrationException e) {
                throw new OStorageException("Error during registration of read cache MBean.", e);
            }
            catch (NotCompliantMBeanException e) {
                throw new OStorageException("Error during registration of read cache MBean.", e);
            }
        }
    }

    public void unregisterMBean() {
        if (this.mbeanIsRegistered.compareAndSet(true, false)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(MBEAN_NAME);
                server.unregisterMBean(mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw new OStorageException("Error during unregistration of read cache MBean.", e);
            }
            catch (InstanceNotFoundException e) {
                throw new OStorageException("Error during unregistration of read cache MBean.", e);
            }
            catch (MBeanRegistrationException e) {
                throw new OStorageException("Error during unregistration of read cache MBean.", e);
            }
        }
    }

    @Override
    public int getA1InSize() {
        return this.a1in.size();
    }

    @Override
    public int getA1OutSize() {
        return this.a1out.size();
    }

    @Override
    public int getAmSize() {
        return this.am.size();
    }

    @Override
    public double getCacheHits() {
        return (double)this.cacheHitCounter.get() * 100.0 / (double)this.cacheQueriesCounter.get();
    }

    @Override
    public void clearCacheStatistics() {
        this.cacheHitCounter.clear();
        this.cacheQueriesCounter.clear();
    }

    private OCacheEntry get(long fileId, long pageIndex, boolean useOutQueue) {
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            assert (this.filePages.get(fileId) != null);
            assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
            return cacheEntry;
        }
        if (useOutQueue && (cacheEntry = this.a1out.get(fileId, pageIndex)) != null) {
            assert (this.filePages.get(fileId) != null);
            assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
            return cacheEntry;
        }
        cacheEntry = this.a1in.get(fileId, pageIndex);
        if (cacheEntry != null) {
            // empty if block
        }
        return cacheEntry;
    }

    private void clearCacheContent() {
        OCachePointer cachePointer;
        for (OCacheEntry cacheEntry : this.am) {
            if (cacheEntry.getUsagesCount() == 0) {
                cachePointer = cacheEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                cacheEntry.clearCachePointer();
                continue;
            }
            throw new OStorageException("Page with index " + cacheEntry.getPageIndex() + " for file id " + cacheEntry.getFileId() + " is used and cannot be removed");
        }
        for (OCacheEntry cacheEntry : this.a1in) {
            if (cacheEntry.getUsagesCount() == 0) {
                cachePointer = cacheEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                cacheEntry.clearCachePointer();
                continue;
            }
            throw new OStorageException("Page with index " + cacheEntry.getPageIndex() + " for file id " + cacheEntry.getFileId() + " is used and cannot be removed");
        }
        this.a1out.clear();
        this.am.clear();
        this.a1in.clear();
        for (Set pages : this.filePages.values()) {
            pages.clear();
        }
        this.clearPinnedPages();
    }

    private void clearPinnedPages() {
        for (OCacheEntry pinnedEntry : this.pinnedPages.values()) {
            if (pinnedEntry.getUsagesCount() == 0) {
                OCachePointer cachePointer = pinnedEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                pinnedEntry.clearCachePointer();
                continue;
            }
            throw new OStorageException("Page with index " + pinnedEntry.getPageIndex() + " for file with id " + pinnedEntry.getFileId() + "cannot be freed because it is used.");
        }
        this.pinnedPages.clear();
    }

    private UpdateCacheResult updateCache(long fileId, long pageIndex, boolean addNewPages, OWriteCache writeCache) throws IOException {
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            assert (this.filePages.get(fileId) != null);
            assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
            this.am.putToMRU(cacheEntry);
            this.cacheHitCounter.increment();
            return new UpdateCacheResult(false, cacheEntry);
        }
        cacheEntry = this.a1out.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            assert (this.filePages.get(fileId) != null);
            assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
            OCachePointer dataPointer = writeCache.load(fileId, pageIndex, false);
            assert (dataPointer != null);
            assert (cacheEntry.getCachePointer() == null);
            assert (!cacheEntry.isDirty());
            cacheEntry.setCachePointer(dataPointer);
            this.am.putToMRU(cacheEntry);
            return new UpdateCacheResult(true, cacheEntry);
        }
        cacheEntry = this.a1in.get(fileId, pageIndex);
        if (cacheEntry != null) {
            assert (this.filePages.get(fileId) != null);
            assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
            this.cacheHitCounter.increment();
            return new UpdateCacheResult(false, cacheEntry);
        }
        OCachePointer dataPointer = writeCache.load(fileId, pageIndex, addNewPages);
        if (dataPointer == null) {
            return null;
        }
        cacheEntry = new OCacheEntry(fileId, pageIndex, dataPointer, false);
        this.a1in.putToMRU(cacheEntry);
        Set pages = (Set)this.filePages.get(fileId);
        if (pages == null) {
            pages = Collections.newSetFromMap(new ConcurrentHashMap());
            Set oldPages = this.filePages.putIfAbsent(fileId, pages);
            if (oldPages != null) {
                pages = oldPages;
            }
        }
        pages.add(pageIndex);
        return new UpdateCacheResult(true, cacheEntry);
    }

    private void removeColdestPagesIfNeeded() throws IOException {
        boolean exclusiveCacheLock;
        if (!this.coldPagesRemovalInProgress.compareAndSet(false, true)) {
            return;
        }
        boolean bl = exclusiveCacheLock = this.am.size() + this.a1in.size() - this.maxSize > MAX_CACHE_OVERFLOW;
        if (exclusiveCacheLock) {
            this.cacheLock.acquireWriteLock();
        } else {
            this.cacheLock.acquireReadLock();
        }
        try {
            if (exclusiveCacheLock) {
                this.removeColdPagesWithCacheLock();
            } else {
                this.removeColdPagesWithoutCacheLock();
            }
        }
        finally {
            if (exclusiveCacheLock) {
                this.cacheLock.releaseWriteLock();
            } else {
                this.cacheLock.releaseReadLock();
            }
            this.coldPagesRemovalInProgress.set(false);
        }
    }

    private void removeColdPagesWithCacheLock() {
        while (this.am.size() + this.a1in.size() > this.maxSize) {
            Set pageEntries;
            OCachePointer cachePointer;
            if (this.a1in.size() > this.K_IN) {
                OCacheEntry removedFromAInEntry = this.a1in.removeLRU();
                if (removedFromAInEntry == null) {
                    throw new OAllCacheEntriesAreUsedException("All records in aIn queue in 2q cache are used!");
                }
                assert (removedFromAInEntry.getUsagesCount() == 0);
                assert (!removedFromAInEntry.isDirty());
                cachePointer = removedFromAInEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                removedFromAInEntry.clearCachePointer();
                this.a1out.putToMRU(removedFromAInEntry);
                while (this.a1out.size() > this.K_OUT) {
                    OCacheEntry removedEntry = this.a1out.removeLRU();
                    assert (removedEntry.getUsagesCount() == 0);
                    assert (removedEntry.getCachePointer() == null);
                    assert (!removedEntry.isDirty());
                    pageEntries = (Set)this.filePages.get(removedEntry.getFileId());
                    pageEntries.remove(removedEntry.getPageIndex());
                }
                continue;
            }
            OCacheEntry removedEntry = this.am.removeLRU();
            if (removedEntry == null) {
                throw new OAllCacheEntriesAreUsedException("All records in aIn queue in 2q cache are used!");
            }
            assert (removedEntry.getUsagesCount() == 0);
            assert (!removedEntry.isDirty());
            cachePointer = removedEntry.getCachePointer();
            cachePointer.decrementReadersReferrer();
            removedEntry.clearCachePointer();
            pageEntries = (Set)this.filePages.get(removedEntry.getFileId());
            pageEntries.remove(removedEntry.getPageIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeColdPagesWithoutCacheLock() {
        int iterationsCounter = 0;
        while (this.am.size() + this.a1in.size() > this.maxSize && iterationsCounter < 1000) {
            Set pageEntries;
            OCachePointer cachePointer;
            Lock pageLock;
            Lock fileLock;
            ++iterationsCounter;
            if (this.a1in.size() > this.K_IN) {
                OCacheEntry removedFromAInEntry = this.a1in.getLRU();
                if (removedFromAInEntry == null) {
                    throw new OAllCacheEntriesAreUsedException("All records in aIn queue in 2q cache are used!");
                }
                fileLock = this.fileLockManager.acquireSharedLock(removedFromAInEntry.getFileId());
                try {
                    pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(removedFromAInEntry.getFileId(), removedFromAInEntry.getPageIndex()));
                    try {
                        if (this.a1in.get(removedFromAInEntry.getFileId(), removedFromAInEntry.getPageIndex()) == null || removedFromAInEntry.getUsagesCount() > 0) continue;
                        assert (!removedFromAInEntry.isDirty());
                        this.a1in.remove(removedFromAInEntry.getFileId(), removedFromAInEntry.getPageIndex());
                        cachePointer = removedFromAInEntry.getCachePointer();
                        cachePointer.decrementReadersReferrer();
                        removedFromAInEntry.clearCachePointer();
                        this.a1out.putToMRU(removedFromAInEntry);
                    }
                    finally {
                        this.pageLockManager.releaseLock(pageLock);
                        continue;
                    }
                }
                finally {
                    this.fileLockManager.releaseLock(fileLock);
                    continue;
                }
                while (this.a1out.size() > this.K_OUT) {
                    OCacheEntry removedEntry = this.a1out.getLRU();
                    fileLock = this.fileLockManager.acquireSharedLock(removedEntry.getFileId());
                    try {
                        pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(removedEntry.getFileId(), removedEntry.getPageIndex()));
                        try {
                            if (this.a1out.remove(removedEntry.getFileId(), removedEntry.getPageIndex()) == null) continue;
                            assert (removedEntry.getUsagesCount() == 0);
                            assert (removedEntry.getCachePointer() == null);
                            assert (!removedEntry.isDirty());
                            pageEntries = (Set)this.filePages.get(removedEntry.getFileId());
                            pageEntries.remove(removedEntry.getPageIndex());
                        }
                        finally {
                            this.pageLockManager.releaseLock(pageLock);
                        }
                    }
                    finally {
                        this.fileLockManager.releaseLock(fileLock);
                    }
                }
                continue;
            }
            OCacheEntry removedEntry = this.am.getLRU();
            if (removedEntry == null) {
                throw new OAllCacheEntriesAreUsedException("All records in aIn queue in 2q cache are used!");
            }
            fileLock = this.fileLockManager.acquireSharedLock(removedEntry.getFileId());
            try {
                pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(removedEntry.getFileId(), removedEntry.getPageIndex()));
                try {
                    if (this.am.get(removedEntry.getFileId(), removedEntry.getPageIndex()) == null || removedEntry.getUsagesCount() > 0) continue;
                    assert (!removedEntry.isDirty());
                    this.am.remove(removedEntry.getFileId(), removedEntry.getPageIndex());
                    cachePointer = removedEntry.getCachePointer();
                    cachePointer.decrementReadersReferrer();
                    removedEntry.clearCachePointer();
                    pageEntries = (Set)this.filePages.get(removedEntry.getFileId());
                    pageEntries.remove(removedEntry.getPageIndex());
                }
                finally {
                    this.pageLockManager.releaseLock(pageLock);
                }
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
    }

    int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public long getUsedMemory() {
        return (long)(this.am.size() + this.a1in.size()) * (long)(16 + this.pageSize);
    }

    @Override
    public long getUsedMemoryInMB() {
        return this.getUsedMemory() / 0x100000L;
    }

    @Override
    public double getUsedMemoryInGB() {
        return Math.ceil((double)(this.getUsedMemory() * 100L) / 1.073741824E9) / 100.0;
    }

    private OCacheEntry remove(long fileId, long pageIndex) {
        OCacheEntry cacheEntry = this.am.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            if (cacheEntry.getUsagesCount() > 1) {
                throw new IllegalStateException("Record cannot be removed because it is used!");
            }
            return cacheEntry;
        }
        cacheEntry = this.a1out.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        cacheEntry = this.a1in.remove(fileId, pageIndex);
        if (cacheEntry != null && cacheEntry.getUsagesCount() > 1) {
            throw new IllegalStateException("Record cannot be removed because it is used!");
        }
        return cacheEntry;
    }

    private int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)(pageSize + 16);
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    private static final class UpdateCacheResult {
        private final boolean removeColdPages;
        private final OCacheEntry cacheEntry;

        private UpdateCacheResult(boolean removeColdPages, OCacheEntry cacheEntry) {
            this.removeColdPages = removeColdPages;
            this.cacheEntry = cacheEntry;
        }
    }

    private static final class PageKey {
        private final long fileId;
        private final long pageIndex;

        private PageKey(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (this.fileId != pageKey.fileId) {
                return false;
            }
            return this.pageIndex == pageKey.pageIndex;
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }
    }

    private static class PinnedPage
    implements Comparable<PinnedPage> {
        private final long fileId;
        private final long pageIndex;

        private PinnedPage(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PinnedPage that = (PinnedPage)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.pageIndex == that.pageIndex;
        }

        public String toString() {
            return "PinnedPage{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        @Override
        public int compareTo(PinnedPage other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.pageIndex > other.pageIndex) {
                return 1;
            }
            if (this.pageIndex < other.pageIndex) {
                return -1;
            }
            return 0;
        }
    }
}

