/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.compression.impl.OZIPCompressionUtil;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.local.OWOWCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageVariableParser;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedStorageDirtyFlag;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODiskWriteAheadLog;
import com.orientechnologies.orient.core.util.OBackupable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class OLocalPaginatedStorage
extends OAbstractPaginatedStorage
implements OFreezableStorage,
OBackupable {
    private static String[] ALL_FILE_EXTENSIONS = new String[]{".ocf", ".pls", ".pcl", ".oda", ".odh", ".otx", ".ocs", ".oef", ".oem", ".oet", ".wal", ".wmr", ".hib", ".him", ".hit", ".hnb", ".cpm", ".sbt", ".cm", ".irs", ".sbc", ".nbt"};
    private static final int ONE_KB = 1024;
    private final int DELETE_MAX_RETRIES;
    private final int DELETE_WAIT_TIME;
    private final OStorageVariableParser variableParser;
    private final OPaginatedStorageDirtyFlag dirtyFlag;
    private final String storagePath;
    private ExecutorService checkpointExecutor;

    public OLocalPaginatedStorage(String name, String filePath, String mode, int id, OReadCache readCache) throws IOException {
        super(name, filePath, mode, id);
        this.readCache = readCache;
        File f = new File(this.url);
        String sp = f.exists() || !OLocalPaginatedStorage.exists(f.getParent()) ? OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getPath())) : OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getParent()));
        this.storagePath = OIOUtils.getPathFromDatabaseName(sp);
        this.variableParser = new OStorageVariableParser(this.storagePath);
        this.configuration = new OStorageConfigurationSegment(this);
        this.DELETE_MAX_RETRIES = OGlobalConfiguration.FILE_DELETE_RETRY.getValueAsInteger();
        this.DELETE_WAIT_TIME = OGlobalConfiguration.FILE_DELETE_DELAY.getValueAsInteger();
        this.dirtyFlag = new OPaginatedStorageDirtyFlag(this.storagePath + File.separator + "dirty.fl");
    }

    @Override
    public void create(Map<String, Object> iProperties) {
        File storageFolder = new File(this.storagePath);
        if (!storageFolder.exists()) {
            storageFolder.mkdirs();
        }
        super.create(iProperties);
    }

    @Override
    public boolean exists() {
        if (this.status == OStorage.STATUS.OPEN) {
            return true;
        }
        return OLocalPaginatedStorage.exists(this.storagePath);
    }

    @Override
    public String getURL() {
        return "plocal:" + this.url;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public OStorageVariableParser getVariableParser() {
        return this.variableParser;
    }

    @Override
    public String getType() {
        return "plocal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iOutput, int compressionLevel, int bufferSize) throws IOException {
        this.freeze(false);
        try {
            List<String> list;
            block10: {
                if (callable != null) {
                    try {
                        callable.call();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on callback invocation during backup", (Throwable)e, new Object[0]);
                    }
                }
                OutputStream bo = bufferSize > 0 ? new BufferedOutputStream(out, bufferSize) : out;
                try {
                    list = OZIPCompressionUtil.compressDirectory(new File(this.getStoragePath()).getAbsolutePath(), bo, new String[]{".wal"}, iOutput, compressionLevel);
                    if (bufferSize <= 0) break block10;
                }
                catch (Throwable throwable) {
                    if (bufferSize > 0) {
                        bo.flush();
                        bo.close();
                    }
                    throw throwable;
                }
                bo.flush();
                bo.close();
            }
            return list;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        if (!this.isClosed()) {
            this.close(true, false);
        }
        OZIPCompressionUtil.uncompressDirectory(in, this.getStoragePath(), iListener);
    }

    @Override
    protected void preOpenSteps() throws IOException {
        if (this.configuration.binaryFormatVersion >= 11) {
            if (this.dirtyFlag.exists()) {
                this.dirtyFlag.open();
            } else {
                this.dirtyFlag.create();
                this.dirtyFlag.makeDirty();
            }
        } else if (this.dirtyFlag.exists()) {
            this.dirtyFlag.open();
        } else {
            this.dirtyFlag.create();
            this.dirtyFlag.clearDirty();
        }
    }

    @Override
    protected void preCreateSteps() throws IOException {
        this.dirtyFlag.create();
    }

    @Override
    protected void postCloseSteps(boolean onDelete) throws IOException {
        if (onDelete) {
            this.dirtyFlag.delete();
        } else {
            this.dirtyFlag.clearDirty();
            this.dirtyFlag.close();
        }
    }

    @Override
    protected void preCloseSteps() throws IOException {
        try {
            ((OWOWCache)this.writeCache).unregisterMBean();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "MBean for write cache cannot unregistered", (Throwable)e, new Object[0]);
        }
        try {
            if (this.writeAheadLog != null) {
                this.checkpointExecutor.shutdown();
                if (!this.checkpointExecutor.awaitTermination(OGlobalConfiguration.WAL_FULL_CHECKPOINT_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.SECONDS)) {
                    throw new OStorageException("Cannot terminate full checkpoint task");
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OStorageException("Error on closing of storage '" + this.name, e);
        }
    }

    @Override
    protected void postDeleteSteps() {
        File dbDir = new File(OIOUtils.getPathFromDatabaseName(OSystemVariableResolver.resolveSystemVariables(this.url)));
        if (!dbDir.exists() || !dbDir.isDirectory()) {
            dbDir = dbDir.getParentFile();
        }
        for (int i = 0; i < this.DELETE_MAX_RETRIES; ++i) {
            if (dbDir != null && dbDir.exists() && dbDir.isDirectory()) {
                int notDeletedFiles = 0;
                block1: for (File f : dbDir.listFiles()) {
                    for (String ext : ALL_FILE_EXTENSIONS) {
                        if (!f.getPath().endsWith(ext)) continue;
                        if (f.delete()) continue block1;
                        ++notDeletedFiles;
                        continue block1;
                    }
                }
                if (notDeletedFiles == 0) {
                    dbDir.delete();
                    return;
                }
            } else {
                return;
            }
            OLogManager.instance().debug((Object)this, "Cannot delete database files because they are still locked by the OrientDB process: waiting %d ms and retrying %d/%d...", this.DELETE_WAIT_TIME, i, this.DELETE_MAX_RETRIES);
        }
        throw new OStorageException("Cannot delete database '" + this.name + "' located in: " + dbDir + ". Database files seem locked");
    }

    @Override
    protected void makeStorageDirty() throws IOException {
        this.dirtyFlag.makeDirty();
    }

    @Override
    protected void clearStorageDirty() throws IOException {
        this.dirtyFlag.clearDirty();
    }

    @Override
    protected boolean isDirty() throws IOException {
        return this.dirtyFlag.isDirty();
    }

    @Override
    protected void initWalAndDiskCache() throws IOException {
        if (this.configuration.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.USE_WAL)) {
            this.checkpointExecutor = Executors.newSingleThreadExecutor(new FullCheckpointThreadFactory());
            this.writeAheadLog = new ODiskWriteAheadLog(this);
            this.writeAheadLog.addFullCheckpointListener(this);
        } else {
            this.writeAheadLog = null;
        }
        long diskCacheSize = OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L;
        long writeCacheSize = (long)Math.floor((double)OGlobalConfiguration.DISK_WRITE_CACHE_PART.getValueAsInteger() / 100.0 * (double)diskCacheSize);
        OWOWCache wowCache = new OWOWCache(false, OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024, OGlobalConfiguration.DISK_WRITE_CACHE_PAGE_TTL.getValueAsLong() * 1000L, this.writeAheadLog, OGlobalConfiguration.DISK_WRITE_CACHE_PAGE_FLUSH_INTERVAL.getValueAsInteger(), writeCacheSize, diskCacheSize, this, true, this.getId());
        wowCache.addLowDiskSpaceListener(this);
        try {
            wowCache.registerMBean();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "MBean for write cache cannot be registered.", new Object[0]);
        }
        this.writeCache = wowCache;
    }

    public static boolean exists(String path) {
        return new File(path + "/" + "internal" + ".pcl").exists();
    }

    private static class FullCheckpointThreadFactory
    implements ThreadFactory {
        private FullCheckpointThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    }
}

