/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.batch;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class OGraphBatchInsertBasic {
    private final String userName;
    private final String dbUrl;
    private final String password;
    Map<Long, List<Long>> out = new HashMap<Long, List<Long>>();
    Map<Long, List<Long>> in = new HashMap<Long, List<Long>>();
    private String idPropertyName = "uid";
    private String edgeClass = "E";
    private String vertexClass = "V";
    private ODatabaseDocumentTx db;
    private int averageEdgeNumberPerNode = -1;
    private int estimatedEntries = -1;
    private int bonsaiThreshold = 1000;
    private int[] clusterIds;
    private long[] lastClusterPositions;
    private long last = 0L;
    private boolean walActive;
    private int parallel = 4;
    private AtomicInteger runningThreads;

    public OGraphBatchInsertBasic(String iDbURL) {
        this.dbUrl = iDbURL;
        this.userName = "admin";
        this.password = "admin";
    }

    public OGraphBatchInsertBasic(String iDbURL, String iUserName, String iPassword) {
        this.dbUrl = iDbURL;
        this.userName = iUserName;
        this.password = iPassword;
    }

    public void begin() {
        this.walActive = OGlobalConfiguration.USE_WAL.getValueAsBoolean();
        if (this.walActive) {
            OGlobalConfiguration.USE_WAL.setValue(false);
        }
        if (this.averageEdgeNumberPerNode > 0) {
            OGlobalConfiguration.RID_BAG_EMBEDDED_DEFAULT_SIZE.setValue(this.averageEdgeNumberPerNode);
            OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue(this.bonsaiThreshold);
        }
        this.db = new ODatabaseDocumentTx(this.dbUrl);
        if (this.db.exists()) {
            this.db.open(this.userName, this.password);
        } else {
            this.db.create();
        }
        this.createBaseSchema();
        this.out = this.estimatedEntries > 0 ? new HashMap(this.estimatedEntries) : new HashMap();
        this.in = this.estimatedEntries > 0 ? new HashMap(this.estimatedEntries) : new HashMap();
        OClass vClass = this.db.getMetadata().getSchema().getClass(this.vertexClass);
        int[] existingClusters = vClass.getClusterIds();
        for (int c = existingClusters.length; c <= this.parallel; ++c) {
            vClass.addCluster(vClass.getName() + "_" + c);
        }
        this.clusterIds = vClass.getClusterIds();
        this.lastClusterPositions = new long[this.clusterIds.length];
        for (int i = 0; i < this.clusterIds.length; ++i) {
            int clusterId = this.clusterIds[i];
            try {
                this.lastClusterPositions[i] = this.db.getStorage().getClusterById(clusterId).getLastPosition();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        block11: {
            OClass vClass = this.db.getMetadata().getSchema().getClass(this.vertexClass);
            try {
                this.runningThreads = new AtomicInteger(this.parallel);
                for (int i = 0; i < this.parallel - 1; ++i) {
                    BatchImporterJob t = new BatchImporterJob(i, vClass);
                    t.start();
                }
                BatchImporterJob t = new BatchImporterJob(this.parallel - 1, vClass);
                ((Thread)t).run();
                if (this.runningThreads.get() <= 0) break block11;
                AtomicInteger atomicInteger = this.runningThreads;
                synchronized (atomicInteger) {
                    while (this.runningThreads.get() > 0) {
                        try {
                            this.runningThreads.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
            }
            finally {
                this.db.activateOnCurrentThread();
                this.db.declareIntent(null);
                this.db.close();
                if (this.walActive) {
                    OGlobalConfiguration.USE_WAL.setValue(true);
                }
            }
        }
    }

    public void createVertex(Long v) {
        this.last = this.last < v ? v : this.last;
        List<Long> outList = this.out.get(v);
        if (outList == null) {
            this.out.put(v, new ArrayList(this.averageEdgeNumberPerNode <= 0 ? 4 : this.averageEdgeNumberPerNode));
        }
    }

    public void createEdge(Long from, Long to) {
        if (from < 0L) {
            throw new IllegalArgumentException(" Invalid vertex id: " + from);
        }
        if (to < 0L) {
            throw new IllegalArgumentException(" Invalid vertex id: " + to);
        }
        this.last = this.last < from ? from : this.last;
        this.last = this.last < to ? to : this.last;
        this.putInList(from, this.out, to);
        this.putInList(to, this.in, from);
    }

    public int getAverageEdgeNumberPerNode() {
        return this.averageEdgeNumberPerNode;
    }

    public void setAverageEdgeNumberPerNode(int averageEdgeNumberPerNode) {
        this.averageEdgeNumberPerNode = averageEdgeNumberPerNode;
    }

    public String getIdPropertyName() {
        return this.idPropertyName;
    }

    public void setIdPropertyName(String idPropertyName) {
        this.idPropertyName = idPropertyName;
    }

    public String getEdgeClass() {
        return this.edgeClass;
    }

    public void setEdgeClass(String edgeClass) {
        this.edgeClass = edgeClass;
    }

    public String getVertexClass() {
        return this.vertexClass;
    }

    public void setVertexClass(String vertexClass) {
        this.vertexClass = vertexClass;
    }

    public int getBonsaiThreshold() {
        return this.bonsaiThreshold;
    }

    public void setBonsaiThreshold(int bonsaiThreshold) {
        this.bonsaiThreshold = bonsaiThreshold;
    }

    public int getEstimatedEntries() {
        return this.estimatedEntries;
    }

    public void setEstimatedEntries(int estimatedEntries) {
        this.estimatedEntries = estimatedEntries;
    }

    public int getParallel() {
        return this.parallel;
    }

    public void setParallel(int parallel) {
        this.parallel = parallel;
    }

    private void putInList(Long key, Map<Long, List<Long>> out, Long value) {
        List<Long> list = out.get(key);
        if (list == null) {
            list = new ArrayList<Long>(this.averageEdgeNumberPerNode <= 0 ? 4 : this.averageEdgeNumberPerNode);
            out.put(key, list);
        }
        list.add(value);
    }

    private void createBaseSchema() {
        OSchemaProxy schema = this.db.getMetadata().getSchema();
        OClass v = !schema.existsClass("V") ? schema.createClass("V") : schema.getClass("V");
        OClass e = !schema.existsClass("E") ? schema.createClass("E") : schema.getClass("E");
        if (!"V".equals(this.vertexClass) && !schema.existsClass(this.vertexClass)) {
            schema.createClass(this.vertexClass, v);
        }
        if (!schema.existsClass(this.edgeClass) && !schema.existsClass(this.edgeClass)) {
            schema.createClass(this.edgeClass, e);
        }
    }

    private long getClusterPosition(long uid) {
        return this.lastClusterPositions[(int)(uid % (long)this.parallel)] + uid / (long)this.parallel + 1L;
    }

    private int getClusterId(long left) {
        return this.clusterIds[(int)(left % (long)this.parallel)];
    }

    class BatchImporterJob
    extends Thread {
        private final int mod;
        OClass vClass;

        BatchImporterJob(int mod, OClass vertexClass) {
            this.mod = mod;
            this.vClass = vertexClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ODatabaseDocumentTx db = new ODatabaseDocumentTx(OGraphBatchInsertBasic.this.dbUrl);
                db.open(OGraphBatchInsertBasic.this.userName, OGraphBatchInsertBasic.this.password);
                db.declareIntent(new OIntentMassiveInsert());
                int clusterId = OGraphBatchInsertBasic.this.clusterIds[this.mod];
                String outField = "E".equals(OGraphBatchInsertBasic.this.edgeClass) ? "out_" : "out_" + OGraphBatchInsertBasic.this.edgeClass;
                String inField = "E".equals(OGraphBatchInsertBasic.this.edgeClass) ? "in_" : "in_" + OGraphBatchInsertBasic.this.edgeClass;
                String clusterName = db.getStorage().getClusterById(clusterId).getName();
                for (long i = (long)this.mod; i <= OGraphBatchInsertBasic.this.last; i += (long)OGraphBatchInsertBasic.this.parallel) {
                    ORecordId rid;
                    List<Long> outIds = OGraphBatchInsertBasic.this.out.get(i);
                    List<Long> inIds = OGraphBatchInsertBasic.this.in.get(i);
                    ODocument doc = new ODocument(this.vClass);
                    if (outIds == null && inIds == null) {
                        db.save(doc, clusterName).delete();
                        continue;
                    }
                    doc.field(OGraphBatchInsertBasic.this.idPropertyName, i);
                    if (outIds != null) {
                        ORidBag outBag = new ORidBag();
                        for (Long l : outIds) {
                            rid = new ORecordId(OGraphBatchInsertBasic.this.getClusterId(l), OGraphBatchInsertBasic.this.getClusterPosition(l));
                            outBag.add(rid);
                        }
                        doc.field(outField, outBag);
                    }
                    if (inIds != null) {
                        ORidBag inBag = new ORidBag();
                        for (Long l : inIds) {
                            rid = new ORecordId(OGraphBatchInsertBasic.this.getClusterId(l), OGraphBatchInsertBasic.this.getClusterPosition(l));
                            inBag.add(rid);
                        }
                        doc.field(inField, inBag);
                    }
                    db.save(doc, clusterName);
                }
            }
            finally {
                OGraphBatchInsertBasic.this.runningThreads.decrementAndGet();
                AtomicInteger atomicInteger = OGraphBatchInsertBasic.this.runningThreads;
                synchronized (atomicInteger) {
                    OGraphBatchInsertBasic.this.runningThreads.notifyAll();
                }
                OGraphBatchInsertBasic.this.db.activateOnCurrentThread();
                OGraphBatchInsertBasic.this.db.declareIntent(null);
                OGraphBatchInsertBasic.this.db.close();
            }
        }
    }
}

