/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODistributedDatabaseChunk
implements Externalizable {
    public long lastOperationId;
    public String filePath;
    public long offset;
    public byte[] buffer;
    public boolean last;

    public ODistributedDatabaseChunk() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODistributedDatabaseChunk(long iLastOperationId, File iFile, long iOffset, int iMaxSize) throws IOException {
        this.lastOperationId = iLastOperationId;
        this.filePath = iFile.getAbsolutePath();
        this.offset = iOffset;
        long fileSize = iFile.length();
        File completedFile = new File(iFile.getAbsolutePath() + ".completed");
        int retry = 0;
        while (fileSize <= iOffset) {
            if (fileSize == 0L || iOffset > fileSize) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            fileSize = iFile.length();
            if (completedFile.exists()) break;
            ++retry;
        }
        FileInputStream in = new FileInputStream(iFile);
        int toRead = (int)Math.min((long)iMaxSize, fileSize - this.offset);
        this.buffer = new byte[toRead];
        try {
            in.skip(this.offset);
            in.read(this.buffer);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        fileSize = iFile.length();
        if (completedFile.exists() && fileSize - (this.offset + (long)toRead) == 0L) {
            this.last = true;
        }
    }

    public String toString() {
        return this.filePath + "[" + this.offset + "-" + this.buffer.length + "] (last=" + this.last + ")";
    }

    public long getLastOperationId() {
        return this.lastOperationId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.lastOperationId);
        out.writeUTF(this.filePath);
        out.writeLong(this.offset);
        out.writeInt(this.buffer.length);
        out.write(this.buffer);
        out.writeBoolean(this.last);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lastOperationId = in.readLong();
        this.filePath = in.readUTF();
        this.offset = in.readLong();
        int size = in.readInt();
        this.buffer = new byte[size];
        in.readFully(this.buffer);
        this.last = in.readBoolean();
    }
}

