/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.IntegerType;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;

public interface WinDef
extends StdCallLibrary {
    public static final int MAX_PATH = 260;

    public static class CHARByReference
    extends ByReference {
        public CHARByReference() {
            this(new CHAR(0L));
        }

        public CHARByReference(CHAR value) {
            super(1);
            this.setValue(value);
        }

        public void setValue(CHAR value) {
            this.getPointer().setByte(0L, value.byteValue());
        }

        public CHAR getValue() {
            return new CHAR((long)this.getPointer().getChar(0L));
        }
    }

    public static class CHAR
    extends IntegerType {
        public static final int SIZE = 1;

        public CHAR() {
            this(0L);
        }

        public CHAR(long value) {
            super(1, value, false);
        }
    }

    public static class BYTE
    extends UCHAR {
        public BYTE() {
            this(0L);
        }

        public BYTE(long value) {
            super(value);
        }
    }

    public static class UCHAR
    extends IntegerType {
        public static final int SIZE = 1;

        public UCHAR() {
            this(0L);
        }

        public UCHAR(long value) {
            super(1, value, true);
        }
    }

    public static class BOOLByReference
    extends ByReference {
        public BOOLByReference() {
            this(new BOOL(0L));
        }

        public BOOLByReference(BOOL value) {
            super(4);
            this.setValue(value);
        }

        public void setValue(BOOL value) {
            this.getPointer().setInt(0L, value.intValue());
        }

        public BOOL getValue() {
            return new BOOL((long)this.getPointer().getInt(0L));
        }
    }

    public static class BOOL
    extends IntegerType {
        public static final int SIZE = 4;

        public BOOL() {
            super(0);
        }

        public BOOL(long value) {
            super(4, value, false);
        }
    }

    public static class LCID
    extends DWORD {
        public LCID() {
            super(0L);
        }

        public LCID(long value) {
            super(value);
        }
    }

    public static class SCODEByReference
    extends ByReference {
        public SCODEByReference() {
            this(new SCODE(0));
        }

        public SCODEByReference(SCODE value) {
            super(4);
            this.setValue(value);
        }

        public void setValue(SCODE value) {
            this.getPointer().setInt(0L, value.intValue());
        }

        public SCODE getValue() {
            return new SCODE(this.getPointer().getInt(0L));
        }
    }

    public static class SCODE
    extends ULONG {
        public SCODE() {
            this(0);
        }

        public SCODE(int value) {
            super(value);
        }
    }

    public static class UINTByReference
    extends ByReference {
        public UINTByReference() {
            this(new UINT(0L));
        }

        public UINTByReference(UINT value) {
            super(4);
            this.setValue(value);
        }

        public void setValue(UINT value) {
            this.getPointer().setInt(0L, value.intValue());
        }

        public UINT getValue() {
            return new UINT((long)this.getPointer().getInt(0L));
        }
    }

    public static class UINT
    extends IntegerType {
        public static final int SIZE = 4;

        public UINT() {
            this(0L);
        }

        public UINT(long value) {
            super(4, value, true);
        }
    }

    public static class SHORT
    extends IntegerType {
        public static final int SIZE = 2;

        public SHORT() {
            this(0L);
        }

        public SHORT(long value) {
            super(2, value, false);
        }
    }

    public static class USHORTByReference
    extends ByReference {
        public USHORTByReference() {
            this(new USHORT(0L));
        }

        public USHORTByReference(USHORT value) {
            super(2);
            this.setValue(value);
        }

        public void setValue(USHORT value) {
            this.getPointer().setShort(0L, value.shortValue());
        }

        public USHORT getValue() {
            return new USHORT((long)this.getPointer().getShort(0L));
        }
    }

    public static class USHORT
    extends IntegerType {
        public static final int SIZE = 2;

        public USHORT() {
            this(0L);
        }

        public USHORT(long value) {
            super(2, value, true);
        }
    }

    public static class POINT
    extends Structure {
        public int x;
        public int y;

        public POINT() {
        }

        public POINT(Pointer memory) {
            super(memory);
            this.read();
        }

        public POINT(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("x", "y");
        }

        public static class ByReference
        extends POINT
        implements Structure.ByReference {
        }
    }

    public static class LPVOID
    extends BaseTSD.LONG_PTR {
        public LPVOID() {
            this(0L);
        }

        public LPVOID(long value) {
            super(value);
        }
    }

    public static class PVOID
    extends WinNT.HANDLE {
        public PVOID() {
        }

        public PVOID(Pointer p) {
            super(p);
        }
    }

    public static class ATOM
    extends WORD {
        public ATOM() {
            this(0L);
        }

        public ATOM(long value) {
            super(value);
        }
    }

    public static class HBRUSH
    extends WinNT.HANDLE {
        public HBRUSH() {
        }

        public HBRUSH(Pointer p) {
            super(p);
        }
    }

    public static class DWORDLONG
    extends IntegerType {
        public static final int SIZE = 8;

        public DWORDLONG() {
            this(0L);
        }

        public DWORDLONG(long value) {
            super(8, value, true);
        }
    }

    public static class ULONGLONGByReference
    extends ByReference {
        public ULONGLONGByReference() {
            this(new ULONGLONG(0L));
        }

        public ULONGLONGByReference(ULONGLONG value) {
            super(8);
            this.setValue(value);
        }

        public void setValue(ULONGLONG value) {
            this.getPointer().setLong(0L, value.longValue());
        }

        public ULONGLONG getValue() {
            return new ULONGLONG(this.getPointer().getLong(0L));
        }
    }

    public static class ULONGLONG
    extends IntegerType {
        public static final int SIZE = 8;

        public ULONGLONG() {
            this(0L);
        }

        public ULONGLONG(long value) {
            super(8, value, true);
        }
    }

    public static class ULONGByReference
    extends ByReference {
        public ULONGByReference() {
            this(new ULONG(0));
        }

        public ULONGByReference(ULONG value) {
            super(4);
            this.setValue(value);
        }

        public void setValue(ULONG value) {
            this.getPointer().setInt(0L, value.intValue());
        }

        public ULONG getValue() {
            return new ULONG(this.getPointer().getInt(0L));
        }
    }

    public static class ULONG
    extends IntegerType {
        public static final int SIZE = 4;

        public ULONG() {
            this(0);
        }

        public ULONG(int value) {
            super(4, value, true);
        }
    }

    public static class RECT
    extends Structure {
        public int left;
        public int top;
        public int right;
        public int bottom;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("left", "top", "right", "bottom");
        }

        public Rectangle toRectangle() {
            return new Rectangle(this.left, this.top, this.right - this.left, this.bottom - this.top);
        }

        @Override
        public String toString() {
            return "[(" + this.left + "," + this.top + ")(" + this.right + "," + this.bottom + ")]";
        }
    }

    public static class WPARAM
    extends UINT_PTR {
        public WPARAM() {
            this(0L);
        }

        public WPARAM(long value) {
            super(value);
        }
    }

    public static class UINT_PTR
    extends IntegerType {
        public UINT_PTR() {
            super(Pointer.SIZE);
        }

        public UINT_PTR(long value) {
            super(Pointer.SIZE, value, true);
        }

        public Pointer toPointer() {
            return Pointer.createConstant(this.longValue());
        }
    }

    public static class INT_PTR
    extends IntegerType {
        public INT_PTR() {
            super(Pointer.SIZE);
        }

        public INT_PTR(long value) {
            super(Pointer.SIZE, value);
        }

        public Pointer toPointer() {
            return Pointer.createConstant(this.longValue());
        }
    }

    public static class LRESULT
    extends BaseTSD.LONG_PTR {
        public LRESULT() {
            this(0L);
        }

        public LRESULT(long value) {
            super(value);
        }
    }

    public static class LPARAM
    extends BaseTSD.LONG_PTR {
        public LPARAM() {
            this(0L);
        }

        public LPARAM(long value) {
            super(value);
        }
    }

    public static class HFONT
    extends WinNT.HANDLE {
        public HFONT() {
        }

        public HFONT(Pointer p) {
            super(p);
        }
    }

    public static class HMODULE
    extends HINSTANCE {
    }

    public static class HINSTANCE
    extends WinNT.HANDLE {
    }

    public static class HWND
    extends WinNT.HANDLE {
        public HWND() {
        }

        public HWND(Pointer p) {
            super(p);
        }
    }

    public static class HRGN
    extends WinNT.HANDLE {
        public HRGN() {
        }

        public HRGN(Pointer p) {
            super(p);
        }
    }

    public static class HBITMAP
    extends WinNT.HANDLE {
        public HBITMAP() {
        }

        public HBITMAP(Pointer p) {
            super(p);
        }
    }

    public static class HPALETTE
    extends WinNT.HANDLE {
        public HPALETTE() {
        }

        public HPALETTE(Pointer p) {
            super(p);
        }
    }

    public static class HRSRC
    extends WinNT.HANDLE {
        public HRSRC() {
        }

        public HRSRC(Pointer p) {
            super(p);
        }
    }

    public static class HPEN
    extends WinNT.HANDLE {
        public HPEN() {
        }

        public HPEN(Pointer p) {
            super(p);
        }
    }

    public static class HMENU
    extends WinNT.HANDLE {
        public HMENU() {
        }

        public HMENU(Pointer p) {
            super(p);
        }
    }

    public static class HCURSOR
    extends HICON {
        public HCURSOR() {
        }

        public HCURSOR(Pointer p) {
            super(p);
        }
    }

    public static class HICON
    extends WinNT.HANDLE {
        public HICON() {
        }

        public HICON(Pointer p) {
            super(p);
        }
    }

    public static class HDC
    extends WinNT.HANDLE {
        public HDC() {
        }

        public HDC(Pointer p) {
            super(p);
        }
    }

    public static class LONGLONGByReference
    extends ByReference {
        public LONGLONGByReference() {
            this(new LONGLONG(0L));
        }

        public LONGLONGByReference(LONGLONG value) {
            super(8);
            this.setValue(value);
        }

        public void setValue(LONGLONG value) {
            this.getPointer().setLong(0L, value.longValue());
        }

        public LONGLONG getValue() {
            return new LONGLONG(this.getPointer().getLong(0L));
        }
    }

    public static class LONGLONG
    extends IntegerType {
        public static final int SIZE = 8;

        public LONGLONG() {
            this(0L);
        }

        public LONGLONG(long value) {
            super(8, value, false);
        }
    }

    public static class LONGByReference
    extends ByReference {
        public LONGByReference() {
            this(new LONG(0));
        }

        public LONGByReference(LONG value) {
            super(4);
            this.setValue(value);
        }

        public void setValue(LONG value) {
            this.getPointer().setInt(0L, value.intValue());
        }

        public LONG getValue() {
            return new LONG(this.getPointer().getInt(0L));
        }
    }

    public static class LONG
    extends IntegerType {
        public static final int SIZE = 4;

        public LONG() {
            this(0);
        }

        public LONG(int value) {
            super(4, value);
        }
    }

    public static class DWORDByReference
    extends ByReference {
        public DWORDByReference() {
            this(new DWORD(0L));
        }

        public DWORDByReference(DWORD value) {
            super(4);
            this.setValue(value);
        }

        public void setValue(DWORD value) {
            this.getPointer().setInt(0L, value.intValue());
        }

        public DWORD getValue() {
            return new DWORD((long)this.getPointer().getInt(0L));
        }
    }

    public static class DWORD
    extends IntegerType {
        public static final int SIZE = 4;

        public DWORD() {
            this(0L);
        }

        public DWORD(long value) {
            super(4, value, true);
        }

        public WORD getLow() {
            return new WORD(this.longValue() & 0xFFL);
        }

        public WORD getHigh() {
            return new WORD(this.longValue() >> 16 & 0xFFL);
        }
    }

    public static class WORDByReference
    extends ByReference {
        public WORDByReference() {
            this(new WORD(0L));
        }

        public WORDByReference(WORD value) {
            super(2);
            this.setValue(value);
        }

        public void setValue(WORD value) {
            this.getPointer().setShort(0L, value.shortValue());
        }

        public WORD getValue() {
            return new WORD((long)this.getPointer().getShort(0L));
        }
    }

    public static class WORD
    extends IntegerType {
        public static final int SIZE = 2;

        public WORD() {
            this(0L);
        }

        public WORD(long value) {
            super(2, value, true);
        }
    }
}

