/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.iterator.OLazyWrapperIterator;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;

public class OrientEdgeIterator
extends OLazyWrapperIterator<OrientEdge> {
    private final OrientVertex sourceVertex;
    private final OrientVertex targetVertex;
    private final OPair<Direction, String> connection;
    private final String[] labels;

    public OrientEdgeIterator(OrientVertex iSourceVertex, OrientVertex iTargetVertex, Object iMultiValue, Iterator<?> iterator, OPair<Direction, String> connection, String[] iLabels, int iSize) {
        super(iterator, iSize, iMultiValue);
        this.sourceVertex = iSourceVertex;
        this.targetVertex = iTargetVertex;
        this.connection = connection;
        this.labels = iLabels;
    }

    @Override
    public OrientEdge createGraphElement(Object iObject) {
        OrientEdge edge;
        if (iObject instanceof OrientEdge) {
            return (OrientEdge)iObject;
        }
        OIdentifiable rec = (OIdentifiable)iObject;
        if (rec == null) {
            OLogManager.instance().warn((Object)this, "Record (%s) is null", iObject);
            return null;
        }
        Object record = rec.getRecord();
        if (record == null) {
            OLogManager.instance().warn((Object)this, "Record (%s) is null", rec);
            return null;
        }
        if (!(record instanceof ODocument)) {
            OLogManager.instance().warn((Object)this, "Found a record (%s) that is not an edge. Source vertex : %s, Target vertex : %s, Database : %s .", rec, this.sourceVertex != null ? this.sourceVertex.getIdentity() : null, this.targetVertex != null ? this.targetVertex.getIdentity() : null, record.getDatabase().getURL());
            return null;
        }
        ODocument value = (ODocument)rec.getRecord();
        if (value == null) {
            return null;
        }
        OImmutableClass immutableSchema = ODocumentInternal.getImmutableSchemaClass(value);
        if (immutableSchema == null) {
            ODatabaseDocument db = value.getDatabaseIfDefined();
            if (db == null) {
                return null;
            }
            db.getMetadata().reload();
            immutableSchema = ODocumentInternal.getImmutableSchemaClass(value);
            if (immutableSchema == null) {
                return null;
            }
        }
        if (immutableSchema.isVertexType()) {
            edge = this.connection.getKey() == Direction.OUT ? new OrientEdge(this.sourceVertex.getGraph(), this.sourceVertex.getIdentity(), rec.getIdentity(), this.connection.getValue()) : new OrientEdge(this.sourceVertex.getGraph(), rec.getIdentity(), this.sourceVertex.getIdentity(), this.connection.getValue());
        } else if (immutableSchema.isEdgeType()) {
            edge = new OrientEdge(this.sourceVertex.getGraph(), (OIdentifiable)rec.getIdentity(), this.connection.getValue());
        } else {
            throw new IllegalStateException("Invalid content found while iterating edges, value '" + value + "' is not an edge");
        }
        if (this.sourceVertex.settings.isUseVertexFieldsForEdgeLabels() || edge.isLabeled(this.labels)) {
            return edge;
        }
        return null;
    }

    @Override
    public boolean filter(OrientEdge iObject) {
        if (this.targetVertex != null && !this.targetVertex.equals(iObject.getVertex(((Direction)((Object)this.connection.getKey())).opposite()))) {
            return false;
        }
        return this.sourceVertex.settings.isUseVertexFieldsForEdgeLabels() || iObject.isLabeled(this.labels);
    }

    @Override
    public boolean canUseMultiValueDirectly() {
        return true;
    }
}

