/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeIterator;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedVertex;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexIterator;
import com.tinkerpop.blueprints.impls.orient.OrientVertexQuery;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionVertex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrientVertex
extends OrientElement
implements OrientExtendedVertex {
    public static final String CONNECTION_OUT_PREFIX = "out_";
    public static final String CONNECTION_IN_PREFIX = "in_";
    private static final long serialVersionUID = 1L;

    public OrientVertex() {
        super(null, null);
    }

    protected OrientVertex(OrientBaseGraph graph, String className, Object ... fields) {
        super(graph, null);
        if (className != null) {
            className = this.checkForClassInSchema(OrientBaseGraph.encodeClassName(className));
        }
        this.rawElement = new ODocument(className == null ? "V" : className);
        this.setPropertiesInternal(fields);
    }

    public OrientVertex(OrientBaseGraph graph, OIdentifiable record) {
        super(graph, record);
    }

    public static String getConnectionFieldName(Direction iDirection, String iClassName, boolean useVertexFieldsForEdgeLabels) {
        if (iDirection == null || iDirection == Direction.BOTH) {
            throw new IllegalArgumentException("Direction not valid");
        }
        if (useVertexFieldsForEdgeLabels) {
            String prefix;
            String string = prefix = iDirection == Direction.OUT ? CONNECTION_OUT_PREFIX : CONNECTION_IN_PREFIX;
            if (iClassName == null || iClassName.isEmpty() || iClassName.equals("E")) {
                return prefix;
            }
            return prefix + iClassName;
        }
        return iDirection == Direction.OUT ? "out" : "in";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object createLink(OrientBaseGraph iGraph, ODocument iFromVertex, OIdentifiable iTo, String iFieldName) {
        Object out;
        OType propType;
        OType outType = iFromVertex.fieldType(iFieldName);
        Object found = iFromVertex.field(iFieldName);
        OImmutableClass linkClass = ODocumentInternal.getImmutableSchemaClass(iFromVertex);
        if (linkClass == null) {
            throw new IllegalArgumentException("Class not found in source vertex: " + iFromVertex);
        }
        OProperty prop = linkClass.getProperty(iFieldName);
        OType oType = propType = prop != null && prop.getType() != OType.ANY ? prop.getType() : null;
        if (found == null) {
            if (iGraph.isAutoScaleEdgeType() && (prop == null || propType == OType.LINK || "true".equalsIgnoreCase(prop.getCustom("ordered")))) {
                out = iTo;
                outType = OType.LINK;
            } else if (propType == OType.LINKLIST || prop != null && "true".equalsIgnoreCase(prop.getCustom("ordered"))) {
                ORecordLazyList coll = new ORecordLazyList(iFromVertex);
                coll.add(iTo);
                out = coll;
                outType = OType.LINKLIST;
            } else {
                if (propType != null && propType != OType.LINKBAG) throw new IllegalStateException("Type of field provided in schema '" + (Object)((Object)prop.getType()) + "' cannot be used for link creation.");
                ORidBag bag = new ORidBag();
                bag.add(iTo);
                out = bag;
                outType = OType.LINKBAG;
            }
        } else if (found instanceof OIdentifiable) {
            if (prop != null && propType == OType.LINK) {
                throw new IllegalStateException("Type of field provided in schema '" + (Object)((Object)prop.getType()) + "' cannot be used for creation to hold several links.");
            }
            if (prop != null && "true".equalsIgnoreCase(prop.getCustom("ordered"))) {
                ORecordLazyList coll = new ORecordLazyList(iFromVertex);
                coll.add(found);
                coll.add(iTo);
                out = coll;
                outType = OType.LINKLIST;
            } else {
                ORidBag bag = new ORidBag();
                bag.add((OIdentifiable)found);
                bag.add(iTo);
                out = bag;
                outType = OType.LINKBAG;
            }
        } else if (found instanceof ORidBag) {
            out = null;
            ((ORidBag)found).add(iTo);
        } else {
            if (!(found instanceof Collection)) throw new IllegalStateException("Relationship content is invalid on field " + iFieldName + ". Found: " + found);
            out = null;
            ((Collection)found).add(iTo);
        }
        if (out == null) return out;
        iFromVertex.field(iFieldName, out, outType);
        return out;
    }

    public static Direction getConnectionDirection(String iConnectionField, boolean useVertexFieldsForEdgeLabels) {
        if (iConnectionField == null) {
            throw new IllegalArgumentException("Cannot return direction of NULL connection ");
        }
        if (useVertexFieldsForEdgeLabels) {
            if (iConnectionField.startsWith(CONNECTION_OUT_PREFIX)) {
                return Direction.OUT;
            }
            if (iConnectionField.startsWith(CONNECTION_IN_PREFIX)) {
                return Direction.IN;
            }
        } else {
            if (iConnectionField.equals("out")) {
                return Direction.OUT;
            }
            if (iConnectionField.startsWith("in")) {
                return Direction.IN;
            }
        }
        throw new IllegalArgumentException("Cannot return direction of connection " + iConnectionField);
    }

    public static String getInverseConnectionFieldName(String iFieldName, boolean useVertexFieldsForEdgeLabels) {
        if (useVertexFieldsForEdgeLabels) {
            if (iFieldName.startsWith(CONNECTION_OUT_PREFIX)) {
                if (iFieldName.length() == CONNECTION_OUT_PREFIX.length()) {
                    return CONNECTION_IN_PREFIX;
                }
                return CONNECTION_IN_PREFIX + iFieldName.substring(CONNECTION_OUT_PREFIX.length());
            }
            if (iFieldName.startsWith(CONNECTION_IN_PREFIX)) {
                if (iFieldName.length() == CONNECTION_IN_PREFIX.length()) {
                    return CONNECTION_OUT_PREFIX;
                }
                return CONNECTION_OUT_PREFIX + iFieldName.substring(CONNECTION_IN_PREFIX.length());
            }
            throw new IllegalArgumentException("Cannot find reverse connection name for field " + iFieldName);
        }
        if (iFieldName.equals("out")) {
            return "in";
        }
        if (iFieldName.equals("in")) {
            return "out";
        }
        throw new IllegalArgumentException("Cannot find reverse connection name for field " + iFieldName);
    }

    public static void removeEdges(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, boolean iAlsoInverse, boolean useVertexFieldsForEdgeLabels) {
        Object fieldValue;
        if (iVertex == null) {
            return;
        }
        Object object = fieldValue = iVertexToRemove != null ? iVertex.field(iFieldName) : iVertex.removeField(iFieldName);
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof OIdentifiable) {
            if (iVertexToRemove != null) {
                if (!fieldValue.equals(iVertexToRemove)) {
                    return;
                }
                iVertex.removeField(iFieldName);
            }
            if (iAlsoInverse) {
                OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, fieldValue, useVertexFieldsForEdgeLabels);
            }
            OrientVertex.deleteEdgeIfAny((OIdentifiable)fieldValue);
        } else if (fieldValue instanceof ORidBag) {
            ORidBag bag = (ORidBag)fieldValue;
            if (iVertexToRemove != null) {
                boolean found = false;
                Iterator<OIdentifiable> it = bag.rawIterator();
                while (it.hasNext()) {
                    Direction direction;
                    ODocument curr = (ODocument)it.next().getRecord();
                    if (curr == null) {
                        it.remove();
                        continue;
                    }
                    if (iVertexToRemove.equals(curr)) {
                        it.remove();
                        if (iAlsoInverse) {
                            OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels);
                        }
                        found = true;
                        break;
                    }
                    if (!ODocumentInternal.getImmutableSchemaClass(curr).isEdgeType() || !iVertexToRemove.equals(OrientEdge.getConnection(curr, (direction = OrientVertex.getConnectionDirection(iFieldName, useVertexFieldsForEdgeLabels)).opposite()))) continue;
                    it.remove();
                    if (iAlsoInverse) {
                        OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    OLogManager.instance().warn(null, "[OrientVertex.removeEdges] edge %s not found in field %s", iVertexToRemove, iFieldName);
                }
                OrientVertex.deleteEdgeIfAny(iVertexToRemove);
            } else {
                Iterator<OIdentifiable> it = bag.rawIterator();
                while (it.hasNext()) {
                    OIdentifiable edge = it.next();
                    if (iAlsoInverse) {
                        OrientVertex.removeInverseEdge(iVertex, iFieldName, null, edge, useVertexFieldsForEdgeLabels);
                    }
                    OrientVertex.deleteEdgeIfAny(edge);
                }
            }
            if (bag.isEmpty()) {
                iVertex.removeField(iFieldName);
            }
        } else if (fieldValue instanceof Collection) {
            Collection col = (Collection)fieldValue;
            if (iVertexToRemove != null) {
                boolean found = false;
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    Direction direction;
                    ODocument curr = (ODocument)((OIdentifiable)it.next()).getRecord();
                    if (iVertexToRemove.equals(curr)) {
                        it.remove();
                        if (iAlsoInverse) {
                            OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels);
                        }
                        found = true;
                        break;
                    }
                    if (!ODocumentInternal.getImmutableSchemaClass(curr).isVertexType() || !iVertexToRemove.equals(OrientEdge.getConnection(curr, (direction = OrientVertex.getConnectionDirection(iFieldName, useVertexFieldsForEdgeLabels)).opposite()))) continue;
                    it.remove();
                    if (iAlsoInverse) {
                        OrientVertex.removeInverseEdge(iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    OLogManager.instance().warn(null, "[OrientVertex.removeEdges] edge %s not found in field %s", iVertexToRemove, iFieldName);
                }
                OrientVertex.deleteEdgeIfAny(iVertexToRemove);
            } else {
                for (OIdentifiable edge : col) {
                    if (iAlsoInverse) {
                        OrientVertex.removeInverseEdge(iVertex, iFieldName, null, edge, useVertexFieldsForEdgeLabels);
                    }
                    OrientVertex.deleteEdgeIfAny(edge);
                }
            }
            if (col.isEmpty()) {
                iVertex.removeField(iFieldName);
            }
        }
        iVertex.save();
    }

    public static void replaceLinks(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, OIdentifiable iNewVertex) {
        Collection col;
        Object fieldValue;
        if (iVertex == null) {
            return;
        }
        Object object = fieldValue = iVertexToRemove != null ? iVertex.field(iFieldName) : iVertex.removeField(iFieldName);
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof OIdentifiable) {
            if (iVertexToRemove != null) {
                if (!fieldValue.equals(iVertexToRemove)) {
                    return;
                }
                iVertex.field(iFieldName, iNewVertex);
            }
        } else if (fieldValue instanceof ORidBag) {
            ORidBag bag = (ORidBag)fieldValue;
            boolean found = false;
            Iterator<OIdentifiable> it = bag.rawIterator();
            while (it.hasNext()) {
                if (!it.next().equals(iVertexToRemove)) continue;
                found = true;
                it.remove();
            }
            if (found) {
                bag.add(iNewVertex);
            }
        } else if (fieldValue instanceof Collection && (col = (Collection)fieldValue).remove(iVertexToRemove)) {
            col.add(iNewVertex);
        }
        iVertex.save();
    }

    private static void deleteEdgeIfAny(OIdentifiable iRecord) {
        OImmutableClass clazz;
        ODocument doc;
        if (iRecord != null && (doc = (ODocument)iRecord.getRecord()) != null && (clazz = ODocumentInternal.getImmutableSchemaClass(doc)) != null && clazz.isEdgeType()) {
            try {
                doc.delete();
            }
            catch (ORecordNotFoundException oRecordNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void removeInverseEdge(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, Object iFieldValue, boolean useVertexFieldsForEdgeLabels) {
        ODocument r = (ODocument)((OIdentifiable)iFieldValue).getRecord();
        if (r == null) {
            return;
        }
        String inverseFieldName = OrientVertex.getInverseConnectionFieldName(iFieldName, useVertexFieldsForEdgeLabels);
        OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass(r);
        if (immutableClass.isVertexType()) {
            OrientVertex.removeEdges(r, inverseFieldName, iVertex, false, useVertexFieldsForEdgeLabels);
        } else if (immutableClass.isEdgeType()) {
            OIdentifiable otherVertex = OrientEdge.getConnection(r, OrientVertex.getConnectionDirection(inverseFieldName, useVertexFieldsForEdgeLabels));
            if (otherVertex != null) {
                if (iVertexToRemove == null || otherVertex.equals(iVertexToRemove)) {
                    OrientVertex.removeEdges((ODocument)otherVertex.getRecord(), inverseFieldName, (OIdentifiable)iFieldValue, false, useVertexFieldsForEdgeLabels);
                }
            } else {
                throw new IllegalStateException("Invalid content found in " + iFieldName + " field");
            }
        }
    }

    protected static OrientEdge getEdge(OrientBaseGraph graph, ODocument doc, String fieldName, OPair<Direction, String> connection, Object fieldValue, OIdentifiable iTargetVertex, String[] iLabels) {
        OrientEdge toAdd;
        ODocument fieldRecord = (ODocument)((OIdentifiable)fieldValue).getRecord();
        if (fieldRecord == null) {
            return null;
        }
        OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass(fieldRecord);
        if (immutableClass.isVertexType()) {
            if (iTargetVertex != null && !iTargetVertex.equals(fieldValue)) {
                return null;
            }
            toAdd = connection.getKey() == Direction.OUT ? new OrientEdge(graph, doc, fieldRecord, connection.getValue()) : new OrientEdge(graph, fieldRecord, doc, connection.getValue());
        } else if (immutableClass.isEdgeType()) {
            OIdentifiable targetVertex;
            if (iTargetVertex != null && !iTargetVertex.equals(targetVertex = OrientEdge.getConnection(fieldRecord, ((Direction)((Object)connection.getKey())).opposite()))) {
                return null;
            }
            toAdd = new OrientEdge(graph, fieldRecord);
        } else {
            throw new IllegalStateException("Invalid content found in " + fieldName + " field: " + fieldRecord);
        }
        return toAdd;
    }

    @Override
    public OrientVertex copy() {
        OrientVertex v = new OrientVertex();
        super.copyTo(v);
        return v;
    }

    @Override
    public OrientVertex getVertexInstance() {
        return this;
    }

    public Object execute(OCommandPredicate iPredicate) {
        Object result = iPredicate.evaluate((OIdentifiable)this.rawElement.getRecord(), null, null);
        if (result instanceof OAutoConvertToRecord) {
            ((OAutoConvertToRecord)result).setAutoConvertToRecord(true);
        }
        return result;
    }

    @Override
    public Set<String> getPropertyKeys() {
        OrientBaseGraph graph = this.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        HashSet<String> result = new HashSet<String>();
        for (String field : doc.fieldNames()) {
            if (graph != null && this.settings.isUseVertexFieldsForEdgeLabels()) {
                if (field.startsWith(CONNECTION_OUT_PREFIX) || field.startsWith(CONNECTION_IN_PREFIX)) continue;
                result.add(field);
                continue;
            }
            if (field.equals("out") || field.equals("in")) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public Iterable<Vertex> getVertices(Direction iDirection, String ... iLabels) {
        this.setCurrentGraphInThreadLocal();
        OrientBaseGraph.getEdgeClassNames(this.getGraph(), iLabels);
        OrientBaseGraph.encodeClassNames(iLabels);
        ODocument doc = this.getRecord();
        OMultiCollectionIterator<Vertex> iterable = new OMultiCollectionIterator<Vertex>();
        for (String fieldName : doc.fieldNames()) {
            Object fieldValue;
            OPair<Direction, String> connection = this.getConnection(iDirection, fieldName, iLabels);
            if (connection == null || (fieldValue = doc.field(fieldName)) == null) continue;
            if (fieldValue instanceof OIdentifiable) {
                this.addSingleVertex(doc, iterable, fieldName, connection, fieldValue, iLabels);
                continue;
            }
            if (fieldValue instanceof Collection) {
                Collection coll = (Collection)fieldValue;
                if (coll.size() == 1) {
                    if (coll instanceof ORecordLazyMultiValue) {
                        this.addSingleVertex(doc, iterable, fieldName, connection, ((ORecordLazyMultiValue)((Object)coll)).rawIterator().next(), iLabels);
                        continue;
                    }
                    if (coll instanceof List) {
                        this.addSingleVertex(doc, iterable, fieldName, connection, ((List)coll).get(0), iLabels);
                        continue;
                    }
                    this.addSingleVertex(doc, iterable, fieldName, connection, coll.iterator().next(), iLabels);
                    continue;
                }
                if (coll instanceof ORecordLazyMultiValue) {
                    iterable.add(new OrientVertexIterator(this, coll, ((ORecordLazyMultiValue)((Object)coll)).rawIterator(), connection, iLabels, coll.size()));
                    continue;
                }
                iterable.add(new OrientVertexIterator(this, coll, coll.iterator(), connection, iLabels, -1));
                continue;
            }
            if (!(fieldValue instanceof ORidBag)) continue;
            iterable.add(new OrientVertexIterator(this, fieldValue, ((ORidBag)fieldValue).rawIterator(), connection, iLabels, -1));
        }
        return iterable;
    }

    @Override
    public OrientVertexQuery query() {
        this.setCurrentGraphInThreadLocal();
        return new OrientVertexQuery(this);
    }

    public OTraverse traverse() {
        this.setCurrentGraphInThreadLocal();
        return new OTraverse().target(new OIdentifiable[]{this.getRecord()});
    }

    @Override
    public void remove() {
        this.checkClass();
        OrientBaseGraph graph = this.checkIfAttached();
        graph.setCurrentGraphInThreadLocal();
        graph.autoStartTransaction();
        ODocument doc = this.getRecord();
        if (doc == null) {
            throw ExceptionFactory.vertexWithIdDoesNotExist(this.getId());
        }
        Iterator<Index<? extends Element>> it = graph.getIndices().iterator();
        if (it.hasNext()) {
            HashSet<Edge> allEdges = new HashSet<Edge>();
            for (Edge e : this.getEdges(Direction.BOTH, new String[0])) {
                allEdges.add(e);
            }
            while (it.hasNext()) {
                OrientIndex idx;
                Index<? extends Element> index = it.next();
                if (Vertex.class.isAssignableFrom(index.getIndexClass())) {
                    idx = (OrientIndex)index;
                    idx.removeElement(this);
                }
                if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
                idx = (OrientIndex)index;
                for (Edge e : allEdges) {
                    idx.removeElement((OrientEdge)e);
                }
            }
        }
        for (String fieldName : doc.fieldNames()) {
            OPair<Direction, String> connection = this.getConnection(Direction.BOTH, fieldName, new String[0]);
            if (connection == null) continue;
            OrientVertex.removeEdges(doc, fieldName, null, true, this.settings.isUseVertexFieldsForEdgeLabels());
        }
        super.remove();
    }

    public ORID moveToClass(String iClassName) {
        return this.moveTo(iClassName, null);
    }

    public ORID moveToCluster(String iClusterName) {
        return this.moveTo(null, iClusterName);
    }

    public ORID moveTo(String iClassName, String iClusterName) {
        OrientEdge oe;
        OrientBaseGraph graph = this.getGraph();
        if (this.checkDeletedInTx()) {
            throw new IllegalStateException("The vertex " + this.getIdentity() + " has been deleted");
        }
        ORID oldIdentity = this.getIdentity().copy();
        Object oldRecord = oldIdentity.getRecord();
        if (oldRecord == null) {
            throw new IllegalStateException("The vertex " + this.getIdentity() + " has been deleted");
        }
        if (!graph.getRawGraph().getTransaction().isActive()) {
            throw new IllegalStateException("Move vertex requires an active transaction to be executed in safe manner");
        }
        oldRecord.delete();
        ODocument doc = ((ODocument)this.rawElement.getRecord()).copy();
        Iterable<Edge> outEdges = this.getEdges(Direction.OUT, new String[0]);
        Iterable<Edge> inEdges = this.getEdges(Direction.IN, new String[0]);
        if (iClassName != null) {
            doc.setClassName(iClassName);
        }
        doc.setDirty();
        ORecordInternal.setIdentity(doc, new ORecordId());
        if (iClusterName != null) {
            doc.save(iClusterName);
        } else {
            doc.save();
        }
        ORID newIdentity = doc.getIdentity();
        for (Edge e : outEdges) {
            oe = (OrientEdge)e;
            if (oe.isLightweight()) {
                OrientVertex inV = oe.getVertex(Direction.IN);
                String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, oe.getLabel(), graph.isUseVertexFieldsForEdgeLabels());
                OrientVertex.replaceLinks(inV.getRecord(), inFieldName, oldIdentity, doc);
                continue;
            }
            oe.vOut = doc;
            oe.getRecord().field("out", doc);
            oe.save();
        }
        for (Edge e : inEdges) {
            oe = (OrientEdge)e;
            if (oe.isLightweight()) {
                OrientVertex outV = oe.getVertex(Direction.OUT);
                String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, oe.getLabel(), graph.isUseVertexFieldsForEdgeLabels());
                OrientVertex.replaceLinks(outV.getRecord(), outFieldName, oldIdentity, doc);
                continue;
            }
            oe.vIn = doc;
            oe.getRecord().field("in", doc);
            oe.save();
        }
        doc.save();
        return newIdentity;
    }

    @Override
    public Edge addEdge(String label, Vertex inVertex) {
        if (inVertex instanceof PartitionVertex) {
            inVertex = ((PartitionVertex)inVertex).getBaseVertex();
        }
        return this.addEdge(label, (OrientVertex)inVertex, null, null, null);
    }

    public OrientEdge addEdge(String label, OrientVertex inVertex, String iClassName) {
        return this.addEdge(label, inVertex, iClassName, null, null);
    }

    public OrientEdge addEdge(String label, OrientVertex inVertex, Object[] fields) {
        return this.addEdge(label, inVertex, null, null, fields);
    }

    public OrientEdge addEdge(String label, OrientVertex inVertex, String iClassName, String iClusterName, Object ... fields) {
        OrientEdge edge;
        OIdentifiable to;
        OIdentifiable from;
        ODocument outDocument;
        if (inVertex == null) {
            throw new IllegalArgumentException("destination vertex is null");
        }
        if (this.checkDeletedInTx()) {
            throw new IllegalStateException("The vertex " + this.getIdentity() + " has been deleted");
        }
        if (inVertex.checkDeletedInTx()) {
            throw new IllegalStateException("The vertex " + inVertex.getIdentity() + " has been deleted");
        }
        OrientBaseGraph graph = this.setCurrentGraphInThreadLocal();
        if (graph != null) {
            graph.autoStartTransaction();
        }
        if ((outDocument = this.getRecord()) == null) {
            throw new IllegalArgumentException("source vertex is invalid (rid=" + this.getIdentity() + ")");
        }
        if (!ODocumentInternal.getImmutableSchemaClass(outDocument).isVertexType()) {
            throw new IllegalArgumentException("source record is not a vertex");
        }
        ODocument inDocument = inVertex.getRecord();
        if (inDocument == null) {
            throw new IllegalArgumentException("destination vertex is invalid (rid=" + inVertex.getIdentity() + ")");
        }
        if (!ODocumentInternal.getImmutableSchemaClass(outDocument).isVertexType()) {
            throw new IllegalArgumentException("destination record is not a vertex");
        }
        if ((label = OrientBaseGraph.encodeClassName(label)) == null && iClassName != null) {
            label = OrientBaseGraph.encodeClassName(iClassName);
        }
        if (graph != null && graph.isUseClassForEdgeLabel()) {
            OrientEdgeType edgeType = graph.getEdgeType(label);
            if (edgeType == null) {
                graph.createEdgeType(label);
            } else {
                label = edgeType.getName();
            }
        }
        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, label, this.settings.isUseVertexFieldsForEdgeLabels());
        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, label, this.settings.isUseVertexFieldsForEdgeLabels());
        if (label == null) {
            throw ExceptionFactory.edgeLabelCanNotBeNull();
        }
        if (this.canCreateDynamicEdge(outDocument, inDocument, outFieldName, inFieldName, fields, label)) {
            from = this.rawElement;
            to = inDocument;
            edge = this.settings.isKeepInMemoryReferences() ? new OrientEdge(graph, from.getIdentity(), to.getIdentity(), label) : new OrientEdge(graph, from, to, label);
        } else {
            edge = new OrientEdge(graph, label, fields);
            if (this.settings.isKeepInMemoryReferences()) {
                edge.getRecord().fields("out", this.rawElement.getIdentity(), "in", inDocument.getIdentity());
            } else {
                edge.getRecord().fields("out", this.rawElement, "in", inDocument);
            }
            from = edge.getRecord();
            to = edge.getRecord();
        }
        if (this.settings.isKeepInMemoryReferences()) {
            from = from.getIdentity();
            to = to.getIdentity();
        }
        OrientVertex.createLink(graph, outDocument, to, outFieldName);
        OrientVertex.createLink(graph, inDocument, from, inFieldName);
        if (graph != null) {
            edge.save(iClusterName);
            inDocument.save();
            outDocument.save();
        }
        return edge;
    }

    public long countEdges(Direction iDirection, String ... iLabels) {
        this.checkIfAttached();
        long counter = 0L;
        OrientBaseGraph.getEdgeClassNames(this.getGraph(), iLabels);
        OrientBaseGraph.encodeClassNames(iLabels);
        if (this.settings.isUseVertexFieldsForEdgeLabels() || iLabels == null || iLabels.length == 0) {
            ODocument doc = this.getRecord();
            for (String fieldName : doc.fieldNames()) {
                Object fieldValue;
                OPair<Direction, String> connection = this.getConnection(iDirection, fieldName, iLabels);
                if (connection == null || (fieldValue = doc.field(fieldName)) == null) continue;
                if (fieldValue instanceof Collection) {
                    counter += (long)((Collection)fieldValue).size();
                    continue;
                }
                if (fieldValue instanceof Map) {
                    counter += (long)((Map)fieldValue).size();
                    continue;
                }
                if (fieldValue instanceof ORidBag) {
                    counter += (long)((ORidBag)fieldValue).size();
                    continue;
                }
                ++counter;
            }
        } else {
            for (Edge e : this.getEdges(iDirection, iLabels)) {
                if (e == null) continue;
                ++counter;
            }
        }
        return counter;
    }

    @Override
    public Iterable<Edge> getEdges(Direction iDirection, String ... iLabels) {
        return this.getEdges(null, iDirection, iLabels);
    }

    public Iterable<Edge> getEdges(OrientVertex iDestination, Direction iDirection, String ... iLabels) {
        this.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        OrientBaseGraph.getEdgeClassNames(this.getGraph(), iLabels);
        OrientBaseGraph.encodeClassNames(iLabels);
        OMultiCollectionIterator<Edge> iterable = new OMultiCollectionIterator().setEmbedded(true);
        for (String fieldName : doc.fieldNames()) {
            OIdentifiable destinationVId;
            Object fieldValue;
            OPair<Direction, String> connection = this.getConnection(iDirection, fieldName, iLabels);
            if (connection == null || (fieldValue = doc.field(fieldName)) == null) continue;
            OIdentifiable oIdentifiable = destinationVId = iDestination != null ? (OIdentifiable)iDestination.getId() : null;
            if (fieldValue instanceof OIdentifiable) {
                this.addSingleEdge(doc, iterable, fieldName, connection, fieldValue, destinationVId, iLabels);
                continue;
            }
            if (fieldValue instanceof Collection) {
                Collection coll = (Collection)fieldValue;
                if (coll.size() == 1) {
                    if (coll instanceof ORecordLazyMultiValue) {
                        this.addSingleEdge(doc, iterable, fieldName, connection, ((ORecordLazyMultiValue)((Object)coll)).rawIterator().next(), destinationVId, iLabels);
                        continue;
                    }
                    if (coll instanceof List) {
                        this.addSingleEdge(doc, iterable, fieldName, connection, ((List)coll).get(0), destinationVId, iLabels);
                        continue;
                    }
                    this.addSingleEdge(doc, iterable, fieldName, connection, coll.iterator().next(), destinationVId, iLabels);
                    continue;
                }
                if (coll instanceof ORecordLazyMultiValue) {
                    iterable.add(new OrientEdgeIterator(this, iDestination, coll, ((ORecordLazyMultiValue)((Object)coll)).rawIterator(), connection, iLabels, coll.size()));
                    continue;
                }
                iterable.add(new OrientEdgeIterator(this, iDestination, coll, coll.iterator(), connection, iLabels, -1));
                continue;
            }
            if (!(fieldValue instanceof ORidBag)) continue;
            iterable.add(new OrientEdgeIterator(this, iDestination, fieldValue, ((ORidBag)fieldValue).rawIterator(), connection, iLabels, ((ORidBag)fieldValue).size()));
        }
        return iterable;
    }

    @Override
    public String getLabel() {
        String clsName;
        this.setCurrentGraphInThreadLocal();
        if (this.settings.isUseClassForVertexLabel() && !"V".equals(clsName = this.getRecord().getClassName())) {
            return clsName;
        }
        return (String)this.getRecord().field("label");
    }

    @Override
    public String getBaseClassName() {
        return "V";
    }

    @Override
    public String getElementType() {
        return "Vertex";
    }

    @Override
    public OrientVertexType getType() {
        OrientBaseGraph graph = this.getGraph();
        return new OrientVertexType(graph, this.getRecord().getSchemaClass());
    }

    public String toString() {
        this.setCurrentGraphInThreadLocal();
        ODocument record = this.getRecord();
        if (record == null) {
            return "<invalid record " + this.rawElement.getIdentity() + ">";
        }
        String clsName = record.getClassName();
        if ("V".equals(clsName)) {
            return StringFactory.vertexString(this);
        }
        return "v(" + clsName + ")" + "[" + this.getId() + "]";
    }

    public String getConnectionClass(Direction iDirection, String iFieldName) {
        if (iDirection == Direction.OUT) {
            if (iFieldName.length() > CONNECTION_OUT_PREFIX.length()) {
                return iFieldName.substring(CONNECTION_OUT_PREFIX.length());
            }
        } else if (iDirection == Direction.IN && iFieldName.length() > CONNECTION_IN_PREFIX.length()) {
            return iFieldName.substring(CONNECTION_IN_PREFIX.length());
        }
        return "E";
    }

    protected OPair<Direction, String> getConnection(Direction iDirection, String iFieldName, String ... iClassNames) {
        OrientEdgeType type;
        if (iClassNames != null && iClassNames.length == 1 && iClassNames[0].equalsIgnoreCase("E")) {
            iClassNames = null;
        }
        OrientBaseGraph graph = this.getGraph();
        if (iDirection == Direction.OUT || iDirection == Direction.BOTH) {
            if (this.settings.isUseVertexFieldsForEdgeLabels()) {
                if (iFieldName.startsWith(CONNECTION_OUT_PREFIX)) {
                    if (iClassNames == null || iClassNames.length == 0) {
                        return new OPair<Direction, String>(Direction.OUT, this.getConnectionClass(Direction.OUT, iFieldName));
                    }
                    for (String clsName : iClassNames) {
                        clsName = OrientBaseGraph.encodeClassName(clsName);
                        if (iFieldName.equals(CONNECTION_OUT_PREFIX + clsName)) {
                            return new OPair<Direction, String>(Direction.OUT, clsName);
                        }
                        type = graph.getEdgeType(clsName);
                        if (type == null) continue;
                        for (OClass subType : type.getAllSubclasses()) {
                            clsName = subType.getName();
                            if (!iFieldName.equals(CONNECTION_OUT_PREFIX + clsName)) continue;
                            return new OPair<Direction, String>(Direction.OUT, clsName);
                        }
                    }
                }
            } else if (iFieldName.equals("out")) {
                return new OPair<Direction, Object>(Direction.OUT, null);
            }
        }
        if (iDirection == Direction.IN || iDirection == Direction.BOTH) {
            if (this.settings.isUseVertexFieldsForEdgeLabels()) {
                if (iFieldName.startsWith(CONNECTION_IN_PREFIX)) {
                    if (iClassNames == null || iClassNames.length == 0) {
                        return new OPair<Direction, String>(Direction.IN, this.getConnectionClass(Direction.IN, iFieldName));
                    }
                    for (String clsName : iClassNames) {
                        if (iFieldName.equals(CONNECTION_IN_PREFIX + clsName)) {
                            return new OPair<Direction, String>(Direction.IN, clsName);
                        }
                        type = graph.getEdgeType(clsName);
                        if (type == null) continue;
                        for (OClass subType : type.getAllSubclasses()) {
                            clsName = subType.getName();
                            if (!iFieldName.equals(CONNECTION_IN_PREFIX + clsName)) continue;
                            return new OPair<Direction, String>(Direction.IN, clsName);
                        }
                    }
                }
            } else if (iFieldName.equals("in")) {
                return new OPair<Direction, Object>(Direction.IN, null);
            }
        }
        return null;
    }

    protected void addSingleEdge(ODocument doc, OMultiCollectionIterator<Edge> iterable, String fieldName, OPair<Direction, String> connection, Object fieldValue, OIdentifiable iTargetVertex, String[] iLabels) {
        OrientBaseGraph graph = this.getGraph();
        OrientEdge toAdd = OrientVertex.getEdge(graph, doc, fieldName, connection, fieldValue, iTargetVertex, iLabels);
        if (toAdd != null && (this.settings.isUseVertexFieldsForEdgeLabels() || toAdd.isLabeled(iLabels))) {
            iterable.add(toAdd);
        }
    }

    private boolean canCreateDynamicEdge(ODocument iFromVertex, ODocument iToVertex, String iOutFieldName, String iInFieldName, Object[] fields, String label) {
        this.checkIfAttached();
        OrientBaseGraph graph = this.getGraph();
        if (!this.settings.isUseVertexFieldsForEdgeLabels() && label != null) {
            return false;
        }
        if (this.settings.isUseLightweightEdges() && (fields == null || fields.length == 0 || fields[0] == null || fields[0] instanceof Map && ((Map)fields[0]).isEmpty())) {
            OrientEdgeType cls;
            Object field = iFromVertex.field(iOutFieldName);
            if (field != null && field instanceof Collection && ((Collection)field).contains(iToVertex)) {
                new OrientEdge(graph, iFromVertex, iToVertex, label).convertToDocument();
                return false;
            }
            field = iToVertex.field(iInFieldName);
            if (field != null && field instanceof Collection && ((Collection)field).contains(iFromVertex)) {
                new OrientEdge(graph, iFromVertex, iToVertex, label).convertToDocument();
                return false;
            }
            if (this.settings.isUseClassForEdgeLabel() && (cls = graph.getEdgeType(label)) != null) {
                for (OProperty p : cls.properties()) {
                    if (!p.isMandatory() && !p.isNotNull() && p.getOwnerClass().getInvolvedIndexes(p.getName()).isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void addSingleVertex(ODocument doc, OMultiCollectionIterator<Vertex> iterable, String fieldName, OPair<Direction, String> connection, Object fieldValue, String[] iLabels) {
        OrientVertex toAdd;
        OrientBaseGraph graph = this.getGraph();
        ODocument fieldRecord = (ODocument)((OIdentifiable)fieldValue).getRecord();
        OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass(fieldRecord);
        if (immutableClass.isVertexType()) {
            toAdd = new OrientVertex(graph, fieldRecord);
        } else if (immutableClass.isEdgeType()) {
            if (this.settings.isUseVertexFieldsForEdgeLabels() || OrientEdge.isLabeled(OrientEdge.getRecordLabel(fieldRecord), iLabels)) {
                OIdentifiable vertexDoc = OrientEdge.getConnection(fieldRecord, ((Direction)((Object)connection.getKey())).opposite());
                if (vertexDoc == null) {
                    fieldRecord.reload();
                    vertexDoc = OrientEdge.getConnection(fieldRecord, ((Direction)((Object)connection.getKey())).opposite());
                    if (vertexDoc == null) {
                        OLogManager.instance().warn((Object)this, "Cannot load edge " + fieldRecord + " to get the " + (Object)((Object)((Direction)((Object)connection.getKey())).opposite()) + " vertex", new Object[0]);
                        return;
                    }
                }
                toAdd = new OrientVertex(graph, vertexDoc);
            } else {
                toAdd = null;
            }
        } else {
            throw new IllegalStateException("Invalid content found in " + fieldName + " field: " + fieldRecord);
        }
        if (toAdd != null) {
            iterable.add(toAdd);
        }
    }
}

