/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.gml;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;

class GMLParser {
    private final Map<Object, Object> vertexMappedIdMap = new HashMap<Object, Object>();
    private final String defaultEdgeLabel;
    private final Graph graph;
    private final String vertexIdKey;
    private final String edgeIdKey;
    private final String edgeLabelKey;
    private boolean directed = false;
    private int edgeCount = 0;

    public GMLParser(Graph graph, String defaultEdgeLabel, String vertexIdKey, String edgeIdKey, String edgeLabelKey) {
        this.graph = graph;
        this.vertexIdKey = vertexIdKey;
        this.edgeIdKey = edgeIdKey;
        this.edgeLabelKey = edgeLabelKey;
        this.defaultEdgeLabel = defaultEdgeLabel;
    }

    public void parse(StreamTokenizer st) throws IOException {
        while (this.hasNext(st)) {
            String value;
            int type = st.ttype;
            if (!this.notLineBreak(type) || !"graph".equals(value = st.sval)) continue;
            this.parseGraph(st);
            if (this.hasNext(st)) continue;
            return;
        }
        throw new IOException("Graph not complete");
    }

    private void parseGraph(StreamTokenizer st) throws IOException {
        this.checkValid(st, "graph");
        while (this.hasNext(st)) {
            int type = st.ttype;
            if (!this.notLineBreak(type)) continue;
            if (type == 93) {
                return;
            }
            String key = st.sval;
            if ("node".equals(key)) {
                this.addNode(this.parseNode(st));
                continue;
            }
            if ("edge".equals(key)) {
                this.addEdge(this.parseEdge(st));
                continue;
            }
            if ("directed".equals(key)) {
                this.directed = this.parseBoolean(st);
                continue;
            }
            this.parseValue("ignore", st);
        }
        throw new IOException("Graph not complete");
    }

    private void addNode(Map<String, Object> map) throws IOException {
        Object id = map.remove("id");
        if (id == null) {
            throw new IOException("No id found for node");
        }
        Vertex vertex = this.createVertex(map, id);
        this.addProperties(vertex, map);
    }

    private Vertex createVertex(Map<String, Object> map, Object id) {
        Object vertexId = id;
        if (this.vertexIdKey != null) {
            vertexId = map.remove(this.vertexIdKey);
            if (vertexId == null) {
                vertexId = id;
            }
            this.vertexMappedIdMap.put(id, vertexId);
        }
        Vertex createdVertex = this.graph.addVertex(vertexId);
        return createdVertex;
    }

    private void addEdge(Map<String, Object> map) throws IOException {
        Object mappedKey;
        Object source = map.remove("source");
        Object target = map.remove("target");
        if (source == null) {
            throw new IOException("Edge has no source");
        }
        if (target == null) {
            throw new IOException("Edge has no target");
        }
        if (this.vertexIdKey != null) {
            source = this.vertexMappedIdMap.get(source);
            target = this.vertexMappedIdMap.get(target);
        }
        Vertex outVertex = this.graph.getVertex(source);
        Vertex inVertex = this.graph.getVertex(target);
        if (outVertex == null) {
            throw new IOException("Edge source " + source + " not found");
        }
        if (inVertex == null) {
            throw new IOException("Edge target " + target + " not found");
        }
        Object label = map.remove(this.edgeLabelKey);
        if (label == null) {
            label = map.remove("label");
        } else {
            map.remove("label");
        }
        if (label == null) {
            label = this.defaultEdgeLabel;
        }
        Object edgeId = this.edgeCount++;
        if (this.edgeIdKey != null && (mappedKey = map.remove(this.edgeIdKey)) != null) {
            edgeId = mappedKey;
        }
        map.remove("id");
        Edge edge = this.graph.addEdge(edgeId, outVertex, inVertex, label.toString());
        if (this.directed) {
            edge.setProperty("directed", this.directed);
        }
        this.addProperties(edge, map);
    }

    private void addProperties(Element element, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            element.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private Object parseValue(String key, StreamTokenizer st) throws IOException {
        while (this.hasNext(st)) {
            int type = st.ttype;
            if (!this.notLineBreak(type)) continue;
            if (type == -2) {
                Double doubleValue = st.nval;
                if (doubleValue.equals(doubleValue.intValue())) {
                    return doubleValue.intValue();
                }
                return Float.valueOf(doubleValue.floatValue());
            }
            if (type == 91) {
                return this.parseMap(key, st);
            }
            if (type != 34) continue;
            return st.sval;
        }
        throw new IOException("value not found");
    }

    private boolean parseBoolean(StreamTokenizer st) throws IOException {
        while (this.hasNext(st)) {
            int type = st.ttype;
            if (!this.notLineBreak(type) || type != -2) continue;
            return st.nval == 1.0;
        }
        throw new IOException("boolean not found");
    }

    private Map<String, Object> parseNode(StreamTokenizer st) throws IOException {
        return this.parseElement(st, "node");
    }

    private Map<String, Object> parseEdge(StreamTokenizer st) throws IOException {
        return this.parseElement(st, "edge");
    }

    private Map<String, Object> parseElement(StreamTokenizer st, String node) throws IOException {
        this.checkValid(st, node);
        return this.parseMap(node, st);
    }

    private Map<String, Object> parseMap(String node, StreamTokenizer st) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (this.hasNext(st)) {
            int type = st.ttype;
            if (!this.notLineBreak(type)) continue;
            if (type == 93) {
                return map;
            }
            String key = st.sval;
            Object value = this.parseValue(key, st);
            map.put(key, value);
        }
        throw new IOException(node + " incomplete");
    }

    private void checkValid(StreamTokenizer st, String token) throws IOException {
        if (st.nextToken() != 91) {
            throw new IOException(token + " not followed by [");
        }
    }

    private boolean hasNext(StreamTokenizer st) throws IOException {
        return st.nextToken() != -1;
    }

    private boolean notLineBreak(int type) {
        return type != 10;
    }
}

