/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.jdbc.OrientJdbcConnection;
import com.orientechnologies.orient.jdbc.OrientJdbcDriver;
import com.orientechnologies.orient.jdbc.OrientJdbcResultSet;
import com.orientechnologies.orient.jdbc.OrientJdbcResultSetMetaData;
import com.orientechnologies.orient.jdbc.OrientJdbcStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OrientJdbcDatabaseMetaData
implements DatabaseMetaData {
    protected static final List<String> TABLE_TYPES = Arrays.asList("TABLE", "SYSTEM TABLE");
    private final OrientJdbcConnection connection;
    private final ODatabaseDocument database;
    private final OMetadata metadata;

    public OrientJdbcDatabaseMetaData(OrientJdbcConnection iConnection, ODatabaseDocument iDatabase) {
        this.connection = iConnection;
        this.database = iDatabase;
        this.metadata = this.database.getMetadata();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.database.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.database.getUser().getName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "OrientDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return OConstants.getVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "OrientDB JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return OrientJdbcDriver.getVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return 2;
    }

    @Override
    public int getDriverMinorVersion() {
        return 2;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "@rid,@class,@version,@size,@type,@this,CONTAINS,CONTAINSALL,CONTAINSKEY,CONTAINSVALUE,CONTAINSTEXT,MATCHES,TRAVERSE";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return null;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "date,sysdate";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return null;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "Function";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return null;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 1024;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        for (String fName : this.metadata.getFunctionLibrary().getFunctionNames()) {
            ODocument doc = new ODocument();
            doc.field("PROCEDURE_CAT", null);
            doc.field("PROCEDURE_SCHEM", null);
            doc.field("PROCEDURE_NAME", (Object)fName);
            doc.field("REMARKS", (Object)"");
            doc.field("PROCEDURE_TYPE", (Object)0);
            doc.field("SPECIFIC_NAME", (Object)fName);
            records.add(doc);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        OFunction f = this.metadata.getFunctionLibrary().getFunction(procedureNamePattern);
        for (String p : f.getParameters()) {
            ODocument doc = new ODocument();
            doc.field("PROCEDURE_CAT", null);
            doc.field("PROCEDURE_SCHEM", null);
            doc.field("PROCEDURE_NAME", (Object)f.getName());
            doc.field("COLUMN_NAME", (Object)p);
            doc.field("COLUMN_TYPE", (Object)1);
            doc.field("DATA_TYPE", (Object)1111);
            doc.field("SPECIFIC_NAME", (Object)f.getName());
            records.add(doc);
        }
        ODocument doc = new ODocument();
        doc.field("PROCEDURE_CAT", null);
        doc.field("PROCEDURE_SCHEM", null);
        doc.field("PROCEDURE_NAME", (Object)f.getName());
        doc.field("COLUMN_NAME", (Object)"return");
        doc.field("COLUMN_TYPE", (Object)5);
        doc.field("DATA_TYPE", (Object)1111);
        doc.field("SPECIFIC_NAME", (Object)f.getName());
        records.add(doc);
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Collection classes = this.database.getMetadata().getSchema().getClasses();
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        List<String> tableTypes = types != null ? Arrays.asList(types) : TABLE_TYPES;
        for (OClass cls : classes) {
            String className = cls.getName();
            String type = OMetadata.SYSTEM_CLUSTER.contains(cls.getName()) ? "SYSTEM TABLE" : "TABLE";
            if (!tableTypes.contains(type) || tableNamePattern != null && !tableNamePattern.equals("%") && !tableNamePattern.equalsIgnoreCase(className)) continue;
            ODocument doc = new ODocument().field("TABLE_CAT", (Object)this.database.getName()).field("TABLE_SCHEM", (Object)this.database.getName()).field("TABLE_TYPE", (Object)type).field("TABLE_NAME", (Object)className).field("REMARKS", null).field("TYPE_NAME", null).field("REF_GENERATION", null);
            records.add(doc);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        records.add(new ODocument().field("TABLE_SCHEM", (Object)this.database.getName()).field("TABLE_CATALOG", (Object)this.database.getName()));
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        records.add(new ODocument().field("TABLE_CAT", (Object)this.database.getName()));
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        OrientJdbcStatement stmt = new OrientJdbcStatement(this.connection);
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        for (String tableType : TABLE_TYPES) {
            records.add(new ODocument().field("TABLE_TYPE", (Object)tableType));
        }
        OrientJdbcResultSet result = new OrientJdbcResultSet(stmt, records, 1003, 1007, 1);
        return result;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        OClass clazz = this.database.getMetadata().getSchema().getClass(tableNamePattern);
        if (clazz != null) {
            if (columnNamePattern == null) {
                for (OProperty prop : clazz.properties()) {
                    records.add(this.getPropertyAsDocument(clazz, prop));
                }
            } else {
                OProperty prop = clazz.getProperty(columnNamePattern);
                if (prop != null) {
                    records.add(this.getPropertyAsDocument(clazz, prop));
                }
            }
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        Set classIndexes = this.metadata.getIndexManager().getClassIndexes(table);
        HashSet<Object> uniqueIndexes = new HashSet<Object>();
        for (Object oIndex : classIndexes) {
            if (!oIndex.getType().equals(OClass.INDEX_TYPE.UNIQUE.name())) continue;
            uniqueIndexes.add(oIndex);
        }
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        for (OIndex oIndex : uniqueIndexes) {
            int keyFiledSeq = 1;
            for (String keyFieldName : oIndex.getDefinition().getFields()) {
                ODocument doc = new ODocument();
                doc.field("TABLE_CAT", (Object)catalog);
                doc.field("TABLE_SCHEM", (Object)catalog);
                doc.field("TABLE_NAME", (Object)table);
                doc.field("COLUMN_NAME", (Object)keyFieldName);
                doc.field("KEY_SEQ", (Object)keyFiledSeq, new OType[]{OType.INTEGER});
                doc.field("PK_NAME", (Object)oIndex.getName());
                ++keyFiledSeq;
                records.add(doc);
            }
        }
        OrientJdbcStatement iOrientJdbcStatement = new OrientJdbcStatement(this.connection);
        OrientJdbcResultSet orientJdbcResultSet = new OrientJdbcResultSet(iOrientJdbcStatement, records, 1003, 1007, 1);
        return orientJdbcResultSet;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        ArrayList<ODocument> info = new ArrayList<ODocument>();
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.BINARY.toString()).field("DATA_TYPE", (Object)-2).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.BOOLEAN.toString()).field("DATA_TYPE", (Object)16).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.BYTE.toString()).field("DATA_TYPE", (Object)-6).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("UNSIGNED_ATTRIBUTE", (Object)true).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.DATE.toString()).field("DATA_TYPE", (Object)91).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.DATETIME.toString()).field("DATA_TYPE", (Object)91).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.DECIMAL.toString()).field("DATA_TYPE", (Object)3).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("UNSIGNED_ATTRIBUTE", (Object)false).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.FLOAT.toString()).field("DATA_TYPE", (Object)6).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("UNSIGNED_ATTRIBUTE", (Object)false).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.DOUBLE.toString()).field("DATA_TYPE", (Object)8).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("UNSIGNED_ATTRIBUTE", (Object)false).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.EMBEDDED.toString()).field("DATA_TYPE", (Object)2002).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.EMBEDDEDLIST.toString()).field("DATA_TYPE", (Object)2003).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.INTEGER.toString()).field("DATA_TYPE", (Object)4).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("UNSIGNED_ATTRIBUTE", (Object)false).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.LINKLIST.toString()).field("DATA_TYPE", (Object)2003).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.LONG.toString()).field("DATA_TYPE", (Object)-5).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("UNSIGNED_ATTRIBUTE", (Object)false).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.STRING.toString()).field("DATA_TYPE", (Object)12).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("SEARCHABLE", (Object)true));
        info.add(new ODocument().field("TYPE_NAME", (Object)OType.SHORT.toString()).field("DATA_TYPE", (Object)5).field("NULLABLE", (Object)1).field("CASE_SENSITIVE", (Object)true).field("UNSIGNED_ATTRIBUTE", (Object)false).field("SEARCHABLE", (Object)true));
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), info, 1003, 1007, 1);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (!approximate) {
            this.metadata.getIndexManager().reload();
        }
        Set classIndexes = this.metadata.getIndexManager().getClassIndexes(table);
        HashSet<Object> indexes = new HashSet<Object>();
        for (Object oIndex : classIndexes) {
            if (unique && !oIndex.getType().equals(OClass.INDEX_TYPE.UNIQUE.name())) continue;
            indexes.add(oIndex);
        }
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        for (OIndex oIndex : indexes) {
            boolean notUniqueIndex = !oIndex.getType().equals(OClass.INDEX_TYPE.UNIQUE.name());
            String fieldNames = oIndex.getDefinition().getFields().toString();
            ODocument doc = new ODocument().field("TABLE_CAT", (Object)catalog).field("TABLE_SCHEM", (Object)schema).field("TABLE_NAME", (Object)table).field("COLUMN_NAME", (Object)fieldNames.substring(1, fieldNames.length() - 2)).field("NON_UNIQUE", (Object)notUniqueIndex).field("INDEX_NAME", (Object)oIndex.getName()).field("ASC_OR_DESC", (Object)"ASC");
            records.add(doc);
        }
        OrientJdbcStatement iOrientJdbcStatement = new OrientJdbcStatement(this.connection);
        OrientJdbcResultSet orientJdbcResultSet = new OrientJdbcResultSet(iOrientJdbcStatement, records, 1003, 1007, 1);
        return orientJdbcResultSet;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        Collection classes = this.database.getMetadata().getSchema().getClasses();
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        for (OClass cls : classes) {
            ODocument doc = new ODocument();
            doc.field("TYPE_CAT", null);
            doc.field("TYPE_SCHEM", null);
            doc.field("TYPE_NAME", (Object)cls.getName());
            doc.field("CLASS_NAME", (Object)cls.getName());
            doc.field("DATA_TYPE", (Object)2002);
            doc.field("REMARKS", null);
            records.add(doc);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        OClass cls = this.database.getMetadata().getSchema().getClass(typeNamePattern);
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        if (cls != null && cls.getSuperClass() != null) {
            ODocument doc = new ODocument();
            doc.field("TABLE_CAT", (Object)catalog);
            doc.field("TABLE_SCHEM", (Object)catalog);
            doc.field("TABLE_NAME", (Object)cls.getName());
            doc.field("SUPERTYPE_CAT", (Object)catalog);
            doc.field("SUPERTYPE_SCHEM", (Object)catalog);
            doc.field("SUPERTYPE_NAME", (Object)cls.getSuperClass().getName());
            records.add(doc);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        OClass cls = this.database.getMetadata().getSchema().getClass(tableNamePattern);
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        if (cls != null && cls.getSuperClass() != null) {
            ODocument doc = new ODocument();
            doc.field("TABLE_CAT", (Object)catalog);
            doc.field("TABLE_SCHEM", (Object)catalog);
            doc.field("TABLE_NAME", (Object)cls.getName());
            doc.field("SUPERTABLE_CAT", (Object)catalog);
            doc.field("SUPERTABLE_SCHEM", (Object)catalog);
            doc.field("SUPERTABLE_NAME", (Object)cls.getSuperClass().getName());
            records.add(doc);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return null;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return Integer.valueOf("2.2.12-SNAPSHOT".split("\\.")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return Integer.valueOf("2.2.12-SNAPSHOT".split("\\.")[1].substring(0, 1));
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return null;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        for (String fName : this.metadata.getFunctionLibrary().getFunctionNames()) {
            ODocument doc = new ODocument();
            doc.field("FUNCTION_CAT", null);
            doc.field("FUNCTION_SCHEM", null);
            doc.field("FUNCTION_NAME", (Object)fName);
            doc.field("REMARKS", (Object)"");
            doc.field("FUNCTION_TYPE", (Object)0);
            doc.field("SPECIFIC_NAME", (Object)fName);
            records.add(doc);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<ODocument> records = new ArrayList<ODocument>();
        OFunction f = this.metadata.getFunctionLibrary().getFunction(functionNamePattern);
        for (String p : f.getParameters()) {
            ODocument doc = new ODocument();
            doc.field("FUNCTION_CAT", null);
            doc.field("FUNCTION_SCHEM", null);
            doc.field("FUNCTION_NAME", (Object)f.getName());
            doc.field("COLUMN_NAME", (Object)p);
            doc.field("COLUMN_TYPE", (Object)1);
            doc.field("DATA_TYPE", (Object)1111);
            doc.field("SPECIFIC_NAME", (Object)f.getName());
            records.add(doc);
        }
        ODocument doc = new ODocument();
        doc.field("FUNCTION_CAT", null);
        doc.field("FUNCTION_SCHEM", null);
        doc.field("FUNCTION_NAME", (Object)f.getName());
        doc.field("COLUMN_NAME", (Object)"return");
        doc.field("COLUMN_TYPE", (Object)5);
        doc.field("DATA_TYPE", (Object)1111);
        doc.field("SPECIFIC_NAME", (Object)f.getName());
        records.add(doc);
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), records, 1003, 1007, 1);
    }

    @Override
    public ResultSet getPseudoColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return null;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    private ODocument getPropertyAsDocument(OClass clazz, OProperty prop) {
        OType type = prop.getType();
        return new ODocument().field("TABLE_CAT", (Object)this.database.getName()).field("TABLE_NAME", (Object)clazz.getName()).field("COLUMN_NAME", (Object)prop.getName()).field("DATA_TYPE", (Object)OrientJdbcResultSetMetaData.getSqlType(type)).field("TYPE_NAME", (Object)type.name()).field("COLUMN_SIZE", (Object)1).field("NULLABLE", (Object)(!prop.isNotNull() ? 0 : 1)).field("IS_NULLABLE", (Object)(prop.isNotNull() ? "NO" : "YES"));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

