/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.jdbc.OrientJdbcConnection;
import com.orientechnologies.orient.jdbc.OrientJdbcResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OrientJdbcStatement
implements Statement {
    protected final OrientJdbcConnection connection;
    protected final ODatabaseDocument database;
    protected OCommandRequest query;
    protected List<ODocument> documents;
    protected boolean closed;
    protected Object rawResult;
    protected OrientJdbcResultSet resultSet;
    protected List<String> batches;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected int resultSetHoldability;

    public OrientJdbcStatement(OrientJdbcConnection iConnection) {
        this(iConnection, 1003, 1007, 1);
    }

    public OrientJdbcStatement(OrientJdbcConnection iConnection, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(iConnection, resultSetType, resultSetConcurrency, resultSetType);
    }

    public OrientJdbcStatement(OrientJdbcConnection iConnection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = iConnection;
        this.database = iConnection.getDatabase();
        this.database.activateOnCurrentThread();
        this.documents = Collections.emptyList();
        this.batches = new ArrayList<String>();
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        block8: {
            if ("".equals(sql)) {
                return false;
            }
            if (sql.equalsIgnoreCase("select 1")) {
                this.documents = new ArrayList<ODocument>(1);
                this.documents.add(new ODocument().field("1", (Object)1));
            } else {
                this.query = new OCommandSQL(sql);
                try {
                    this.rawResult = this.executeCommand(this.query);
                    if (this.rawResult instanceof List) {
                        this.documents = (List)this.rawResult;
                        break block8;
                    }
                    if (this.rawResult instanceof OIdentifiable) {
                        this.documents = new ArrayList<ODocument>(1);
                        this.documents.add((ODocument)((OIdentifiable)this.rawResult).getRecord());
                        break block8;
                    }
                    return false;
                }
                catch (OQueryParsingException e) {
                    throw new SQLSyntaxErrorException("Error while parsing query", e);
                }
                catch (OException e) {
                    throw new SQLException("Error while executing query", e);
                }
            }
        }
        this.resultSet = new OrientJdbcResultSet(this, this.documents, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        return true;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.execute(sql)) {
            return this.resultSet;
        }
        return null;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.query = new OCommandSQL(sql);
        this.rawResult = this.executeCommand(this.query);
        if (this.rawResult instanceof ODocument) {
            return 1;
        }
        if (this.rawResult instanceof Integer) {
            return (Integer)this.rawResult;
        }
        if (this.rawResult instanceof Collection) {
            return ((Collection)this.rawResult).size();
        }
        return 0;
    }

    protected <RET> RET executeCommand(OCommandRequest query) throws SQLException {
        try {
            return (RET)this.database.command(query).execute(new Object[0]);
        }
        catch (OQueryParsingException e) {
            throw new SQLSyntaxErrorException("Error while parsing command", e);
        }
        catch (OException e) {
            throw new SQLException("Error while executing command", e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
        this.query = null;
        this.closed = true;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batches.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batches.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] results = new int[this.batches.size()];
        int i = 0;
        for (String sql : this.batches) {
            results[i++] = this.executeUpdate(sql);
        }
        return results;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSet.getConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSet.getHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSet.getType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement already closed");
        }
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.query == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            if (this.query == null) {
                return OCommandSQL.class.isAssignableFrom(iface);
            }
            return this.query.getClass().isAssignableFrom(iface);
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this.query);
        }
        catch (ClassCastException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

