/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.jdbc.OrientBlob;
import com.orientechnologies.orient.jdbc.OrientJdbcResultSetMetaData;
import com.orientechnologies.orient.jdbc.OrientJdbcStatement;
import com.orientechnologies.orient.jdbc.OrientRowId;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class OrientJdbcResultSet
implements ResultSet {
    private List<ODocument> records = null;
    private OrientJdbcStatement statement;
    private int cursor = -1;
    private int rowCount = 0;
    private ODocument document;
    private String[] fieldNames;
    private int type;
    private int concurrency;
    private int holdability;

    protected OrientJdbcResultSet(OrientJdbcStatement iOrientJdbcStatement, List<ODocument> iRecords, int type, int concurrency, int holdability) throws SQLException {
        this.statement = iOrientJdbcStatement;
        this.records = iRecords;
        this.rowCount = iRecords.size();
        if (this.rowCount > 0) {
            this.document = (ODocument)this.records.get(0).getRecord();
            this.fieldNames = this.document.fieldNames();
        }
        this.activateDatabaseOnCurrentThread();
        if (type != 1003 && type != 1004 && type != 1005) {
            throw new SQLException("Bad ResultSet type: " + type + " instead of one of the following values: " + 1003 + ", " + 1004 + " or" + 1005);
        }
        this.type = type;
        if (concurrency != 1007 && concurrency != 1008) {
            throw new SQLException("Bad ResultSet Concurrency type: " + concurrency + " instead of one of the following values: " + 1007 + " or" + 1008);
        }
        this.concurrency = concurrency;
        if (holdability != 1 && holdability != 2) {
            throw new SQLException("Bad ResultSet Holdability type: " + holdability + " instead of one of the following values: " + 1 + " or" + 2);
        }
        this.holdability = holdability;
    }

    private void activateDatabaseOnCurrentThread() {
        this.statement.database.activateOnCurrentThread();
    }

    @Override
    public void close() throws SQLException {
        this.cursor = 0;
        this.rowCount = 0;
        this.records = null;
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(0);
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(this.rowCount - 1);
    }

    @Override
    public boolean next() throws SQLException {
        return this.absolute(++this.cursor);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.absolute(++this.cursor);
    }

    @Override
    public void afterLast() throws SQLException {
        this.cursor = this.rowCount;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.cursor = -1;
    }

    @Override
    public boolean relative(int iRows) throws SQLException {
        return this.absolute(this.cursor + iRows);
    }

    @Override
    public boolean absolute(int iRowNumber) throws SQLException {
        if (iRowNumber > this.rowCount - 1) {
            this.cursor = this.rowCount;
            return false;
        }
        if (iRowNumber < 0) {
            this.cursor = -1;
            return false;
        }
        this.cursor = iRowNumber;
        this.document = (ODocument)this.records.get(this.cursor).getRecord();
        this.fieldNames = this.document.fieldNames();
        return true;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.cursor >= this.rowCount - 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.cursor < 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.records == null;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.cursor == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.cursor == this.rowCount - 1;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new OrientJdbcResultSetMetaData(this);
    }

    @Override
    public void deleteRow() throws SQLException {
        this.document.delete();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int column = 0;
        int i = 0;
        while (i < this.fieldNames.length - 1 && column == 0) {
            if (this.fieldNames[i].equals(columnLabel)) {
                column = i + 1;
                continue;
            }
            ++i;
        }
        if (column == 0) {
            throw new SQLException("The column '" + columnLabel + "' does not exists (Result Set element: " + this.rowCount + ")");
        }
        return column;
    }

    private int getFieldIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1) {
            throw new SQLException("The column index cannot be less than 1");
        }
        return columnIndex - 1;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        try {
            return (BigDecimal)this.document.field(columnLabel, OType.DECIMAL);
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the double value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(this.fieldNames[this.getFieldIndex(columnIndex)], scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        try {
            return ((BigDecimal)this.document.field(columnLabel, OType.DECIMAL)).setScale(scale);
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the double value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        try {
            Blob blob = this.getBlob(columnLabel);
            return blob != null ? blob.getBinaryStream() : null;
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the binary stream at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getBlob(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        try {
            Object value = this.document.field(columnLabel);
            if (value instanceof OBlob) {
                return new OrientBlob((OBlob)value);
            }
            if (value instanceof ORecordLazyList) {
                ORecordLazyList list = (ORecordLazyList)value;
                ListIterator iterator = list.listIterator();
                ArrayList<OBlob> binaryRecordList = new ArrayList<OBlob>(list.size());
                while (iterator.hasNext()) {
                    OIdentifiable listElement = (OIdentifiable)iterator.next();
                    OBlob ob = (OBlob)this.document.getDatabase().load(listElement.getIdentity());
                    binaryRecordList.add(ob);
                }
                return new OrientBlob(binaryRecordList);
            }
            return null;
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the BLOB at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getBoolean(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        try {
            return (Boolean)this.document.field(columnLabel, OType.BOOLEAN);
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the boolean value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getByte(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        try {
            return (Byte)this.document.field(columnLabel, OType.BYTE);
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the byte value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getBytes(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        try {
            Object value = this.document.field(columnLabel);
            if (value == null) {
                return null;
            }
            if (value instanceof OBlob) {
                return ((OBlob)value).toStream();
            }
            return (byte[])this.document.field(columnLabel, OType.BINARY);
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the bytes value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        try {
            this.activateDatabaseOnCurrentThread();
            java.util.Date date = (java.util.Date)this.document.field(columnLabel, OType.DATETIME);
            return date != null ? new Date(date.getTime()) : null;
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the date value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(this.fieldNames[this.getFieldIndex(columnIndex)], cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        if (cal == null) {
            throw new SQLException();
        }
        try {
            this.activateDatabaseOnCurrentThread();
            java.util.Date date = (java.util.Date)this.document.field(columnLabel, OType.DATETIME);
            if (date == null) {
                return null;
            }
            cal.setTimeInMillis(date.getTime());
            return new Date(cal.getTimeInMillis());
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the date value (calendar) at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getDouble(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        try {
            Double r = (Double)this.document.field(columnLabel, OType.DOUBLE);
            return r != null ? r : 0.0;
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the double value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.rowCount;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getFloat(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        try {
            Float r = (Float)this.document.field(columnLabel, OType.FLOAT);
            return r != null ? r.floatValue() : 0.0f;
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the float value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getInt(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        if ("@version".equals(columnLabel)) {
            return this.document.getVersion();
        }
        try {
            Integer r = (Integer)this.document.field(columnLabel, OType.INTEGER);
            return r != null ? r : 0;
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the integer value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getLong(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        try {
            Long r = (Long)this.document.field(columnLabel, OType.LONG);
            return r != null ? r : 0L;
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the long value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getNString(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        try {
            return (String)this.document.field(columnLabel, OType.STRING);
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the string value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        try {
            Object value = this.document.field(columnLabel);
            if (value == null) {
                return null;
            }
            if (value instanceof ORecordLazyMultiValue) {
                ORecordLazyMultiValue lazyRecord = (ORecordLazyMultiValue)value;
                lazyRecord.convertLinks2Records();
                return lazyRecord;
            }
            return value;
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the Java Object at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("This method has not been implemented.");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("This method has not been implemented.");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public int getRow() throws SQLException {
        return this.cursor;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        try {
            return new OrientRowId(this.document.getIdentity());
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the rowid for record '" + this.document + "'", e);
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(0);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getShort(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        try {
            Short r = (Short)this.document.field(columnLabel, OType.SHORT);
            return r != null ? r : (short)0;
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the short value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getString(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        if ("@rid".equals(columnLabel)) {
            return this.document.getIdentity().toString();
        }
        if ("@class".equals(columnLabel)) {
            return this.document.getClassName();
        }
        try {
            return (String)this.document.field(columnLabel, OType.STRING);
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the string value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(this.fieldNames[this.getFieldIndex(columnIndex)]);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        try {
            java.util.Date date = (java.util.Date)this.document.field(columnLabel, OType.DATETIME);
            return this.getTime(date);
        }
        catch (Exception e) {
            throw new SQLException("An error occurred during the retrieval of the time value at column '" + columnLabel + "'", e);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(columnIndex, cal);
        return this.getTime(date);
    }

    private Time getTime(java.util.Date date) {
        return date != null ? new Time(date.getTime()) : null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        Date date = this.getDate(columnLabel, cal);
        return this.getTime(date);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Date date = this.getDate(columnIndex);
        return this.getTimestamp(date);
    }

    private Timestamp getTimestamp(Date date) {
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        Date date = this.getDate(columnLabel);
        return this.getTimestamp(date);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(columnIndex, cal);
        return this.getTimestamp(date);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        Date date = this.getDate(columnLabel, cal);
        return this.getTimestamp(date);
    }

    @Override
    public int getType() throws SQLException {
        return this.type;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
    }

    @Override
    public void updateRow() throws SQLException {
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return ODocument.class.isAssignableFrom(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this.document);
        }
        catch (ClassCastException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public <T> T getObject(int arg0, Class<T> arg1) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String arg0, Class<T> arg1) throws SQLException {
        return null;
    }
}

