/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.util.OURLConnection;
import com.orientechnologies.orient.core.util.OURLHelper;
import com.orientechnologies.orient.jdbc.OrientJdbcDatabaseMetaData;
import com.orientechnologies.orient.jdbc.OrientJdbcPreparedStatement;
import com.orientechnologies.orient.jdbc.OrientJdbcStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class OrientJdbcConnection
implements Connection {
    private ODatabaseDocument database;
    private String dbUrl;
    private Properties info;
    private OrientDB orientDB;
    private boolean readOnly;
    private boolean autoCommit;
    private ODatabase.STATUS status;
    private boolean orientDBisPrivate;

    public OrientJdbcConnection(String jdbcdDUrl, Properties info) {
        this.dbUrl = jdbcdDUrl.replace("jdbc:orient:", "");
        this.info = info;
        this.readOnly = false;
        String username = info.getProperty("user", "admin");
        String password = info.getProperty("password", "admin");
        String serverUsername = info.getProperty("serverUser", "");
        String serverPassword = info.getProperty("serverPassword", "");
        OURLConnection connUrl = OURLHelper.parseNew((String)this.dbUrl);
        this.orientDB = new OrientDB(connUrl.getType() + ":" + connUrl.getPath(), serverUsername, serverPassword, OrientDBConfig.defaultConfig());
        if (!serverUsername.isEmpty() && !serverPassword.isEmpty()) {
            this.orientDB.createIfNotExists(connUrl.getDbName(), connUrl.getDbType().orElse(ODatabaseType.MEMORY));
        }
        this.database = this.orientDB.open(connUrl.getDbName(), username, password);
        this.orientDBisPrivate = true;
        this.status = ODatabase.STATUS.OPEN;
    }

    public OrientJdbcConnection(ODatabaseDocument database, OrientDB orientDB, Properties info) {
        this.database = database;
        this.orientDB = orientDB;
        this.info = info;
        this.orientDBisPrivate = false;
        this.status = ODatabase.STATUS.OPEN;
    }

    protected OrientDB getOrientDB() {
        return this.orientDB;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new OrientJdbcStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new OrientJdbcPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public String getUrl() {
        return this.dbUrl;
    }

    @Override
    public void close() throws SQLException {
        this.status = ODatabase.STATUS.CLOSED;
        if (this.database != null) {
            this.database.activateOnCurrentThread();
            this.database.close();
            this.database = null;
        }
        if (this.orientDBisPrivate) {
            this.orientDB.close();
        }
    }

    @Override
    public void commit() throws SQLException {
        this.database.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.database.rollback();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.status == ODatabase.STATUS.CLOSED;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean iReadOnly) throws SQLException {
        this.readOnly = iReadOnly;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return true;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new OrientJdbcStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new OrientJdbcStatement(this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.database.getName();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new OrientJdbcDatabaseMetaData(this, this.getDatabase());
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new OrientJdbcPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new OrientJdbcPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new OrientJdbcPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new OrientJdbcPreparedStatement(this, resultSetType, resultSetConcurrency, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new OrientJdbcPreparedStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability, sql);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    public ODatabaseDocument getDatabase() {
        return this.database;
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT.getValueAsInteger();
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
        OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT.setValue((Object)arg1);
    }

    public Properties getInfo() {
        return this.info;
    }
}

