/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibrary;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.jdbc.OrientJdbcConnection;
import com.orientechnologies.orient.jdbc.OrientJdbcDriver;
import com.orientechnologies.orient.jdbc.OrientJdbcResultSet;
import com.orientechnologies.orient.jdbc.OrientJdbcResultSetMetaData;
import com.orientechnologies.orient.jdbc.OrientJdbcStatement;
import com.orientechnologies.orient.jdbc.OrientJdbcUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class OrientJdbcDatabaseMetaData
implements DatabaseMetaData {
    protected static final List<String> TABLE_TYPES = Arrays.asList("TABLE", "SYSTEM TABLE");
    private final OrientJdbcConnection connection;
    private final ODatabaseDocument database;
    private final OMetadata metadata;

    public OrientJdbcDatabaseMetaData(OrientJdbcConnection iConnection, ODatabaseDocument iDatabase) {
        this.connection = iConnection;
        this.database = iDatabase;
        this.metadata = this.database.getMetadata();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        this.database.activateOnCurrentThread();
        return this.database.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        this.database.activateOnCurrentThread();
        return this.database.getUser().getName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "OrientDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "3.0.0m2";
    }

    @Override
    public String getDriverName() throws SQLException {
        return "OrientDB JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return OrientJdbcDriver.getVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return 3;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "@rid,@class,@version,@size,@type,@this,CONTAINS,CONTAINSALL,CONTAINSKEY,CONTAINSVALUE,CONTAINSTEXT,MATCHES,TRAVERSE";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return null;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "date,sysdate";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return null;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "Function";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return null;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 1024;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.database.activateOnCurrentThread();
        OInternalResultSet resultSet = new OInternalResultSet();
        OFunctionLibrary functionLibrary = this.database.getMetadata().getFunctionLibrary();
        for (String functionName : functionLibrary.getFunctionNames()) {
            if (!OrientJdbcUtils.like(functionName, procedureNamePattern)) continue;
            OResultInternal element = new OResultInternal();
            element.setProperty("PROCEDURE_CAT", null);
            element.setProperty("PROCEDURE_SCHEM", null);
            element.setProperty("PROCEDURE_NAME", (Object)functionName);
            element.setProperty("REMARKS", (Object)"");
            element.setProperty("PROCEDURE_TYPE", (Object)0);
            element.setProperty("SPECIFIC_NAME", (Object)functionName);
            resultSet.add((OResult)element);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.database.activateOnCurrentThread();
        OInternalResultSet resultSet = new OInternalResultSet();
        OFunctionLibrary functionLibrary = this.database.getMetadata().getFunctionLibrary();
        for (String functionName : functionLibrary.getFunctionNames()) {
            if (!OrientJdbcUtils.like(functionName, procedureNamePattern)) continue;
            OFunction f = functionLibrary.getFunction(procedureNamePattern);
            for (String p : f.getParameters()) {
                OResultInternal doc = new OResultInternal();
                doc.setProperty("PROCEDURE_CAT", (Object)this.database.getName());
                doc.setProperty("PROCEDURE_SCHEM", (Object)this.database.getName());
                doc.setProperty("PROCEDURE_NAME", (Object)f.getName());
                doc.setProperty("COLUMN_NAME", (Object)p);
                doc.setProperty("COLUMN_TYPE", (Object)1);
                doc.setProperty("DATA_TYPE", (Object)1111);
                doc.setProperty("SPECIFIC_NAME", (Object)f.getName());
                resultSet.add((OResult)doc);
            }
            OResultInternal doc = new OResultInternal();
            doc.setProperty("PROCEDURE_CAT", (Object)this.database.getName());
            doc.setProperty("PROCEDURE_SCHEM", (Object)this.database.getName());
            doc.setProperty("PROCEDURE_NAME", (Object)f.getName());
            doc.setProperty("COLUMN_NAME", (Object)"return");
            doc.setProperty("COLUMN_TYPE", (Object)5);
            doc.setProperty("DATA_TYPE", (Object)1111);
            doc.setProperty("SPECIFIC_NAME", (Object)f.getName());
            resultSet.add((OResult)doc);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        this.database.activateOnCurrentThread();
        Collection classes = this.database.getMetadata().getSchema().getClasses();
        OInternalResultSet resultSet = new OInternalResultSet();
        List<String> tableTypes = types != null ? Arrays.asList(types) : TABLE_TYPES;
        for (OClass cls : classes) {
            String className = cls.getName();
            String type = OMetadataInternal.SYSTEM_CLUSTER.contains(cls.getName().toLowerCase(Locale.ENGLISH)) ? "SYSTEM TABLE" : "TABLE";
            if (!tableTypes.contains(type) || tableNamePattern != null && !tableNamePattern.equals("%") && !tableNamePattern.equalsIgnoreCase(className)) continue;
            OResultInternal doc = new OResultInternal();
            doc.setProperty("TABLE_CAT", (Object)this.database.getName());
            doc.setProperty("TABLE_SCHEM", (Object)this.database.getName());
            doc.setProperty("TABLE_NAME", (Object)className);
            doc.setProperty("TABLE_TYPE", (Object)type);
            doc.setProperty("REMARKS", null);
            doc.setProperty("TYPE_NAME", null);
            doc.setProperty("REF_GENERATION", null);
            resultSet.add((OResult)doc);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.database.activateOnCurrentThread();
        OInternalResultSet resultSet = new OInternalResultSet();
        OResultInternal field = new OResultInternal();
        field.setProperty("TABLE_SCHEM", (Object)this.database.getName());
        field.setProperty("TABLE_CATALOG", (Object)this.database.getName());
        resultSet.add((OResult)field);
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.database.activateOnCurrentThread();
        OInternalResultSet resultSet = new OInternalResultSet();
        OResultInternal field = new OResultInternal();
        field.setProperty("TABLE_CAT", (Object)this.database.getName());
        resultSet.add((OResult)field);
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.database.activateOnCurrentThread();
        OInternalResultSet resultSet = new OInternalResultSet();
        for (String tableType : TABLE_TYPES) {
            OResultInternal field = new OResultInternal();
            field.setProperty("TABLE_TYPE", (Object)tableType);
            resultSet.add((OResult)field);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.database.activateOnCurrentThread();
        OInternalResultSet resultSet = new OInternalResultSet();
        OSchema schema = this.database.getMetadata().getSchema();
        for (OClass clazz : schema.getClasses()) {
            if (!OrientJdbcUtils.like(clazz.getName(), tableNamePattern)) continue;
            for (OProperty prop : clazz.properties()) {
                if (columnNamePattern == null) {
                    resultSet.add((OResult)this.getPropertyAsDocument(clazz, prop));
                    continue;
                }
                if (!OrientJdbcUtils.like(prop.getName(), columnNamePattern)) continue;
                resultSet.add((OResult)this.getPropertyAsDocument(clazz, prop));
            }
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.database.activateOnCurrentThread();
        Set classIndexes = this.database.getMetadata().getIndexManager().getClassIndexes(table);
        HashSet<OIndex> uniqueIndexes = new HashSet<OIndex>();
        for (OIndex oIndex : classIndexes) {
            if (!oIndex.getType().equals(OClass.INDEX_TYPE.UNIQUE.name())) continue;
            uniqueIndexes.add(oIndex);
        }
        OInternalResultSet resultSet = new OInternalResultSet();
        for (OIndex unique : uniqueIndexes) {
            int keyFiledSeq = 1;
            for (String keyFieldName : unique.getDefinition().getFields()) {
                OResultInternal res = new OResultInternal();
                res.setProperty("TABLE_CAT", (Object)catalog);
                res.setProperty("TABLE_SCHEM", (Object)catalog);
                res.setProperty("TABLE_NAME", (Object)table);
                res.setProperty("COLUMN_NAME", (Object)keyFieldName);
                res.setProperty("KEY_SEQ", (Object)keyFiledSeq);
                res.setProperty("PK_NAME", (Object)unique.getName());
                ++keyFiledSeq;
                resultSet.add((OResult)res);
            }
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.database.activateOnCurrentThread();
        OClass aClass = this.database.getMetadata().getSchema().getClass(table);
        aClass.declaredProperties().stream().forEach(p -> p.getType());
        return this.getEmptyResultSet();
    }

    private ResultSet getEmptyResultSet() throws SQLException {
        this.database.activateOnCurrentThread();
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)new OInternalResultSet(), 1003, 1007, 1);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        OInternalResultSet resultSet = new OInternalResultSet();
        OResultInternal res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.BINARY.toString());
        res.setProperty("DATA_TYPE", (Object)-2);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.BOOLEAN.toString());
        res.setProperty("DATA_TYPE", (Object)16);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.BYTE.toString());
        res.setProperty("DATA_TYPE", (Object)-6);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("UNSIGNED_ATTRIBUTE", (Object)true);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.DATE.toString());
        res.setProperty("DATA_TYPE", (Object)91);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.DATETIME.toString());
        res.setProperty("DATA_TYPE", (Object)91);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.DECIMAL.toString());
        res.setProperty("DATA_TYPE", (Object)3);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("UNSIGNED_ATTRIBUTE", (Object)false);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.FLOAT.toString());
        res.setProperty("DATA_TYPE", (Object)6);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("UNSIGNED_ATTRIBUTE", (Object)false);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.DOUBLE.toString());
        res.setProperty("DATA_TYPE", (Object)8);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("UNSIGNED_ATTRIBUTE", (Object)false);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.EMBEDDED.toString());
        res.setProperty("DATA_TYPE", (Object)2002);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.EMBEDDEDLIST.toString());
        res.setProperty("DATA_TYPE", (Object)2003);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.INTEGER.toString());
        res.setProperty("DATA_TYPE", (Object)4);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("UNSIGNED_ATTRIBUTE", (Object)false);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.LINKLIST.toString());
        res.setProperty("DATA_TYPE", (Object)2003);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.LONG.toString());
        res.setProperty("DATA_TYPE", (Object)-5);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("UNSIGNED_ATTRIBUTE", (Object)false);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.STRING.toString());
        res.setProperty("DATA_TYPE", (Object)12);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        res = new OResultInternal();
        res.setProperty("TYPE_NAME", (Object)OType.SHORT.toString());
        res.setProperty("DATA_TYPE", (Object)5);
        res.setProperty("NULLABLE", (Object)1);
        res.setProperty("CASE_SENSITIVE", (Object)true);
        res.setProperty("UNSIGNED_ATTRIBUTE", (Object)false);
        res.setProperty("SEARCHABLE", (Object)true);
        resultSet.add((OResult)res);
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.database.activateOnCurrentThread();
        OMetadata metadata = this.database.getMetadata();
        if (!approximate) {
            metadata.getIndexManager().reload();
        }
        Set classIndexes = metadata.getIndexManager().getClassIndexes(table);
        HashSet<OIndex> indexes = new HashSet<OIndex>();
        for (OIndex oIndex : classIndexes) {
            if (unique && !oIndex.getType().equals(OClass.INDEX_TYPE.UNIQUE.name())) continue;
            indexes.add(oIndex);
        }
        OInternalResultSet resultSet = new OInternalResultSet();
        for (OIndex idx : indexes) {
            boolean notUniqueIndex = !idx.getType().equals(OClass.INDEX_TYPE.UNIQUE.name());
            String fieldNames = idx.getDefinition().getFields().toString();
            OResultInternal res = new OResultInternal();
            res.setProperty("TABLE_CAT", (Object)catalog);
            res.setProperty("TABLE_SCHEM", (Object)schema);
            res.setProperty("TABLE_NAME", (Object)table);
            res.setProperty("NON_UNIQUE", (Object)notUniqueIndex);
            res.setProperty("INDEX_QUALIFIER", null);
            res.setProperty("INDEX_NAME", (Object)idx.getName());
            res.setProperty("TYPE", (Object)idx.getType());
            res.setProperty("ORDINAL_POSITION", (Object)0);
            res.setProperty("COLUMN_NAME", (Object)fieldNames.substring(1, fieldNames.length() - 1));
            res.setProperty("ASC_OR_DESC", (Object)"ASC");
            resultSet.add((OResult)res);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        this.database.activateOnCurrentThread();
        Collection classes = this.database.getMetadata().getSchema().getClasses();
        OInternalResultSet resultSet = new OInternalResultSet();
        for (OClass cls : classes) {
            OResultInternal res = new OResultInternal();
            res.setProperty("TYPE_CAT", null);
            res.setProperty("TYPE_SCHEM", null);
            res.setProperty("TYPE_NAME", (Object)cls.getName());
            res.setProperty("CLASS_NAME", (Object)cls.getName());
            res.setProperty("DATA_TYPE", (Object)2002);
            res.setProperty("REMARKS", null);
            resultSet.add((OResult)res);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        this.database.activateOnCurrentThread();
        OClass cls = this.database.getMetadata().getSchema().getClass(typeNamePattern);
        OInternalResultSet resultSet = new OInternalResultSet();
        if (cls != null && cls.getSuperClass() != null) {
            OResultInternal res = new OResultInternal();
            res.setProperty("TABLE_CAT", (Object)catalog);
            res.setProperty("TABLE_SCHEM", (Object)catalog);
            res.setProperty("TABLE_NAME", (Object)cls.getName());
            res.setProperty("SUPERTYPE_CAT", (Object)catalog);
            res.setProperty("SUPERTYPE_SCHEM", (Object)catalog);
            res.setProperty("SUPERTYPE_NAME", (Object)cls.getSuperClass().getName());
            resultSet.add((OResult)res);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.database.activateOnCurrentThread();
        OClass cls = this.database.getMetadata().getSchema().getClass(tableNamePattern);
        OInternalResultSet resultSet = new OInternalResultSet();
        if (cls != null && cls.getSuperClass() != null) {
            OResultInternal res = new OResultInternal();
            res.setProperty("TABLE_CAT", (Object)catalog);
            res.setProperty("TABLE_SCHEM", (Object)catalog);
            res.setProperty("TABLE_NAME", (Object)cls.getName());
            res.setProperty("SUPERTABLE_CAT", (Object)catalog);
            res.setProperty("SUPERTABLE_SCHEM", (Object)catalog);
            res.setProperty("SUPERTABLE_NAME", (Object)cls.getSuperClass().getName());
            resultSet.add((OResult)res);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return Integer.valueOf("3.0.0m2".split("\\.")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return Integer.valueOf("3.0.0m2".split("\\.")[1].substring(0, 1));
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.database.activateOnCurrentThread();
        OInternalResultSet resultSet = new OInternalResultSet();
        for (String fName : this.database.getMetadata().getFunctionLibrary().getFunctionNames()) {
            OResultInternal res = new OResultInternal();
            res.setProperty("FUNCTION_CAT", null);
            res.setProperty("FUNCTION_SCHEM", null);
            res.setProperty("FUNCTION_NAME", (Object)fName);
            res.setProperty("REMARKS", (Object)"");
            res.setProperty("FUNCTION_TYPE", (Object)0);
            res.setProperty("SPECIFIC_NAME", (Object)fName);
            resultSet.add((OResult)res);
        }
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        this.database.activateOnCurrentThread();
        OInternalResultSet resultSet = new OInternalResultSet();
        OFunction f = this.database.getMetadata().getFunctionLibrary().getFunction(functionNamePattern);
        for (String p : f.getParameters()) {
            OResultInternal res = new OResultInternal();
            res.setProperty("FUNCTION_CAT", null);
            res.setProperty("FUNCTION_SCHEM", null);
            res.setProperty("FUNCTION_NAME", (Object)f.getName());
            res.setProperty("COLUMN_NAME", (Object)p);
            res.setProperty("COLUMN_TYPE", (Object)1);
            res.setProperty("DATA_TYPE", (Object)1111);
            res.setProperty("SPECIFIC_NAME", (Object)f.getName());
            resultSet.add((OResult)res);
        }
        OResultInternal res = new OResultInternal();
        res.setProperty("FUNCTION_CAT", null);
        res.setProperty("FUNCTION_SCHEM", null);
        res.setProperty("FUNCTION_NAME", (Object)f.getName());
        res.setProperty("COLUMN_NAME", (Object)"return");
        res.setProperty("COLUMN_TYPE", (Object)5);
        res.setProperty("DATA_TYPE", (Object)1111);
        res.setProperty("SPECIFIC_NAME", (Object)f.getName());
        resultSet.add((OResult)res);
        return new OrientJdbcResultSet(new OrientJdbcStatement(this.connection), (OResultSet)resultSet, 1003, 1007, 1);
    }

    @Override
    public ResultSet getPseudoColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    private OResultInternal getPropertyAsDocument(OClass clazz, OProperty prop) {
        this.database.activateOnCurrentThread();
        OType type = prop.getType();
        OResultInternal res = new OResultInternal();
        res.setProperty("TABLE_CAT", (Object)this.database.getName());
        res.setProperty("TABLE_SCHEM", (Object)this.database.getName());
        res.setProperty("TABLE_NAME", (Object)clazz.getName());
        res.setProperty("COLUMN_NAME", (Object)prop.getName());
        res.setProperty("DATA_TYPE", (Object)OrientJdbcResultSetMetaData.getSqlType(type));
        res.setProperty("TYPE_NAME", (Object)type.name());
        res.setProperty("COLUMN_SIZE", (Object)1);
        res.setProperty("BUFFER_LENGTH", null);
        res.setProperty("DECIMAL_DIGITS", null);
        res.setProperty("NUM_PREC_RADIX", (Object)10);
        res.setProperty("NULLABLE", (Object)(!prop.isNotNull() ? 0 : 1));
        res.setProperty("REMARKS", (Object)prop.getDescription());
        res.setProperty("COLUMN_DEF", (Object)prop.getDefaultValue());
        res.setProperty("SQL_DATA_TYPE", null);
        res.setProperty("SQL_DATETIME_SUB", null);
        res.setProperty("CHAR_OCTET_LENGTH", null);
        res.setProperty("ORDINAL_POSITION", (Object)prop.getId());
        res.setProperty("IS_NULLABLE", (Object)(prop.isNotNull() ? "NO" : "YES"));
        return res;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

