/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.util.OURLConnection;
import com.orientechnologies.orient.core.util.OURLHelper;
import com.orientechnologies.orient.jdbc.OrientJdbcConnection;
import com.orientechnologies.orient.jdbc.OrientJdbcDriver;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class OrientDataSource
implements DataSource {
    private PrintWriter logger;
    private int loginTimeout;
    private String dbUrl;
    private String username;
    private String password;
    private Properties info;
    private OrientDB orientDB;
    private ODatabasePool pool;

    public OrientDataSource() {
        this.info = new Properties();
        this.info.setProperty("db.usePool", "TRUE");
        this.info.setProperty("db.pool.min", "1");
        this.info.setProperty("db.pool.max", "10");
    }

    public OrientDataSource(String dbUrl, String username, String password, Properties info) {
        this.dbUrl = dbUrl;
        this.username = username;
        this.password = password;
        this.info = info;
    }

    public OrientDataSource(OrientDB orientDB) {
        this.orientDB = orientDB;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logger = out;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.username, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.orientDB == null) {
            Properties info = new Properties(this.info);
            info.put("user", username);
            info.put("password", password);
            String serverUsername = info.getProperty("serverUser", "");
            String serverPassword = info.getProperty("serverPassword", "");
            String orientDbUrl = this.dbUrl.replace("jdbc:orient:", "");
            OURLConnection connUrl = OURLHelper.parseNew((String)orientDbUrl);
            OrientDBConfig settings = OrientDBConfig.builder().addConfig(OGlobalConfiguration.DB_POOL_MIN, (Object)Integer.valueOf(info.getProperty("db.pool.min", "1"))).addConfig(OGlobalConfiguration.DB_POOL_MAX, (Object)Integer.valueOf(info.getProperty("db.pool.max", "10"))).build();
            this.orientDB = new OrientDB(connUrl.getType() + ":" + connUrl.getPath(), serverUsername, serverPassword, settings);
            if (!serverUsername.isEmpty() && !serverPassword.isEmpty()) {
                this.orientDB.createIfNotExists(connUrl.getDbName(), connUrl.getDbType().orElse(ODatabaseType.MEMORY));
            }
            this.pool = new ODatabasePool(this.orientDB, connUrl.getDbName(), username, password);
        }
        return new OrientJdbcConnection((ODatabaseDocument)this.pool.acquire(), this.orientDB, this.info);
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInfo(Properties info) {
        this.info = info;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void close() {
        this.orientDB.close();
    }

    static {
        try {
            Class.forName(OrientJdbcDriver.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            System.err.println("OrientDB DataSource unable to load OrientDB JDBC Driver");
        }
    }
}

