/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.nio;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.nio.MemoryLockerLinux;
import com.sun.jna.Native;

public class MemoryLocker {
    private static void disableUsingSystemJNA() {
        if (System.getProperty("jna.nosys") == null || !System.getProperty("jna.nosys").equals("true")) {
            System.setProperty("jna.nosys", "true");
        }
    }

    public static void lockMemory(boolean useSystemJNADisabled) {
        if (useSystemJNADisabled) {
            MemoryLocker.disableUsingSystemJNA();
        }
        try {
            int errorCode = MemoryLockerLinux.INSTANCE.mlockall(1);
            if (errorCode != 0) {
                String errorMessage;
                int lastError = Native.getLastError();
                switch (lastError) {
                    case 1: {
                        errorMessage = "The calling process does not have the appropriate privilege to perform the requested operation(EPERM).";
                        break;
                    }
                    case 11: {
                        errorMessage = "Some or all of the memory identified by the operation could not be locked when the call was made(EAGAIN).";
                        break;
                    }
                    case 12: {
                        errorMessage = "Unable to lock JVM memory. This can result in part of the JVM being swapped out, especially if mmapping of files enabled. Increase RLIMIT_MEMLOCK or run OrientDB server as root(ENOMEM).";
                        break;
                    }
                    case 22: {
                        errorMessage = "The flags argument is zero, or includes unimplemented flags(EINVAL).";
                        break;
                    }
                    case 38: {
                        errorMessage = "The implementation does not support this memory locking interface(ENOSYS).";
                        break;
                    }
                    default: {
                        errorMessage = "Unexpected exception with code " + lastError + ".";
                    }
                }
                OLogManager.instance().config(null, "[MemoryLocker.lockMemory] Error occurred while locking memory: %s", new Object[]{errorMessage});
            } else {
                OLogManager.instance().info(null, "[MemoryLocker.lockMemory] Memory locked successfully!", new Object[0]);
            }
        }
        catch (UnsatisfiedLinkError e) {
            OLogManager.instance().config(null, "[MemoryLocker.lockMemory] Cannot lock virtual memory. It seems that your OS (%s) doesn't support this feature", new Object[]{System.getProperty("os.name")});
        }
    }
}

