/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseSchemaAware;
import com.orientechnologies.orient.core.db.ODatabaseWrapperAbstract;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.object.OObjectLazyMultivalueElement;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.object.db.OCommandSQLPojoWrapper;
import com.orientechnologies.orient.object.db.OObjectNotDetachedException;
import com.orientechnologies.orient.object.db.OObjectNotManagedException;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyObject;

public abstract class ODatabasePojoAbstract<T>
extends ODatabaseWrapperAbstract<ODatabaseDocumentTx>
implements ODatabaseSchemaAware<T> {
    protected IdentityHashMap<Object, ODocument> objects2Records = new IdentityHashMap();
    protected IdentityHashMap<ODocument, T> records2Objects = new IdentityHashMap();
    protected HashMap<ORID, ODocument> rid2Records = new HashMap();
    protected boolean retainObjects = true;

    public ODatabasePojoAbstract(ODatabaseDocumentTx iDatabase) {
        super((ODatabase)iDatabase);
        iDatabase.setDatabaseOwner((ODatabaseComplex)this);
    }

    public abstract ODocument pojo2Stream(T var1, ODocument var2);

    public abstract Object stream2pojo(ODocument var1, Object var2, String var3);

    public void close() {
        this.objects2Records.clear();
        this.records2Objects.clear();
        this.rid2Records.clear();
        super.close();
    }

    public OTransaction getTransaction() {
        return ((ODatabaseDocumentTx)this.underlying).getTransaction();
    }

    public ODatabaseComplex<T> begin() {
        return ((ODatabaseDocumentTx)this.underlying).begin();
    }

    public ODatabaseComplex<T> begin(OTransaction.TXTYPE iType) {
        return ((ODatabaseDocumentTx)this.underlying).begin(iType);
    }

    public ODatabaseComplex<T> begin(OTransaction iTx) {
        return ((ODatabaseDocumentTx)this.underlying).begin(iTx);
    }

    public ODatabaseComplex<T> commit() {
        return this.commit(false);
    }

    public ODatabaseComplex<T> commit(boolean force) throws OTransactionException {
        ((ODatabaseDocumentTx)this.underlying).commit(force);
        if (!((ODatabaseDocumentTx)this.underlying).getTransaction().isActive()) {
            this.clearNewEntriesFromCache();
        }
        return this;
    }

    public ODatabaseComplex<T> rollback() {
        return this.rollback(false);
    }

    public ODatabaseComplex<T> rollback(boolean force) throws OTransactionException {
        ((ODatabaseDocumentTx)this.underlying).rollback(force);
        if (!((ODatabaseDocumentTx)this.underlying).getTransaction().isActive()) {
            this.clearNewEntriesFromCache();
            HashSet<ORID> rids = new HashSet<ORID>(this.rid2Records.keySet());
            for (ORID rid : rids) {
                T object;
                ORecord record;
                if (!rid.isTemporary() || (record = (ORecord)this.rid2Records.remove(rid)) == null || (object = this.records2Objects.remove(record)) == null) continue;
                this.objects2Records.remove(object);
            }
        }
        return this;
    }

    public void setDirty(Object iPojo) {
        if (iPojo == null) {
            return;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            throw new OObjectNotManagedException("The object " + iPojo + " is not managed by current database");
        }
        record.setDirty();
    }

    public void unsetDirty(Object iPojo) {
        if (iPojo == null) {
            return;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            return;
        }
        record.unsetDirty();
    }

    public void setInternal(ODatabase.ATTRIBUTES attribute, Object iValue) {
        ((ODatabaseDocumentTx)this.underlying).setInternal(attribute, iValue);
    }

    public ORecordVersion getVersion(Object iPojo) {
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            throw new OObjectNotManagedException("The object " + iPojo + " is not managed by current database");
        }
        return record.getRecordVersion();
    }

    public ORID getIdentity(Object iPojo) {
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            throw new OObjectNotManagedException("The object " + iPojo + " is not managed by current database");
        }
        return record.getIdentity();
    }

    public OUser getUser() {
        return ((ODatabaseDocumentTx)this.underlying).getUser();
    }

    public void setUser(OUser user) {
        ((ODatabaseDocumentTx)this.underlying).setUser(user);
    }

    public OMetadata getMetadata() {
        return ((ODatabaseDocumentTx)this.underlying).getMetadata();
    }

    public <RET extends OCommandRequest> RET command(OCommandRequest iCommand) {
        return (RET)new OCommandSQLPojoWrapper(this, ((ODatabaseDocumentTx)this.underlying).command(iCommand));
    }

    public <RET extends List<?>> RET query(OQuery<?> iCommand, Object ... iArgs) {
        this.checkOpeness();
        this.convertParameters(iArgs);
        List result = ((ODatabaseDocumentTx)this.underlying).query(iCommand, iArgs);
        if (result == null) {
            return null;
        }
        ArrayList<OIdentifiable> resultPojo = new ArrayList<OIdentifiable>();
        for (OIdentifiable doc : result) {
            if (doc instanceof ODocument) {
                Object obj = ((ODocument)doc).getClassName() == null ? doc : this.getUserObjectByRecord((OIdentifiable)((ODocument)doc), iCommand.getFetchPlan(), true);
                resultPojo.add((OIdentifiable)obj);
                continue;
            }
            resultPojo.add(doc);
        }
        return (RET)resultPojo;
    }

    public ODatabaseComplex<T> delete(ORecordInternal<?> iRecord) {
        ((ODatabaseDocumentTx)this.underlying).delete(iRecord);
        return this;
    }

    public ODatabaseComplex<T> delete(ORID iRID) {
        ((ODatabaseDocumentTx)this.underlying).delete(iRID);
        return this;
    }

    public ODatabaseComplex<T> delete(ORID iRID, ORecordVersion iVersion) {
        ((ODatabaseDocumentTx)this.underlying).delete(iRID, iVersion);
        return this;
    }

    public ODatabaseComplex<T> cleanOutRecord(ORID iRID, ORecordVersion iVersion) {
        ((ODatabaseDocumentTx)this.underlying).cleanOutRecord(iRID, iVersion);
        return this;
    }

    public <DBTYPE extends ODatabaseComplex<?>> DBTYPE registerHook(ORecordHook iHookImpl) {
        ((ODatabaseDocumentTx)this.underlying).registerHook(iHookImpl);
        return (DBTYPE)((Object)this);
    }

    public <DBTYPE extends ODatabaseComplex<?>> DBTYPE registerHook(ORecordHook iHookImpl, ORecordHook.HOOK_POSITION iPosition) {
        ((ODatabaseDocumentTx)this.underlying).registerHook(iHookImpl, iPosition);
        return (DBTYPE)((Object)this);
    }

    public ORecordHook.RESULT callbackHooks(ORecordHook.TYPE iType, OIdentifiable iObject) {
        return ((ODatabaseDocumentTx)this.underlying).callbackHooks(iType, iObject);
    }

    public Map<ORecordHook, ORecordHook.HOOK_POSITION> getHooks() {
        return ((ODatabaseDocumentTx)this.underlying).getHooks();
    }

    public <DBTYPE extends ODatabaseComplex<?>> DBTYPE unregisterHook(ORecordHook iHookImpl) {
        ((ODatabaseDocumentTx)this.underlying).unregisterHook(iHookImpl);
        return (DBTYPE)((Object)this);
    }

    public boolean isMVCC() {
        return ((ODatabaseDocumentTx)this.underlying).isMVCC();
    }

    public <DBTYPE extends ODatabaseComplex<?>> DBTYPE setMVCC(boolean iMvcc) {
        ((ODatabaseDocumentTx)this.underlying).setMVCC(iMvcc);
        return (DBTYPE)((Object)this);
    }

    public boolean isRetainObjects() {
        return this.retainObjects;
    }

    public ODatabasePojoAbstract<T> setRetainObjects(boolean iValue) {
        this.retainObjects = iValue;
        return this;
    }

    public ODocument getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
        if (iPojo instanceof ODocument) {
            return (ODocument)iPojo;
        }
        if (iPojo instanceof Proxy) {
            return ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).getDoc();
        }
        ODocument record = this.objects2Records.get(iPojo);
        if (record == null) {
            ORecordId rid = OObjectSerializerHelper.getObjectID(this, iPojo);
            if (rid != null && rid.isValid()) {
                record = this.rid2Records.get(rid);
                if (record == null) {
                    record = (ODocument)((ODatabaseDocumentTx)this.underlying).load((ORID)rid);
                }
            } else if (iCreateIfNotAvailable) {
                record = ((ODatabaseDocumentTx)this.underlying).newInstance(iPojo.getClass().getSimpleName());
            } else {
                return null;
            }
            this.registerUserObject(iPojo, (ORecordInternal<?>)record);
        }
        return record;
    }

    public boolean existsUserObjectByRID(ORID iRID) {
        return this.rid2Records.containsKey(iRID);
    }

    public ODocument getRecordById(ORID iRecordId) {
        return iRecordId.isValid() ? this.rid2Records.get(iRecordId) : null;
    }

    public boolean isManaged(Object iEntity) {
        return this.objects2Records.containsKey(iEntity);
    }

    public T getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan) {
        return this.getUserObjectByRecord(iRecord, iFetchPlan, true);
    }

    public T getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan, boolean iCreate) {
        Object pojo;
        if (!(iRecord instanceof ODocument)) {
            return null;
        }
        ODocument record = this.rid2Records.get(iRecord.getIdentity());
        if (record == null) {
            record = (ODocument)iRecord;
        }
        if ((pojo = this.records2Objects.get(record)) == null && iCreate) {
            this.checkOpeness();
            try {
                if (iRecord.getRecord().getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record = (ODocument)record.load();
                }
                pojo = this.newInstance(record.getClassName());
                this.registerUserObject(pojo, (ORecordInternal<?>)record);
                this.stream2pojo(record, pojo, iFetchPlan);
            }
            catch (Exception e) {
                throw new OConfigurationException("Cannot retrieve pojo from record " + record, (Throwable)e);
            }
        }
        return pojo;
    }

    public void attach(Object iPojo) {
        this.checkOpeness();
        ODocument record = this.objects2Records.get(iPojo);
        if (record != null) {
            return;
        }
        if (!OObjectSerializerHelper.hasObjectID(iPojo)) {
            throw new OObjectNotDetachedException("Cannot attach a non-detached object");
        }
    }

    public <RET> RET detach(Object iPojo) {
        this.checkOpeness();
        for (Field field : iPojo.getClass().getDeclaredFields()) {
            Object value = OObjectSerializerHelper.getFieldValue(iPojo, field.getName());
            if (!(value instanceof OObjectLazyMultivalueElement)) continue;
            ((OObjectLazyMultivalueElement)value).detach(false);
        }
        return (RET)iPojo;
    }

    public void registerUserObject(Object iObject, ORecordInternal<?> iRecord) {
        if (!(iRecord instanceof ODocument)) {
            return;
        }
        ODocument doc = (ODocument)iRecord;
        boolean isTombstone = doc.getRecordVersion().isTombstone();
        if (this.retainObjects) {
            ORID rid;
            if (iObject != null) {
                if (!isTombstone) {
                    this.objects2Records.put(iObject, doc);
                    this.records2Objects.put(doc, iObject);
                }
                OObjectSerializerHelper.setObjectID(iRecord.getIdentity(), iObject);
                OObjectSerializerHelper.setObjectVersion(iRecord.getRecordVersion().copy(), iObject);
            }
            if ((rid = iRecord.getIdentity()).isValid() && !isTombstone) {
                this.rid2Records.put(rid, doc);
            }
        }
    }

    public void unregisterPojo(T iObject, ODocument iRecord) {
        if (iObject != null) {
            this.objects2Records.remove(iObject);
        }
        if (iRecord != null) {
            this.records2Objects.remove(iRecord);
            ORID rid = iRecord.getIdentity();
            if (rid.isValid()) {
                this.rid2Records.remove(rid);
            }
        }
    }

    protected void clearNewEntriesFromCache() {
        Map.Entry<Object, Object> entry;
        Iterator<Map.Entry<Object, Object>> it = this.rid2Records.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!entry.getKey().isNew()) continue;
            it.remove();
        }
        it = this.objects2Records.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!entry.getValue().getIdentity().isNew()) continue;
            it.remove();
        }
        it = this.records2Objects.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!((ODocument)entry.getKey()).getIdentity().isNew()) continue;
            it.remove();
        }
    }

    protected void convertParameters(Object ... iArgs) {
        if (iArgs == null) {
            return;
        }
        for (int i = 0; i < iArgs.length; ++i) {
            iArgs[i] = this.convertParameter(iArgs[i]);
        }
    }

    protected Object convertParameter(Object iParameter) {
        if (iParameter != null) {
            ORID rid;
            if (iParameter instanceof Map) {
                Map map = (Map)iParameter;
                for (Map.Entry e : map.entrySet()) {
                    map.put(e.getKey(), this.convertParameter(e.getValue()));
                }
                return map;
            }
            if (iParameter instanceof Collection) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object object : (Collection)iParameter) {
                    result.add(this.convertParameter(object));
                }
                return result;
            }
            if (iParameter.getClass().isEnum()) {
                return ((Enum)iParameter).name();
            }
            if (!OType.isSimpleType((Object)iParameter) && (rid = this.getIdentity(iParameter)) != null && rid.isValid()) {
                return rid;
            }
        }
        return iParameter;
    }
}

