/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement.field;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.object.enhancement.field.ODocumentFieldHandlingStrategy;
import com.orientechnologies.orient.object.enhancement.field.ODocumentFieldHandlingStrategyRegistry;
import com.orientechnologies.orient.object.enhancement.field.ODocumentFieldOTypeHandlingStrategy;
import com.orientechnologies.orient.object.enhancement.field.ODocumentSingleRecordBytesOTypeHandlingStrategy;
import com.orientechnologies.orient.object.enhancement.field.ODocumentSmartFieldHandlingStrategy;
import com.orientechnologies.orient.object.enhancement.field.ODocumentSplitRecordBytesOTypeHandlingStrategy;
import java.util.HashMap;
import java.util.Optional;

public class ODocumentFieldHandlingStrategyFactory {
    public static final int SIMPLE = 0;
    public static final int SINGLE_ORECORD_BYTES = 1;
    public static final int SPLIT_ORECORD_BYTES = 2;
    private static final ODocumentFieldHandlingStrategyFactory INSTANCE = new ODocumentFieldHandlingStrategyFactory();

    private ODocumentFieldHandlingStrategyFactory() {
    }

    public static ODocumentFieldHandlingStrategyFactory getInstance() {
        return INSTANCE;
    }

    public ODocumentFieldHandlingStrategy create(int strategy) {
        Optional<ODocumentFieldHandlingStrategy> registered = ODocumentFieldHandlingStrategyRegistry.getInstance().getStrategy(strategy);
        if (registered.isPresent()) {
            return registered.get();
        }
        HashMap<OType, ODocumentFieldOTypeHandlingStrategy> typeHandlingStrategies = new HashMap<OType, ODocumentFieldOTypeHandlingStrategy>();
        switch (strategy) {
            case 1: {
                typeHandlingStrategies.put(OType.BINARY, new ODocumentSingleRecordBytesOTypeHandlingStrategy());
                break;
            }
            case 2: {
                typeHandlingStrategies.put(OType.BINARY, new ODocumentSplitRecordBytesOTypeHandlingStrategy());
                break;
            }
        }
        ODocumentSmartFieldHandlingStrategy strategyInstance = new ODocumentSmartFieldHandlingStrategy(typeHandlingStrategies);
        ODocumentFieldHandlingStrategyRegistry.getInstance().registerStrategy(strategy, strategyInstance);
        return strategyInstance;
    }
}

