/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement.field;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.enhancement.field.ODocumentFieldOTypeHandlingStrategy;
import com.orientechnologies.orient.object.enhancement.field.ODocumentSimpleFieldHandlingStrategy;
import java.util.HashMap;
import java.util.Map;

public class ODocumentSmartFieldHandlingStrategy
extends ODocumentSimpleFieldHandlingStrategy {
    private final Map<OType, ODocumentFieldOTypeHandlingStrategy> customTypeHandlers = new HashMap<OType, ODocumentFieldOTypeHandlingStrategy>();

    public ODocumentSmartFieldHandlingStrategy(Map<OType, ODocumentFieldOTypeHandlingStrategy> typeHandlers) {
        this.customTypeHandlers.putAll(typeHandlers);
        for (OType oType : this.customTypeHandlers.keySet()) {
            ODocumentFieldOTypeHandlingStrategy currentStrategy;
            if (oType.equals((Object)(currentStrategy = this.customTypeHandlers.get(oType)).getOType())) continue;
            throw new IllegalArgumentException("Strategy " + currentStrategy.getClass() + " can not handle fields with type: " + oType);
        }
    }

    @Override
    public ODocument store(ODocument iRecord, String fieldName, Object fieldValue, OType suggestedFieldType) {
        OType fieldType = this.deriveFieldType(iRecord, fieldName, suggestedFieldType);
        if (fieldType == null) {
            return super.store(iRecord, fieldName, fieldValue, suggestedFieldType);
        }
        if (this.customTypeHandlers.containsKey(fieldType)) {
            return this.customTypeHandlers.get(fieldType).store(iRecord, fieldName, fieldValue);
        }
        return super.store(iRecord, fieldName, fieldValue, suggestedFieldType);
    }

    @Override
    public Object load(ODocument iRecord, String fieldName, OType suggestedFieldType) {
        OType fieldType = this.deriveFieldType(iRecord, fieldName, suggestedFieldType);
        if (this.customTypeHandlers.containsKey(fieldType)) {
            return this.customTypeHandlers.get(fieldType).load(iRecord, fieldName);
        }
        return super.load(iRecord, fieldName, suggestedFieldType);
    }
}

